/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.util;

import com.etka.nomadsshell.util.FluidStackData;
import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class ShellFluidTank
implements IFluidHandler {
    private final Player player;
    private final int tankIndex;

    public ShellFluidTank(Player player, int tankIndex) {
        this.player = player;
        this.tankIndex = tankIndex;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        if (tank != 0) {
            return FluidStack.EMPTY;
        }
        FluidStackData data = WidgetDataHelper.getTankFluid(this.player, this.tankIndex);
        if (data == null || data.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(data.fluid(), Math.max(0, data.amount()));
    }

    public int getTankCapacity(int tank) {
        if (tank != 0) {
            return 0;
        }
        return Math.max(0, WidgetDataHelper.getTankCapacity(this.player, this.tankIndex));
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return tank == 0 && stack != null && !stack.isEmpty();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null || resource.isEmpty()) {
            return 0;
        }
        FluidStack current = this.getFluidInTank(0);
        int capacity = this.getTankCapacity(0);
        if (capacity <= 0) {
            return 0;
        }
        if (!current.isEmpty() && current.getFluid() != resource.getFluid()) {
            return 0;
        }
        int space = capacity - current.getAmount();
        if (space <= 0) {
            return 0;
        }
        int toFill = Math.min(space, resource.getAmount());
        if (toFill > 0 && action.execute()) {
            int newAmount = current.getAmount() + toFill;
            FluidStackData newData = new FluidStackData(resource.getFluid(), newAmount);
            WidgetDataHelper.setTankFluid(this.player, this.tankIndex, newData);
        }
        return toFill;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null || resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack current = this.getFluidInTank(0);
        if (current.isEmpty() || current.getFluid() != resource.getFluid()) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        FluidStack current = this.getFluidInTank(0);
        if (current.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int toDrain = Math.min(maxDrain, current.getAmount());
        FluidStack drained = new FluidStack(current.getFluid(), toDrain);
        if (toDrain > 0 && action.execute()) {
            int remaining = current.getAmount() - toDrain;
            if (remaining <= 0) {
                WidgetDataHelper.setTankFluid(this.player, this.tankIndex, FluidStackData.EMPTY);
            } else {
                WidgetDataHelper.setTankFluid(this.player, this.tankIndex, new FluidStackData(current.getFluid(), remaining));
            }
        }
        return drained;
    }
}

