/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.util;

import com.etka.nomadsshell.init.ModItems;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.item.ShellTier;
import com.etka.nomadsshell.util.ContainerUtils;
import java.util.ArrayList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;

public class ShellUpgradeHelper {
    public static ItemStack upgradeshell(ItemStack currentshell, ShellTier newTier) {
        Item item = currentshell.getItem();
        if (!(item instanceof ShellItem)) {
            return ItemStack.EMPTY;
        }
        ShellItem currentShellItem = (ShellItem)item;
        ShellTier currentTier = currentShellItem.getTier();
        if (newTier.ordinal() <= currentTier.ordinal()) {
            return ItemStack.EMPTY;
        }
        ItemContainerContents currentContents = ShellItem.getshellContents(currentshell);
        ItemStack newshell = ShellUpgradeHelper.createshellOfTier(newTier);
        ShellUpgradeHelper.transferContents(currentContents, newshell, currentTier.getTotalSlots(), newTier.getTotalSlots());
        return newshell;
    }

    public static ItemStack createshellOfTier(ShellTier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case ShellTier.LEATHER -> new ItemStack((ItemLike)ModItems.shell.get());
            case ShellTier.COPPER -> new ItemStack((ItemLike)ModItems.COPPER_shell.get());
            case ShellTier.IRON -> new ItemStack((ItemLike)ModItems.IRON_shell.get());
            case ShellTier.GOLD -> new ItemStack((ItemLike)ModItems.GOLD_shell.get());
            case ShellTier.EMERALD -> new ItemStack((ItemLike)ModItems.EMERALD_shell.get());
            case ShellTier.DIAMOND -> new ItemStack((ItemLike)ModItems.DIAMOND_shell.get());
            case ShellTier.DIAMOND_BLOCK -> new ItemStack((ItemLike)ModItems.DIAMOND_BLOCK_shell.get());
            case ShellTier.NETHERITE -> new ItemStack((ItemLike)ModItems.NETHERITE_shell.get());
        };
    }

    private static void transferContents(ItemContainerContents oldContents, ItemStack newshell, int oldSize, int newSize) {
        ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
        for (int i = 0; i < Math.min(oldSize, oldContents.getSlots()); ++i) {
            newItems.add(oldContents.getStackInSlot(i));
        }
        while (newItems.size() < newSize) {
            newItems.add(ItemStack.EMPTY);
        }
        ShellItem.setshellContents(newshell, ContainerUtils.createSafeContainerContents(newItems));
    }

    public static int getMaxScrollOffset(ShellTier tier) {
        int rows = tier.getRows();
        int visibleRows = ShellUpgradeHelper.getVisibleRows(tier);
        return Math.max(0, rows - visibleRows);
    }

    public static int getVisibleRows(ShellTier tier) {
        return tier.getRows();
    }

    public static boolean needsScrolling(ShellTier tier) {
        return tier.getRows() > ShellUpgradeHelper.getVisibleRows(tier);
    }
}

