/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.util;

import com.etka.nomadsshell.inventory.VirtualInventory;
import com.etka.nomadsshell.item.ShellItem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class VirtualInventoryUtils {
    public static ItemStack addItemToVirtualShell(Player player, ItemStack itemToAdd) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return itemToAdd;
        }
        VirtualInventory inventory = ShellItem.getVirtualInventory(shell);
        ItemStack remaining = inventory.addItem(itemToAdd);
        ShellItem.setVirtualInventory(shell, inventory);
        return remaining;
    }

    public static int countItemInVirtualShell(Player player, Item item) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 0;
        }
        VirtualInventory inventory = ShellItem.getVirtualInventory(shell);
        return inventory.countItem(item);
    }

    public static int removeItemFromVirtualShell(Player player, Item item, int count) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 0;
        }
        VirtualInventory inventory = ShellItem.getVirtualInventory(shell);
        int removed = 0;
        int remaining = count;
        for (int slot = 0; slot < inventory.getTotalSlots() && remaining > 0; ++slot) {
            ItemStack stack = inventory.getItem(slot);
            if (stack.getItem() != item) continue;
            int toRemove = Math.min(remaining, stack.getCount());
            ItemStack removedStack = inventory.removeItem(slot, toRemove);
            removed += removedStack.getCount();
            remaining -= removedStack.getCount();
        }
        if (removed > 0) {
            ShellItem.setVirtualInventory(shell, inventory);
        }
        return removed;
    }

    public static boolean hasSpaceForItem(Player player, ItemStack itemStack) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        VirtualInventory inventory = ShellItem.getVirtualInventory(shell);
        if (inventory.findFirstEmptySlot() != -1) {
            return true;
        }
        for (int slot = 0; slot < inventory.getTotalSlots(); ++slot) {
            int space;
            ItemStack existing = inventory.getItem(slot);
            if (existing.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)itemStack) || (space = existing.getMaxStackSize() - existing.getCount()) <= 0) continue;
            return true;
        }
        return false;
    }

    public static int getEmptySlotCount(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 0;
        }
        VirtualInventory inventory = ShellItem.getVirtualInventory(shell);
        int emptySlots = 0;
        for (int slot = 0; slot < inventory.getTotalSlots(); ++slot) {
            if (!inventory.getItem(slot).isEmpty()) continue;
            ++emptySlots;
        }
        return emptySlots;
    }

    public static VirtualInventory convertLegacyContents(ItemContainerContents contents, int width, int height) {
        VirtualInventory inventory = new VirtualInventory(width, height);
        for (int i = 0; i < Math.min(contents.getSlots(), inventory.getTotalSlots()); ++i) {
            ItemStack stack = contents.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            inventory.setItem(i, stack);
        }
        return inventory;
    }
}

