/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.util;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.inventory.VirtualInventory;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.ShellMenu;
import com.etka.nomadsshell.menu.VirtualShellMenu;
import com.etka.nomadsshell.util.AutoCraftRecipe;
import com.etka.nomadsshell.util.ContainerUtils;
import com.etka.nomadsshell.util.FluidStackData;
import com.etka.nomadsshell.util.ItemStackData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluids;

public class WidgetDataHelper {
    public static ItemStack getTrashBinItem(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStackData data = (ItemStackData)shell.getOrDefault(ModDataComponents.TRASH_BIN_ITEM.get(), (Object)ItemStackData.EMPTY);
        return data.toItemStack();
    }

    public static void setTrashBinItem(Player player, ItemStack item) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            ItemStackData data = item.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(item);
            shell.set(ModDataComponents.TRASH_BIN_ITEM.get(), (Object)data);
        }
    }

    public static void clearTrashBinItem(Player player) {
        WidgetDataHelper.setTrashBinItem(player, ItemStack.EMPTY);
    }

    public static ItemStack getFurnaceInputItem(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStackData data = (ItemStackData)shell.getOrDefault(ModDataComponents.FURNACE_INPUT_ITEM.get(), (Object)ItemStackData.EMPTY);
        return data.toItemStack();
    }

    public static void setFurnaceInputItem(Player player, ItemStack item) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            ItemStackData data = item.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(item);
            shell.set(ModDataComponents.FURNACE_INPUT_ITEM.get(), (Object)data);
        }
    }

    public static ItemStack getInputTagRecorderGhost(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStackData data = (ItemStackData)shell.getOrDefault(ModDataComponents.FURNACE_INPUT_TAG_RECORDER_ITEM.get(), (Object)ItemStackData.EMPTY);
        return data.toItemStack();
    }

    public static void setInputTagRecorderGhost(Player player, ItemStack stack) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        shell.set(ModDataComponents.FURNACE_INPUT_TAG_RECORDER_ITEM.get(), (Object)(stack.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(stack)));
    }

    public static int getInputTagRecorderIndex(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 0;
        }
        return (Integer)shell.getOrDefault(ModDataComponents.FURNACE_INPUT_TAG_RECORDER_INDEX.get(), (Object)0);
    }

    public static void setInputTagRecorderIndex(Player player, int idx) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        shell.set(ModDataComponents.FURNACE_INPUT_TAG_RECORDER_INDEX.get(), (Object)idx);
    }

    public static ItemStack getFuelTagRecorderGhost(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStackData data = (ItemStackData)shell.getOrDefault(ModDataComponents.FURNACE_FUEL_TAG_RECORDER_ITEM.get(), (Object)ItemStackData.EMPTY);
        return data.toItemStack();
    }

    public static void setFuelTagRecorderGhost(Player player, ItemStack stack) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        shell.set(ModDataComponents.FURNACE_FUEL_TAG_RECORDER_ITEM.get(), (Object)(stack.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(stack)));
    }

    public static int getFuelTagRecorderIndex(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 0;
        }
        return (Integer)shell.getOrDefault(ModDataComponents.FURNACE_FUEL_TAG_RECORDER_INDEX.get(), (Object)0);
    }

    public static void setFuelTagRecorderIndex(Player player, int idx) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        shell.set(ModDataComponents.FURNACE_FUEL_TAG_RECORDER_INDEX.get(), (Object)idx);
    }

    public static ItemStack getFurnaceFuelItem(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStackData data = (ItemStackData)shell.getOrDefault(ModDataComponents.FURNACE_FUEL_ITEM.get(), (Object)ItemStackData.EMPTY);
        return data.toItemStack();
    }

    public static void setFurnaceFuelItem(Player player, ItemStack item) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            ItemStackData data = item.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(item);
            shell.set(ModDataComponents.FURNACE_FUEL_ITEM.get(), (Object)data);
        }
    }

    public static ItemStack getFurnaceOutputItem(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStackData data = (ItemStackData)shell.getOrDefault(ModDataComponents.FURNACE_OUTPUT_ITEM.get(), (Object)ItemStackData.EMPTY);
        return data.toItemStack();
    }

    public static void setFurnaceOutputItem(Player player, ItemStack item) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            ItemStackData data = item.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(item);
            shell.set(ModDataComponents.FURNACE_OUTPUT_ITEM.get(), (Object)data);
        }
    }

    public static int getFurnaceSmeltingProgress(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 0;
        }
        return (Integer)shell.getOrDefault(ModDataComponents.FURNACE_SMELTING_PROGRESS.get(), (Object)0);
    }

    public static void setFurnaceSmeltingProgress(Player player, int progress) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.FURNACE_SMELTING_PROGRESS.get(), (Object)Math.max(0, progress));
        }
    }

    public static int getFurnaceFuelBurnTime(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 0;
        }
        return (Integer)shell.getOrDefault(ModDataComponents.FURNACE_FUEL_BURN_TIME.get(), (Object)0);
    }

    public static void setFurnaceFuelBurnTime(Player player, int burnTime) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.FURNACE_FUEL_BURN_TIME.get(), (Object)Math.max(0, burnTime));
        }
    }

    public static int getFurnaceMaxFuelBurnTime(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 0;
        }
        return (Integer)shell.getOrDefault(ModDataComponents.FURNACE_MAX_FUEL_BURN_TIME.get(), (Object)0);
    }

    public static void setFurnaceMaxFuelBurnTime(Player player, int maxBurnTime) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.FURNACE_MAX_FUEL_BURN_TIME.get(), (Object)Math.max(0, maxBurnTime));
        }
    }

    public static void clearFurnaceData(Player player) {
        WidgetDataHelper.setFurnaceInputItem(player, ItemStack.EMPTY);
        WidgetDataHelper.setFurnaceFuelItem(player, ItemStack.EMPTY);
        WidgetDataHelper.setFurnaceOutputItem(player, ItemStack.EMPTY);
        WidgetDataHelper.setFurnaceSmeltingProgress(player, 0);
        WidgetDataHelper.setFurnaceFuelBurnTime(player, 0);
        WidgetDataHelper.setFurnaceMaxFuelBurnTime(player, 0);
    }

    public static int getDefaultTankCapacity(WidgetUnlockSystem.WidgetType type, WidgetUnlockSystem.WidgetTier tier, int tankIndex) {
        return switch (tier) {
            case WidgetUnlockSystem.WidgetTier.TIER_I -> 3000;
            case WidgetUnlockSystem.WidgetTier.TIER_II -> 6000;
            case WidgetUnlockSystem.WidgetTier.TIER_III -> 6000;
            case WidgetUnlockSystem.WidgetTier.TIER_IV -> 6000;
            case WidgetUnlockSystem.WidgetTier.TIER_V -> 12000;
            case WidgetUnlockSystem.WidgetTier.TIER_VI -> 12000;
            case WidgetUnlockSystem.WidgetTier.TIER_VII -> 20000;
            case WidgetUnlockSystem.WidgetTier.TIER_VIII -> 20000;
            case WidgetUnlockSystem.WidgetTier.TIER_IX, WidgetUnlockSystem.WidgetTier.TIER_X -> 20000;
            default -> 3000;
        };
    }

    public static FluidStackData getTankFluid(Player player, int tankIndex) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return FluidStackData.EMPTY;
        }
        if (tankIndex == 1) {
            return (FluidStackData)shell.getOrDefault(ModDataComponents.TANK1_FLUID.get(), (Object)FluidStackData.EMPTY);
        }
        if (tankIndex == 2) {
            return (FluidStackData)shell.getOrDefault(ModDataComponents.TANK2_FLUID.get(), (Object)FluidStackData.EMPTY);
        }
        if (tankIndex == 3) {
            return (FluidStackData)shell.getOrDefault(ModDataComponents.TANK3_FLUID.get(), (Object)FluidStackData.EMPTY);
        }
        if (tankIndex == 4) {
            return (FluidStackData)shell.getOrDefault(ModDataComponents.TANK4_FLUID.get(), (Object)FluidStackData.EMPTY);
        }
        if (tankIndex == 5) {
            return (FluidStackData)shell.getOrDefault(ModDataComponents.TANK5_FLUID.get(), (Object)FluidStackData.EMPTY);
        }
        return FluidStackData.EMPTY;
    }

    public static ItemStack getTankPotionItem(Player player, int tankIndex) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (tankIndex == 1) {
            return ((ItemStackData)shell.getOrDefault(ModDataComponents.TANK1_POTION_ITEM.get(), (Object)ItemStackData.EMPTY)).toItemStack();
        }
        if (tankIndex == 2) {
            return ((ItemStackData)shell.getOrDefault(ModDataComponents.TANK2_POTION_ITEM.get(), (Object)ItemStackData.EMPTY)).toItemStack();
        }
        if (tankIndex == 3) {
            return ((ItemStackData)shell.getOrDefault(ModDataComponents.TANK3_POTION_ITEM.get(), (Object)ItemStackData.EMPTY)).toItemStack();
        }
        if (tankIndex == 4) {
            return ((ItemStackData)shell.getOrDefault(ModDataComponents.TANK4_POTION_ITEM.get(), (Object)ItemStackData.EMPTY)).toItemStack();
        }
        if (tankIndex == 5) {
            return ((ItemStackData)shell.getOrDefault(ModDataComponents.TANK5_POTION_ITEM.get(), (Object)ItemStackData.EMPTY)).toItemStack();
        }
        return ItemStack.EMPTY;
    }

    public static PotionContents getTankPotionContents(Player player, int tankIndex) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return PotionContents.EMPTY;
        }
        if (tankIndex == 1) {
            return (PotionContents)shell.getOrDefault(ModDataComponents.TANK1_POTION_CONTENTS.get(), (Object)PotionContents.EMPTY);
        }
        if (tankIndex == 2) {
            return (PotionContents)shell.getOrDefault(ModDataComponents.TANK2_POTION_CONTENTS.get(), (Object)PotionContents.EMPTY);
        }
        if (tankIndex == 3) {
            return (PotionContents)shell.getOrDefault(ModDataComponents.TANK3_POTION_CONTENTS.get(), (Object)PotionContents.EMPTY);
        }
        if (tankIndex == 4) {
            return (PotionContents)shell.getOrDefault(ModDataComponents.TANK4_POTION_CONTENTS.get(), (Object)PotionContents.EMPTY);
        }
        if (tankIndex == 5) {
            return (PotionContents)shell.getOrDefault(ModDataComponents.TANK5_POTION_CONTENTS.get(), (Object)PotionContents.EMPTY);
        }
        return PotionContents.EMPTY;
    }

    public static void setTankPotionContents(Player player, int tankIndex, PotionContents contents) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        if (tankIndex == 1) {
            shell.set(ModDataComponents.TANK1_POTION_CONTENTS.get(), (Object)contents);
        } else if (tankIndex == 2) {
            shell.set(ModDataComponents.TANK2_POTION_CONTENTS.get(), (Object)contents);
        } else if (tankIndex == 3) {
            shell.set(ModDataComponents.TANK3_POTION_CONTENTS.get(), (Object)contents);
        } else if (tankIndex == 4) {
            shell.set(ModDataComponents.TANK4_POTION_CONTENTS.get(), (Object)contents);
        } else if (tankIndex == 5) {
            shell.set(ModDataComponents.TANK5_POTION_CONTENTS.get(), (Object)contents);
        }
    }

    public static void setTankPotionItem(Player player, int tankIndex, ItemStack item) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        ItemStackData data = item.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(item.copy());
        switch (tankIndex) {
            case 1: {
                shell.set(ModDataComponents.TANK1_POTION_ITEM.get(), (Object)data);
                break;
            }
            case 2: {
                shell.set(ModDataComponents.TANK2_POTION_ITEM.get(), (Object)data);
                break;
            }
            case 3: {
                shell.set(ModDataComponents.TANK3_POTION_ITEM.get(), (Object)data);
                break;
            }
            case 4: {
                shell.set(ModDataComponents.TANK4_POTION_ITEM.get(), (Object)data);
                break;
            }
            case 5: {
                shell.set(ModDataComponents.TANK5_POTION_ITEM.get(), (Object)data);
            }
        }
    }

    public static PotionContents getTankWaterContents(Player player, int tankIndex) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return PotionContents.EMPTY;
        }
        return switch (tankIndex) {
            case 1 -> (PotionContents)shell.getOrDefault(ModDataComponents.TANK1_WATER_CONTENTS.get(), (Object)PotionContents.EMPTY);
            case 2 -> (PotionContents)shell.getOrDefault(ModDataComponents.TANK2_WATER_CONTENTS.get(), (Object)PotionContents.EMPTY);
            case 3 -> (PotionContents)shell.getOrDefault(ModDataComponents.TANK3_WATER_CONTENTS.get(), (Object)PotionContents.EMPTY);
            case 4 -> (PotionContents)shell.getOrDefault(ModDataComponents.TANK4_WATER_CONTENTS.get(), (Object)PotionContents.EMPTY);
            case 5 -> (PotionContents)shell.getOrDefault(ModDataComponents.TANK5_WATER_CONTENTS.get(), (Object)PotionContents.EMPTY);
            default -> PotionContents.EMPTY;
        };
    }

    public static void setTankWaterContents(Player player, int tankIndex, PotionContents contents) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        switch (tankIndex) {
            case 1: {
                shell.set(ModDataComponents.TANK1_WATER_CONTENTS.get(), (Object)contents);
                break;
            }
            case 2: {
                shell.set(ModDataComponents.TANK2_WATER_CONTENTS.get(), (Object)contents);
                break;
            }
            case 3: {
                shell.set(ModDataComponents.TANK3_WATER_CONTENTS.get(), (Object)contents);
                break;
            }
            case 4: {
                shell.set(ModDataComponents.TANK4_WATER_CONTENTS.get(), (Object)contents);
                break;
            }
            case 5: {
                shell.set(ModDataComponents.TANK5_WATER_CONTENTS.get(), (Object)contents);
            }
        }
    }

    public static ItemStack getTankWaterItem(Player player, int tankIndex) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return switch (tankIndex) {
            case 1 -> ((ItemStackData)shell.getOrDefault(ModDataComponents.TANK1_WATER_ITEM.get(), (Object)ItemStackData.EMPTY)).toItemStack();
            case 2 -> ((ItemStackData)shell.getOrDefault(ModDataComponents.TANK2_WATER_ITEM.get(), (Object)ItemStackData.EMPTY)).toItemStack();
            case 3 -> ((ItemStackData)shell.getOrDefault(ModDataComponents.TANK3_WATER_ITEM.get(), (Object)ItemStackData.EMPTY)).toItemStack();
            case 4 -> ((ItemStackData)shell.getOrDefault(ModDataComponents.TANK4_WATER_ITEM.get(), (Object)ItemStackData.EMPTY)).toItemStack();
            case 5 -> ((ItemStackData)shell.getOrDefault(ModDataComponents.TANK5_WATER_ITEM.get(), (Object)ItemStackData.EMPTY)).toItemStack();
            default -> ItemStack.EMPTY;
        };
    }

    public static void setTankWaterItem(Player player, int tankIndex, ItemStack item) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        ItemStackData data = item.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(item.copy());
        switch (tankIndex) {
            case 1: {
                shell.set(ModDataComponents.TANK1_WATER_ITEM.get(), (Object)data);
                break;
            }
            case 2: {
                shell.set(ModDataComponents.TANK2_WATER_ITEM.get(), (Object)data);
                break;
            }
            case 3: {
                shell.set(ModDataComponents.TANK3_WATER_ITEM.get(), (Object)data);
                break;
            }
            case 4: {
                shell.set(ModDataComponents.TANK4_WATER_ITEM.get(), (Object)data);
                break;
            }
            case 5: {
                shell.set(ModDataComponents.TANK5_WATER_ITEM.get(), (Object)data);
            }
        }
    }

    public static void setTankFluid(Player player, int tankIndex, FluidStackData fluid) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        if (tankIndex == 1) {
            shell.set(ModDataComponents.TANK1_FLUID.get(), (Object)fluid);
        } else if (tankIndex == 2) {
            shell.set(ModDataComponents.TANK2_FLUID.get(), (Object)fluid);
        } else if (tankIndex == 3) {
            shell.set(ModDataComponents.TANK3_FLUID.get(), (Object)fluid);
        } else if (tankIndex == 4) {
            shell.set(ModDataComponents.TANK4_FLUID.get(), (Object)fluid);
        } else if (tankIndex == 5) {
            shell.set(ModDataComponents.TANK5_FLUID.get(), (Object)fluid);
        }
    }

    public static int getTankCapacity(Player player, int tankIndex) {
        int storedCapacity;
        int maxTanks;
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 0;
        }
        WidgetUnlockSystem.WidgetTier tier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, shell);
        switch (tier) {
            case TIER_I: {
                int n = 1;
                break;
            }
            case TIER_II: 
            case TIER_III: {
                int n = 2;
                break;
            }
            case TIER_IV: 
            case TIER_V: {
                int n = 3;
                break;
            }
            case TIER_VI: 
            case TIER_VII: {
                int n = 4;
                break;
            }
            case TIER_VIII: 
            case TIER_IX: 
            case TIER_X: {
                int n = 5;
                break;
            }
            default: {
                int n = maxTanks = 1;
            }
        }
        if (tankIndex > maxTanks) {
            return 0;
        }
        switch (tankIndex) {
            case 1: {
                int n = (Integer)shell.getOrDefault(ModDataComponents.TANK1_CAPACITY.get(), (Object)0);
                break;
            }
            case 2: {
                int n = (Integer)shell.getOrDefault(ModDataComponents.TANK2_CAPACITY.get(), (Object)0);
                break;
            }
            case 3: {
                int n = (Integer)shell.getOrDefault(ModDataComponents.TANK3_CAPACITY.get(), (Object)0);
                break;
            }
            case 4: {
                int n = (Integer)shell.getOrDefault(ModDataComponents.TANK4_CAPACITY.get(), (Object)0);
                break;
            }
            case 5: {
                int n = (Integer)shell.getOrDefault(ModDataComponents.TANK5_CAPACITY.get(), (Object)0);
                break;
            }
            default: {
                int n = storedCapacity = 0;
            }
        }
        if (storedCapacity == 0 && tankIndex <= maxTanks) {
            return WidgetDataHelper.getDefaultTankCapacity(WidgetUnlockSystem.WidgetType.FLUID_TANK, tier, tankIndex);
        }
        return storedCapacity;
    }

    public static void setTankCapacity(Player player, int tankIndex, int capacity) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        if (tankIndex == 1) {
            shell.set(ModDataComponents.TANK1_CAPACITY.get(), (Object)Math.max(0, capacity));
        } else if (tankIndex == 2) {
            shell.set(ModDataComponents.TANK2_CAPACITY.get(), (Object)Math.max(0, capacity));
        } else if (tankIndex == 3) {
            shell.set(ModDataComponents.TANK3_CAPACITY.get(), (Object)Math.max(0, capacity));
        } else if (tankIndex == 4) {
            shell.set(ModDataComponents.TANK4_CAPACITY.get(), (Object)Math.max(0, capacity));
        } else if (tankIndex == 5) {
            shell.set(ModDataComponents.TANK5_CAPACITY.get(), (Object)Math.max(0, capacity));
        }
    }

    public static boolean isTank2Unlocked(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        WidgetUnlockSystem.WidgetTier tier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, shell);
        return tier.ordinal() >= WidgetUnlockSystem.WidgetTier.TIER_II.ordinal();
    }

    public static void setTank2Unlocked(Player player, boolean unlocked) {
    }

    public static boolean isTank3Unlocked(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        WidgetUnlockSystem.WidgetTier tier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, shell);
        return tier.ordinal() >= WidgetUnlockSystem.WidgetTier.TIER_IV.ordinal();
    }

    public static void setTank3Unlocked(Player player, boolean unlocked) {
    }

    public static boolean isTank4Unlocked(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        WidgetUnlockSystem.WidgetTier tier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, shell);
        return tier.ordinal() >= WidgetUnlockSystem.WidgetTier.TIER_VI.ordinal();
    }

    public static void setTank4Unlocked(Player player, boolean unlocked) {
    }

    public static boolean isTank5Unlocked(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        WidgetUnlockSystem.WidgetTier tier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, shell);
        return tier.ordinal() >= WidgetUnlockSystem.WidgetTier.TIER_VIII.ordinal();
    }

    public static void setTank5Unlocked(Player player, boolean unlocked) {
    }

    public static void drainTank(Player player, int tankIndex) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        FluidStackData emptyFluid = new FluidStackData(Fluids.EMPTY, 0);
        WidgetDataHelper.setTankFluid(player, tankIndex, emptyFluid);
    }

    public static int getFurnacePerfUpgradeLevel(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 0;
        }
        int lvl = (Integer)shell.getOrDefault(ModDataComponents.FURNACE_PERF_UPGRADE_LEVEL.get(), (Object)0);
        if (lvl < 0) {
            lvl = 0;
        } else if (lvl > 6) {
            lvl = 6;
        }
        return lvl;
    }

    public static void setFurnacePerfUpgradeLevel(Player player, int level) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            int lvl = Math.max(0, Math.min(6, level));
            shell.set(ModDataComponents.FURNACE_PERF_UPGRADE_LEVEL.get(), (Object)lvl);
        }
    }

    public static boolean getFurnaceInputFromBoth(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.FURNACE_INPUT_FROM_BOTH.get(), (Object)false);
    }

    public static void setFurnaceInputFromBoth(Player player, boolean inputFromBoth) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.FURNACE_INPUT_FROM_BOTH.get(), (Object)inputFromBoth);
        }
    }

    public static ItemStack getFurnacePreviousInputItem(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStackData data = (ItemStackData)shell.getOrDefault(ModDataComponents.FURNACE_PREVIOUS_INPUT_ITEM.get(), (Object)ItemStackData.EMPTY);
        return data.toItemStack();
    }

    public static void setFurnacePreviousInputItem(Player player, ItemStack item) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            ItemStackData data = item.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(item);
            shell.set(ModDataComponents.FURNACE_PREVIOUS_INPUT_ITEM.get(), (Object)data);
        }
    }

    public static int getDripCauldronCount(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 0;
        }
        int c = (Integer)shell.getOrDefault(ModDataComponents.DRIP_CAULDRON_COUNT.get(), (Object)0);
        return Math.max(0, Math.min(5, c));
    }

    public static void setDripCauldronCount(Player player, int count) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        int c = Math.max(0, Math.min(5, count));
        shell.set(ModDataComponents.DRIP_CAULDRON_COUNT.get(), (Object)c);
    }

    private static DataComponentType<FluidStackData> dripSourceKey(int idx) {
        return switch (idx) {
            case 0 -> ModDataComponents.DRIP_SOURCE_FLUID_0.get();
            case 1 -> ModDataComponents.DRIP_SOURCE_FLUID_1.get();
            case 2 -> ModDataComponents.DRIP_SOURCE_FLUID_2.get();
            case 3 -> ModDataComponents.DRIP_SOURCE_FLUID_3.get();
            case 4 -> ModDataComponents.DRIP_SOURCE_FLUID_4.get();
            default -> ModDataComponents.DRIP_SOURCE_FLUID_0.get();
        };
    }

    private static DataComponentType<Integer> dripMbKey(int idx) {
        return switch (idx) {
            case 0 -> ModDataComponents.DRIP_CAULDRON_MB_0.get();
            case 1 -> ModDataComponents.DRIP_CAULDRON_MB_1.get();
            case 2 -> ModDataComponents.DRIP_CAULDRON_MB_2.get();
            case 3 -> ModDataComponents.DRIP_CAULDRON_MB_3.get();
            case 4 -> ModDataComponents.DRIP_CAULDRON_MB_4.get();
            default -> ModDataComponents.DRIP_CAULDRON_MB_0.get();
        };
    }

    private static DataComponentType<Integer> dripProgKey(int idx) {
        return switch (idx) {
            case 0 -> ModDataComponents.DRIP_PROGRESS_0.get();
            case 1 -> ModDataComponents.DRIP_PROGRESS_1.get();
            case 2 -> ModDataComponents.DRIP_PROGRESS_2.get();
            case 3 -> ModDataComponents.DRIP_PROGRESS_3.get();
            case 4 -> ModDataComponents.DRIP_PROGRESS_4.get();
            default -> ModDataComponents.DRIP_PROGRESS_0.get();
        };
    }

    private static DataComponentType<ItemStackData> dripBottomKey(int idx) {
        return switch (idx) {
            case 0 -> ModDataComponents.DRIP_BOTTOM_ITEM_0.get();
            case 1 -> ModDataComponents.DRIP_BOTTOM_ITEM_1.get();
            case 2 -> ModDataComponents.DRIP_BOTTOM_ITEM_2.get();
            case 3 -> ModDataComponents.DRIP_BOTTOM_ITEM_3.get();
            case 4 -> ModDataComponents.DRIP_BOTTOM_ITEM_4.get();
            default -> ModDataComponents.DRIP_BOTTOM_ITEM_0.get();
        };
    }

    public static FluidStackData getDripSourceFluidAt(Player player, int index) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return FluidStackData.EMPTY;
        }
        int idx = Math.max(0, Math.min(4, index));
        return (FluidStackData)shell.getOrDefault(WidgetDataHelper.dripSourceKey(idx), (Object)FluidStackData.EMPTY);
    }

    public static void setDripSourceFluidAt(Player player, int index, FluidStackData fluid) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        int idx = Math.max(0, Math.min(4, index));
        shell.set(WidgetDataHelper.dripSourceKey(idx), (Object)(fluid == null ? FluidStackData.EMPTY : fluid));
    }

    public static int getDripCauldronMbAt(Player player, int index) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 0;
        }
        int idx = Math.max(0, Math.min(4, index));
        return (Integer)shell.getOrDefault(WidgetDataHelper.dripMbKey(idx), (Object)0);
    }

    public static void setDripCauldronMbAt(Player player, int index, int mb) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        int idx = Math.max(0, Math.min(4, index));
        shell.set(WidgetDataHelper.dripMbKey(idx), (Object)Math.max(0, Math.min(1000, mb)));
    }

    public static int getDripProgressAt(Player player, int index) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 0;
        }
        int idx = Math.max(0, Math.min(4, index));
        return (Integer)shell.getOrDefault(WidgetDataHelper.dripProgKey(idx), (Object)0);
    }

    public static void setDripProgressAt(Player player, int index, int value) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        int idx = Math.max(0, Math.min(4, index));
        shell.set(WidgetDataHelper.dripProgKey(idx), (Object)Math.max(0, value));
    }

    public static ItemStack getDripBottomItemAt(Player player, int index) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int idx = Math.max(0, Math.min(4, index));
        ItemStackData data = (ItemStackData)shell.getOrDefault(WidgetDataHelper.dripBottomKey(idx), (Object)ItemStackData.EMPTY);
        return data.toItemStack();
    }

    public static void setDripBottomItemAt(Player player, int index, ItemStack stack) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        int idx = Math.max(0, Math.min(4, index));
        ItemStackData data = stack.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(stack.copy());
        shell.set(WidgetDataHelper.dripBottomKey(idx), (Object)data);
    }

    public static FluidStackData getDripSourceFluid(Player player) {
        return WidgetDataHelper.getDripSourceFluidAt(player, 0);
    }

    public static void setDripSourceFluid(Player player, FluidStackData fluid) {
        WidgetDataHelper.setDripSourceFluidAt(player, 0, fluid);
    }

    public static int getDripCauldronMb(Player player) {
        return WidgetDataHelper.getDripCauldronMbAt(player, 0);
    }

    public static void setDripCauldronMb(Player player, int mb) {
        WidgetDataHelper.setDripCauldronMbAt(player, 0, mb);
    }

    public static int getDripProgress(Player player) {
        return WidgetDataHelper.getDripProgressAt(player, 0);
    }

    public static void setDripProgress(Player player, int value) {
        WidgetDataHelper.setDripProgressAt(player, 0, value);
    }

    public static boolean isDripAutoTransferEnabled(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.DRIP_AUTO_TRANSFER_ENABLED.get(), (Object)false);
    }

    public static void setDripAutoTransferEnabled(Player player, boolean enabled) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        shell.set(ModDataComponents.DRIP_AUTO_TRANSFER_ENABLED.get(), (Object)enabled);
    }

    public static int getDripTargetContainerAt(Player player, int index) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 0;
        }
        int idx = Math.max(0, Math.min(4, index));
        return switch (idx) {
            case 0 -> (Integer)shell.getOrDefault(ModDataComponents.DRIP_TARGET_CONTAINER_0.get(), (Object)0);
            case 1 -> (Integer)shell.getOrDefault(ModDataComponents.DRIP_TARGET_CONTAINER_1.get(), (Object)0);
            case 2 -> (Integer)shell.getOrDefault(ModDataComponents.DRIP_TARGET_CONTAINER_2.get(), (Object)0);
            case 3 -> (Integer)shell.getOrDefault(ModDataComponents.DRIP_TARGET_CONTAINER_3.get(), (Object)0);
            case 4 -> (Integer)shell.getOrDefault(ModDataComponents.DRIP_TARGET_CONTAINER_4.get(), (Object)0);
            default -> 0;
        };
    }

    public static void setDripTargetContainerAt(Player player, int index, int targetContainer) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        int idx = Math.max(0, Math.min(4, index));
        int container = Math.max(0, Math.min(5, targetContainer));
        switch (idx) {
            case 0: {
                shell.set(ModDataComponents.DRIP_TARGET_CONTAINER_0.get(), (Object)container);
                break;
            }
            case 1: {
                shell.set(ModDataComponents.DRIP_TARGET_CONTAINER_1.get(), (Object)container);
                break;
            }
            case 2: {
                shell.set(ModDataComponents.DRIP_TARGET_CONTAINER_2.get(), (Object)container);
                break;
            }
            case 3: {
                shell.set(ModDataComponents.DRIP_TARGET_CONTAINER_3.get(), (Object)container);
                break;
            }
            case 4: {
                shell.set(ModDataComponents.DRIP_TARGET_CONTAINER_4.get(), (Object)container);
            }
        }
    }

    public static ItemStack getAnvilInputItem(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStackData data = (ItemStackData)shell.getOrDefault(ModDataComponents.ANVIL_INPUT_ITEM.get(), (Object)ItemStackData.EMPTY);
        ItemStack result = data.toItemStack();
        return result;
    }

    public static void setAnvilInputItem(Player player, ItemStack item) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            ItemStackData data = item.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(item);
            shell.set(ModDataComponents.ANVIL_INPUT_ITEM.get(), (Object)data);
        }
    }

    public static ItemStack getAnvilMaterialItem(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStackData data = (ItemStackData)shell.getOrDefault(ModDataComponents.ANVIL_MATERIAL_ITEM.get(), (Object)ItemStackData.EMPTY);
        ItemStack result = data.toItemStack();
        return result;
    }

    public static void setAnvilMaterialItem(Player player, ItemStack item) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            ItemStackData data = item.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(item);
            shell.set(ModDataComponents.ANVIL_MATERIAL_ITEM.get(), (Object)data);
        }
    }

    public static ItemStack getAnvilResultItem(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStackData data = (ItemStackData)shell.getOrDefault(ModDataComponents.ANVIL_RESULT_ITEM.get(), (Object)ItemStackData.EMPTY);
        return data.toItemStack();
    }

    public static void setAnvilResultItem(Player player, ItemStack item) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            ItemStackData data = item.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(item);
            shell.set(ModDataComponents.ANVIL_RESULT_ITEM.get(), (Object)data);
        }
    }

    public static int getAnvilRepairCost(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 0;
        }
        return (Integer)shell.getOrDefault(ModDataComponents.ANVIL_REPAIR_COST.get(), (Object)0);
    }

    public static void setAnvilRepairCost(Player player, int cost) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.ANVIL_REPAIR_COST.get(), (Object)cost);
        }
    }

    public static String getAnvilRenameText(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return "";
        }
        return (String)shell.getOrDefault(ModDataComponents.ANVIL_RENAME_TEXT.get(), (Object)"");
    }

    public static void setAnvilRenameText(Player player, String text) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.ANVIL_RENAME_TEXT.get(), (Object)text);
        }
    }

    public static boolean isAutoCrafterUnlocked(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.AUTO_CRAFTER_UNLOCKED.get(), (Object)false);
    }

    public static void setAutoCrafterUnlocked(Player player, boolean unlocked) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        shell.set(ModDataComponents.AUTO_CRAFTER_UNLOCKED.get(), (Object)unlocked);
    }

    public static boolean isAutoCrafterEnabled(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.AUTO_CRAFTER_ENABLED.get(), (Object)false);
    }

    public static void setAutoCrafterEnabled(Player player, boolean enabled) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        shell.set(ModDataComponents.AUTO_CRAFTER_ENABLED.get(), (Object)enabled);
    }

    public static List<AutoCraftRecipe> getAutoCrafterRecipes(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return Collections.emptyList();
        }
        return (List)shell.getOrDefault(ModDataComponents.AUTO_CRAFTER_RECIPES.get(), Collections.emptyList());
    }

    public static void setAutoCrafterRecipes(Player player, List<AutoCraftRecipe> recipes) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        shell.set(ModDataComponents.AUTO_CRAFTER_RECIPES.get(), recipes);
    }

    public static void addAutoCrafterRecipe(Player player, AutoCraftRecipe recipe) {
        ArrayList<AutoCraftRecipe> recipes = new ArrayList<AutoCraftRecipe>(WidgetDataHelper.getAutoCrafterRecipes(player));
        recipes.add(recipe);
        WidgetDataHelper.setAutoCrafterRecipes(player, recipes);
    }

    public static void removeAutoCrafterRecipe(Player player, int index) {
        ArrayList<AutoCraftRecipe> recipes = new ArrayList<AutoCraftRecipe>(WidgetDataHelper.getAutoCrafterRecipes(player));
        if (index >= 0 && index < recipes.size()) {
            recipes.remove(index);
            WidgetDataHelper.setAutoCrafterRecipes(player, recipes);
        }
    }

    public static void clearAutoCrafterRecipes(Player player) {
        WidgetDataHelper.setAutoCrafterRecipes(player, Collections.emptyList());
    }

    public static int[] getValidDripTargetContainers(Player player, int dripstoneIndex) {
        ArrayList<Integer> validTargets = new ArrayList<Integer>();
        validTargets.add(0);
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty() || !WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.FLUID_TANK, shell)) {
            return new int[]{0};
        }
        FluidStackData sourceFluid = WidgetDataHelper.getDripSourceFluidAt(player, dripstoneIndex);
        boolean isProducingLava = !sourceFluid.isEmpty() && sourceFluid.fluid().builtInRegistryHolder().key().location().getPath().contains("lava");
        for (int tankIndex = 1; tankIndex <= 5; ++tankIndex) {
            boolean isUnlocked;
            switch (tankIndex) {
                case 1: {
                    boolean bl = true;
                    break;
                }
                case 2: {
                    boolean bl = WidgetDataHelper.isTank2Unlocked(player);
                    break;
                }
                case 3: {
                    boolean bl = WidgetDataHelper.isTank3Unlocked(player);
                    break;
                }
                case 4: {
                    boolean bl = WidgetDataHelper.isTank4Unlocked(player);
                    break;
                }
                case 5: {
                    boolean bl = WidgetDataHelper.isTank5Unlocked(player);
                    break;
                }
                default: {
                    boolean bl = isUnlocked = false;
                }
            }
            if (!isUnlocked) continue;
            FluidStackData tankFluid = WidgetDataHelper.getTankFluid(player, tankIndex);
            if (!tankFluid.isEmpty()) {
                boolean tankHasLava = tankFluid.fluid().builtInRegistryHolder().key().location().getPath().contains("lava");
                if (isProducingLava && !tankHasLava || !isProducingLava && tankHasLava) continue;
            }
            validTargets.add(tankIndex);
        }
        return validTargets.stream().mapToInt(Integer::intValue).toArray();
    }

    public static int cycleDripTargetContainerAt(Player player, int index) {
        int[] validTargets = WidgetDataHelper.getValidDripTargetContainers(player, index);
        int current = WidgetDataHelper.getDripTargetContainerAt(player, index);
        if (validTargets.length == 1 && validTargets[0] == 0) {
            WidgetDataHelper.setDripTargetContainerAt(player, index, 0);
            return 0;
        }
        int currentIndex = -1;
        for (int i = 0; i < validTargets.length; ++i) {
            if (validTargets[i] != current) continue;
            currentIndex = i;
            break;
        }
        if (currentIndex == -1) {
            WidgetDataHelper.setDripTargetContainerAt(player, index, validTargets[0]);
            return validTargets[0];
        }
        int nextIndex = (currentIndex + 1) % validTargets.length;
        int next = validTargets[nextIndex];
        WidgetDataHelper.setDripTargetContainerAt(player, index, next);
        return next;
    }

    public static boolean shouldAutoTransferAt(Player player, int index) {
        return WidgetDataHelper.isDripAutoTransferEnabled(player) && WidgetDataHelper.getDripTargetContainerAt(player, index) > 0;
    }

    public static List<ItemStack> getFurnaceInputTemplates(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return WidgetDataHelper.getEmptyTemplateList();
        }
        List templates = (List)shell.getOrDefault(ModDataComponents.FURNACE_INPUT_TEMPLATES.get(), WidgetDataHelper.getEmptyTemplateDataList());
        return templates.stream().map(ItemStackData::toItemStack).collect(Collectors.toList());
    }

    public static void setFurnaceInputTemplate(Player player, int slotIndex, ItemStack templateItem) {
        int maxSlots = 8;
        if (slotIndex < 0 || slotIndex >= maxSlots) {
            return;
        }
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        ArrayList<ItemStackData> templates = new ArrayList<ItemStackData>((Collection)shell.getOrDefault(ModDataComponents.FURNACE_INPUT_TEMPLATES.get(), WidgetDataHelper.getEmptyTemplateDataList()));
        while (templates.size() < 8) {
            templates.add(ItemStackData.EMPTY);
        }
        templates.set(slotIndex, templateItem.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(templateItem));
        shell.set(ModDataComponents.FURNACE_INPUT_TEMPLATES.get(), templates);
    }

    public static List<ItemStack> getFurnaceFuelTemplates(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return WidgetDataHelper.getEmptyTemplateList();
        }
        List templates = (List)shell.getOrDefault(ModDataComponents.FURNACE_FUEL_TEMPLATES.get(), WidgetDataHelper.getEmptyTemplateDataList());
        return templates.stream().map(ItemStackData::toItemStack).collect(Collectors.toList());
    }

    public static void setFurnaceFuelTemplate(Player player, int slotIndex, ItemStack templateItem) {
        int maxSlots = 8;
        if (slotIndex < 0 || slotIndex >= maxSlots) {
            return;
        }
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        ArrayList<ItemStackData> templates = new ArrayList<ItemStackData>((Collection)shell.getOrDefault(ModDataComponents.FURNACE_FUEL_TEMPLATES.get(), WidgetDataHelper.getEmptyTemplateDataList()));
        while (templates.size() < 8) {
            templates.add(ItemStackData.EMPTY);
        }
        templates.set(slotIndex, templateItem.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(templateItem));
        shell.set(ModDataComponents.FURNACE_FUEL_TEMPLATES.get(), templates);
    }

    public static int getAllowedTemplateSlots(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 3;
        }
        int extra = (Integer)shell.getOrDefault(ModDataComponents.FURNACE_EXTRA_TEMPLATE_SLOTS.get(), (Object)0);
        extra = Math.max(0, Math.min(5, extra));
        return 3 + extra;
    }

    public static boolean hasTemplateItem(Player player, ItemStack templateItem) {
        block7: {
            block8: {
                block6: {
                    AbstractContainerMenu abstractContainerMenu;
                    if (templateItem.isEmpty()) {
                        return false;
                    }
                    boolean inputFromBoth = WidgetDataHelper.getFurnaceInputFromBoth(player);
                    if (inputFromBoth) {
                        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                            ItemStack stack = player.getInventory().getItem(i);
                            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)templateItem)) continue;
                            return true;
                        }
                    }
                    if (!((abstractContainerMenu = player.containerMenu) instanceof ShellMenu)) break block6;
                    ShellMenu ShellMenu2 = (ShellMenu)abstractContainerMenu;
                    for (int i = 0; i < ShellMenu2.getshellSlotCount(); ++i) {
                        ItemStack stack = ShellMenu2.getshellContainer().getItem(i);
                        if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)templateItem)) continue;
                        return true;
                    }
                    break block7;
                }
                AbstractContainerMenu i = player.containerMenu;
                if (!(i instanceof VirtualShellMenu)) break block8;
                VirtualShellMenu virtualMenu = (VirtualShellMenu)i;
                VirtualInventory inv = virtualMenu.getVirtualInventory();
                int total = inv.getTotalSlots();
                for (int i2 = 0; i2 < total; ++i2) {
                    ItemStack stack = inv.getItem(i2);
                    if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)templateItem)) continue;
                    return true;
                }
                break block7;
            }
            ItemStack shell = ShellItem.findWornshell(player);
            if (shell.isEmpty()) break block7;
            ItemContainerContents shellContents = ShellItem.getshellContents(shell);
            for (int i = 0; i < shellContents.getSlots(); ++i) {
                ItemStack stack = shellContents.getStackInSlot(i);
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)templateItem)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean pullTemplateItem(Player player, ItemStack templateItem, Consumer<ItemStack> setSlotItem) {
        if (templateItem.isEmpty()) {
            return false;
        }
        ItemStack extracted = WidgetDataHelper.extractTemplateItem(player, templateItem);
        if (!extracted.isEmpty()) {
            setSlotItem.accept(extracted);
            return true;
        }
        return false;
    }

    private static ItemStack extractTemplateItem(Player player, ItemStack templateItem) {
        block10: {
            int i;
            block11: {
                block9: {
                    AbstractContainerMenu extracted2;
                    boolean inputFromBoth = WidgetDataHelper.getFurnaceInputFromBoth(player);
                    if (inputFromBoth) {
                        for (int i2 = 0; i2 < player.getInventory().getContainerSize(); ++i2) {
                            ItemStack stack = player.getInventory().getItem(i2);
                            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)templateItem) || stack.isEmpty()) continue;
                            ItemStack extracted2 = stack.copy();
                            extracted2.setCount(1);
                            stack.shrink(1);
                            if (stack.isEmpty()) {
                                player.getInventory().setItem(i2, ItemStack.EMPTY);
                            }
                            return extracted2;
                        }
                    }
                    if (!((extracted2 = player.containerMenu) instanceof ShellMenu)) break block9;
                    ShellMenu ShellMenu2 = (ShellMenu)extracted2;
                    for (int i3 = 0; i3 < ShellMenu2.getshellSlotCount(); ++i3) {
                        ItemStack stack = ShellMenu2.getshellContainer().getItem(i3);
                        if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)templateItem) || stack.isEmpty()) continue;
                        ItemStack extracted3 = stack.copy();
                        extracted3.setCount(1);
                        ItemStack newStack = stack.copy();
                        newStack.shrink(1);
                        ShellMenu2.getshellContainer().setItem(i3, newStack.isEmpty() ? ItemStack.EMPTY : newStack);
                        return extracted3;
                    }
                    break block10;
                }
                AbstractContainerMenu i3 = player.containerMenu;
                if (!(i3 instanceof VirtualShellMenu)) break block11;
                VirtualShellMenu virtualMenu = (VirtualShellMenu)i3;
                VirtualInventory inv = virtualMenu.getVirtualInventory();
                int total = inv.getTotalSlots();
                for (int i4 = 0; i4 < total; ++i4) {
                    ItemStack stack = inv.getItem(i4);
                    if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)templateItem) || stack.isEmpty()) continue;
                    inv.removeItem(i4, 1);
                    if (!player.level().isClientSide) {
                        ShellItem.setVirtualInventory(virtualMenu.getshellStack(), inv);
                    }
                    ItemStack extracted = stack.copy();
                    extracted.setCount(1);
                    return extracted;
                }
                break block10;
            }
            ItemStack shell = ShellItem.findWornshell(player);
            if (shell.isEmpty()) break block10;
            ItemContainerContents shellContents = ShellItem.getshellContents(shell);
            ArrayList<ItemStack> ShellItems = new ArrayList<ItemStack>();
            for (i = 0; i < shellContents.getSlots(); ++i) {
                ShellItems.add(shellContents.getStackInSlot(i).copy());
            }
            for (i = 0; i < ShellItems.size(); ++i) {
                ItemStack stack = (ItemStack)ShellItems.get(i);
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)templateItem) || stack.isEmpty()) continue;
                ItemStack extracted = stack.split(1);
                if (stack.isEmpty()) {
                    ShellItems.set(i, ItemStack.EMPTY);
                }
                ItemContainerContents newContents = ContainerUtils.createSafeContainerContents(ShellItems);
                ShellItem.setshellContents(shell, newContents);
                return extracted;
            }
        }
        return ItemStack.EMPTY;
    }

    public static List<ItemStack> getCraftingTableGrid(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return WidgetDataHelper.getEmptyCraftingGrid();
        }
        List grid = (List)shell.getOrDefault(ModDataComponents.CRAFTING_TABLE_GRID.get(), WidgetDataHelper.getEmptyCraftingGridData());
        return grid.stream().map(ItemStackData::toItemStack).collect(Collectors.toList());
    }

    public static void setCraftingTableGrid(Player player, List<ItemStack> grid) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        List gridData = grid.stream().map(stack -> stack.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(stack)).collect(Collectors.toList());
        while (gridData.size() < 9) {
            gridData.add(ItemStackData.EMPTY);
        }
        shell.set(ModDataComponents.CRAFTING_TABLE_GRID.get(), gridData);
    }

    public static void setCraftingTableGridSlot(Player player, int slotIndex, ItemStack item) {
        if (slotIndex < 0 || slotIndex >= 9) {
            return;
        }
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        ArrayList<ItemStackData> grid = new ArrayList<ItemStackData>((Collection)shell.getOrDefault(ModDataComponents.CRAFTING_TABLE_GRID.get(), WidgetDataHelper.getEmptyCraftingGridData()));
        while (grid.size() < 9) {
            grid.add(ItemStackData.EMPTY);
        }
        grid.set(slotIndex, item.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(item));
        shell.set(ModDataComponents.CRAFTING_TABLE_GRID.get(), grid);
    }

    public static ItemStack getCraftingTableResult(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStackData resultData = (ItemStackData)shell.getOrDefault(ModDataComponents.CRAFTING_TABLE_RESULT.get(), (Object)ItemStackData.EMPTY);
        return resultData.toItemStack();
    }

    public static void setCraftingTableResult(Player player, ItemStack result) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        ItemStackData resultData = result.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(result);
        shell.set(ModDataComponents.CRAFTING_TABLE_RESULT.get(), (Object)resultData);
    }

    public static void clearCraftingTableData(Player player) {
        WidgetDataHelper.setCraftingTableGrid(player, WidgetDataHelper.getEmptyCraftingGrid());
        WidgetDataHelper.setCraftingTableResult(player, ItemStack.EMPTY);
    }

    private static List<ItemStack> getEmptyCraftingGrid() {
        return Arrays.asList(ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY);
    }

    private static List<ItemStackData> getEmptyCraftingGridData() {
        return Arrays.asList(ItemStackData.EMPTY, ItemStackData.EMPTY, ItemStackData.EMPTY, ItemStackData.EMPTY, ItemStackData.EMPTY, ItemStackData.EMPTY, ItemStackData.EMPTY, ItemStackData.EMPTY, ItemStackData.EMPTY);
    }

    private static List<ItemStack> getEmptyTemplateList() {
        return Arrays.asList(ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY);
    }

    private static List<ItemStackData> getEmptyTemplateDataList() {
        return Arrays.asList(ItemStackData.EMPTY, ItemStackData.EMPTY, ItemStackData.EMPTY, ItemStackData.EMPTY, ItemStackData.EMPTY, ItemStackData.EMPTY, ItemStackData.EMPTY, ItemStackData.EMPTY);
    }

    public static List<ResourceLocation> getFurnaceInputTags(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<ResourceLocation>((Collection)shell.getOrDefault(ModDataComponents.FURNACE_INPUT_TAGS.get(), Collections.emptyList()));
    }

    public static void setFurnaceInputTags(Player player, List<ResourceLocation> tags) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.FURNACE_INPUT_TAGS.get(), new ArrayList<ResourceLocation>(tags));
        }
    }

    public static boolean isFurnaceInputTagWhitelist(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return true;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.FURNACE_INPUT_TAG_WHITELIST.get(), (Object)Boolean.TRUE);
    }

    public static void setFurnaceInputTagWhitelist(Player player, boolean whitelist) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.FURNACE_INPUT_TAG_WHITELIST.get(), (Object)whitelist);
        }
    }

    public static List<ResourceLocation> getFurnaceFuelTags(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<ResourceLocation>((Collection)shell.getOrDefault(ModDataComponents.FURNACE_FUEL_TAGS.get(), Collections.emptyList()));
    }

    public static void setFurnaceFuelTags(Player player, List<ResourceLocation> tags) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.FURNACE_FUEL_TAGS.get(), new ArrayList<ResourceLocation>(tags));
        }
    }

    public static boolean isFurnaceFuelTagWhitelist(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return true;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.FURNACE_FUEL_TAG_WHITELIST.get(), (Object)Boolean.TRUE);
    }

    public static void setFurnaceFuelTagWhitelist(Player player, boolean whitelist) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.FURNACE_FUEL_TAG_WHITELIST.get(), (Object)whitelist);
        }
    }

    public static boolean itemMatchesTags(ItemStack stack, List<ResourceLocation> tags, boolean whitelist) {
        if (stack.isEmpty() || tags.isEmpty()) {
            return false;
        }
        boolean match = false;
        for (ResourceLocation rl : tags) {
            TagKey key = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)rl);
            if (!stack.is(key)) continue;
            match = true;
            break;
        }
        return whitelist ? match : !match;
    }

    public static ItemStack extractItemMatchingTags(Player player, List<ResourceLocation> tags, boolean whitelist, boolean requireFuel) {
        return WidgetDataHelper.extractItemMatchingTags(player, tags, whitelist, requireFuel, ItemStack.EMPTY);
    }

    public static ItemStack extractItemMatchingTags(Player player, List<ResourceLocation> tags, boolean whitelist, boolean requireFuel, ItemStack expectedSameAs) {
        block10: {
            int i;
            Predicate<ItemStack> predicate;
            block11: {
                block9: {
                    AbstractContainerMenu out2;
                    if (tags.isEmpty()) {
                        return ItemStack.EMPTY;
                    }
                    boolean fromBoth = WidgetDataHelper.getFurnaceInputFromBoth(player);
                    predicate = s -> {
                        if (s.isEmpty()) {
                            return false;
                        }
                        if (requireFuel && s.getBurnTime(RecipeType.SMELTING) <= 0) {
                            return false;
                        }
                        if (!WidgetDataHelper.itemMatchesTags(s, tags, whitelist)) {
                            return false;
                        }
                        return expectedSameAs.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)expectedSameAs);
                    };
                    if (fromBoth) {
                        for (int i2 = 0; i2 < player.getInventory().getContainerSize(); ++i2) {
                            ItemStack stack = player.getInventory().getItem(i2);
                            if (!predicate.test(stack)) continue;
                            ItemStack out2 = stack.split(1);
                            if (stack.isEmpty()) {
                                player.getInventory().setItem(i2, ItemStack.EMPTY);
                            }
                            return out2;
                        }
                    }
                    if (!((out2 = player.containerMenu) instanceof ShellMenu)) break block9;
                    ShellMenu ShellMenu2 = (ShellMenu)out2;
                    for (int i3 = 0; i3 < ShellMenu2.getshellSlotCount(); ++i3) {
                        ItemStack stack = ShellMenu2.getshellContainer().getItem(i3);
                        if (!predicate.test(stack)) continue;
                        ItemStack newStack = stack.copy();
                        ItemStack out3 = newStack.split(1);
                        ShellMenu2.getshellContainer().setItem(i3, newStack.isEmpty() ? ItemStack.EMPTY : newStack);
                        return out3;
                    }
                    break block10;
                }
                AbstractContainerMenu i3 = player.containerMenu;
                if (!(i3 instanceof VirtualShellMenu)) break block11;
                VirtualShellMenu virtualMenu = (VirtualShellMenu)i3;
                VirtualInventory inv = virtualMenu.getVirtualInventory();
                int total = inv.getTotalSlots();
                for (int i4 = 0; i4 < total; ++i4) {
                    ItemStack stack = inv.getItem(i4);
                    if (!predicate.test(stack)) continue;
                    inv.removeItem(i4, 1);
                    if (!player.level().isClientSide) {
                        ShellItem.setVirtualInventory(virtualMenu.getshellStack(), inv);
                    }
                    ItemStack out = stack.copy();
                    out.setCount(1);
                    return out;
                }
                break block10;
            }
            ItemStack shell = ShellItem.findWornshell(player);
            if (shell.isEmpty()) break block10;
            ItemContainerContents contents = ShellItem.getshellContents(shell);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (i = 0; i < contents.getSlots(); ++i) {
                items.add(contents.getStackInSlot(i).copy());
            }
            for (i = 0; i < items.size(); ++i) {
                ItemStack stack = (ItemStack)items.get(i);
                if (!predicate.test(stack)) continue;
                ItemStack out = stack.split(1);
                items.set(i, stack.isEmpty() ? ItemStack.EMPTY : stack);
                ItemContainerContents newContents = ContainerUtils.createSafeContainerContents(items);
                ShellItem.setshellContents(shell, newContents);
                return out;
            }
        }
        return ItemStack.EMPTY;
    }

    public static boolean isGuardianTorchEnabled(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.GUARDIAN_TORCH_ENABLED.get(), (Object)Boolean.FALSE);
    }

    public static void setGuardianTorchEnabled(Player player, boolean enabled) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        shell.set(ModDataComponents.GUARDIAN_TORCH_ENABLED.get(), (Object)enabled);
    }

    public static boolean isGuardianSnowEnabled(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.GUARDIAN_SNOW_ENABLED.get(), (Object)Boolean.FALSE);
    }

    public static void setGuardianSnowEnabled(Player player, boolean enabled) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        shell.set(ModDataComponents.GUARDIAN_SNOW_ENABLED.get(), (Object)enabled);
    }

    public static boolean isGuardianPiglinEnabled(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.GUARDIAN_PIGLIN_ENABLED.get(), (Object)Boolean.FALSE);
    }

    public static void setGuardianPiglinEnabled(Player player, boolean enabled) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        shell.set(ModDataComponents.GUARDIAN_PIGLIN_ENABLED.get(), (Object)enabled);
    }

    public static boolean isGuardianSlowfallEnabled(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.GUARDIAN_SLOWFALL_ENABLED.get(), (Object)Boolean.FALSE);
    }

    public static void setGuardianSlowfallEnabled(Player player, boolean enabled) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        shell.set(ModDataComponents.GUARDIAN_SLOWFALL_ENABLED.get(), (Object)enabled);
    }

    public static boolean isGuardianInvisibilityEnabled(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.GUARDIAN_INVISIBILITY_ENABLED.get(), (Object)Boolean.FALSE);
    }

    public static void setGuardianInvisibilityEnabled(Player player, boolean enabled) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.GUARDIAN_INVISIBILITY_ENABLED.get(), (Object)enabled);
        }
    }

    public static Map<String, ItemStack> getMemorizedSlots(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        HashMap<String, ItemStack> out = new HashMap<String, ItemStack>();
        if (shell.isEmpty()) {
            return out;
        }
        Map data = (Map)shell.getOrDefault(ModDataComponents.MEMORIZED_SLOTS.get(), new HashMap());
        for (Map.Entry e : data.entrySet()) {
            out.put((String)e.getKey(), e.getValue() == null ? ItemStack.EMPTY : ((ItemStackData)e.getValue()).toItemStack());
        }
        return out;
    }

    public static ItemStack getMemorizedItemAt(Player player, int slotIndex) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Map data = (Map)shell.getOrDefault(ModDataComponents.MEMORIZED_SLOTS.get(), new HashMap());
        ItemStackData isd = (ItemStackData)data.get(String.valueOf(slotIndex));
        return isd == null ? ItemStack.EMPTY : isd.toItemStack();
    }

    public static void setMemorizedItemAt(Player player, int slotIndex, ItemStack template) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        HashMap<String, ItemStackData> data = new HashMap<String, ItemStackData>((Map)shell.getOrDefault(ModDataComponents.MEMORIZED_SLOTS.get(), new HashMap()));
        String key = String.valueOf(slotIndex);
        if (template == null || template.isEmpty()) {
            data.remove(key);
        } else {
            data.put(key, ItemStackData.of(template.copy()));
        }
        shell.set(ModDataComponents.MEMORIZED_SLOTS.get(), data);
    }

    public static void clearAllMemorizedSlots(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return;
        }
        shell.set(ModDataComponents.MEMORIZED_SLOTS.get(), new HashMap());
    }

    public static boolean isFurnaceLiquidFuelEnabled(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.FURNACE_LIQUID_FUEL_ENABLED.get(), (Object)false);
    }

    public static void setFurnaceLiquidFuelEnabled(Player player, boolean enabled) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.FURNACE_LIQUID_FUEL_ENABLED.get(), (Object)enabled);
        }
    }

    public static int getFurnaceLiquidFuelTargetTank(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return 0;
        }
        return (Integer)shell.getOrDefault(ModDataComponents.FURNACE_LIQUID_FUEL_TARGET_TANK.get(), (Object)0);
    }

    public static void setFurnaceLiquidFuelTargetTank(Player player, int targetTank) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            int tank = Math.max(0, Math.min(5, targetTank));
            shell.set(ModDataComponents.FURNACE_LIQUID_FUEL_TARGET_TANK.get(), (Object)tank);
        }
    }

    public static int[] getValidFurnaceLiquidFuelTargetTanks(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return new int[]{0};
        }
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.FLUID_TANK, shell)) {
            return new int[]{0};
        }
        WidgetUnlockSystem.WidgetTier tankTier = WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, shell);
        int maxTanks = switch (tankTier) {
            default -> throw new MatchException(null, null);
            case WidgetUnlockSystem.WidgetTier.TIER_I, WidgetUnlockSystem.WidgetTier.TIER_0 -> 1;
            case WidgetUnlockSystem.WidgetTier.TIER_II -> 2;
            case WidgetUnlockSystem.WidgetTier.TIER_III -> 3;
            case WidgetUnlockSystem.WidgetTier.TIER_IV -> 4;
            case WidgetUnlockSystem.WidgetTier.TIER_V, WidgetUnlockSystem.WidgetTier.TIER_VI, WidgetUnlockSystem.WidgetTier.TIER_VII, WidgetUnlockSystem.WidgetTier.TIER_VIII, WidgetUnlockSystem.WidgetTier.TIER_IX, WidgetUnlockSystem.WidgetTier.TIER_X -> 5;
        };
        ArrayList<Integer> validTanks = new ArrayList<Integer>();
        validTanks.add(0);
        for (int i = 1; i <= maxTanks; ++i) {
            FluidStackData tankFluid = WidgetDataHelper.getTankFluid(player, i);
            if (!tankFluid.isEmpty() && !WidgetDataHelper.isLava(tankFluid)) continue;
            validTanks.add(i);
        }
        return validTanks.stream().mapToInt(Integer::intValue).toArray();
    }

    public static int cycleFurnaceLiquidFuelTargetTank(Player player, boolean forward) {
        int[] validTargets = WidgetDataHelper.getValidFurnaceLiquidFuelTargetTanks(player);
        int current = WidgetDataHelper.getFurnaceLiquidFuelTargetTank(player);
        if (validTargets.length == 1 && validTargets[0] == 0) {
            WidgetDataHelper.setFurnaceLiquidFuelTargetTank(player, 0);
            return 0;
        }
        int currentIndex = -1;
        for (int i = 0; i < validTargets.length; ++i) {
            if (validTargets[i] != current) continue;
            currentIndex = i;
            break;
        }
        if (currentIndex == -1) {
            WidgetDataHelper.setFurnaceLiquidFuelTargetTank(player, validTargets[0]);
            return validTargets[0];
        }
        int nextIndex = forward ? (currentIndex + 1) % validTargets.length : (currentIndex - 1 + validTargets.length) % validTargets.length;
        int next = validTargets[nextIndex];
        WidgetDataHelper.setFurnaceLiquidFuelTargetTank(player, next);
        return next;
    }

    public static int cycleFurnaceLiquidFuelTargetTank(Player player) {
        return WidgetDataHelper.cycleFurnaceLiquidFuelTargetTank(player, true);
    }

    public static boolean shouldUseFurnaceLiquidFuel(Player player) {
        return WidgetDataHelper.isFurnaceLiquidFuelEnabled(player) && WidgetDataHelper.getFurnaceLiquidFuelTargetTank(player) > 0;
    }

    private static boolean isLava(FluidStackData data) {
        return !data.isEmpty() && data.fluid().builtInRegistryHolder().key().location().getPath().contains("lava");
    }

    public static ItemStack getCollectorItem(Player player, int slotIndex) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return switch (slotIndex) {
            case 0 -> ((ItemStackData)shell.getOrDefault(ModDataComponents.COLLECTOR_ITEM_0.get(), (Object)ItemStackData.EMPTY)).toItemStack();
            case 1 -> ((ItemStackData)shell.getOrDefault(ModDataComponents.COLLECTOR_ITEM_1.get(), (Object)ItemStackData.EMPTY)).toItemStack();
            case 2 -> ((ItemStackData)shell.getOrDefault(ModDataComponents.COLLECTOR_ITEM_2.get(), (Object)ItemStackData.EMPTY)).toItemStack();
            case 3 -> ((ItemStackData)shell.getOrDefault(ModDataComponents.COLLECTOR_ITEM_3.get(), (Object)ItemStackData.EMPTY)).toItemStack();
            case 4 -> ((ItemStackData)shell.getOrDefault(ModDataComponents.COLLECTOR_ITEM_4.get(), (Object)ItemStackData.EMPTY)).toItemStack();
            default -> ItemStack.EMPTY;
        };
    }

    public static void setCollectorItem(Player player, int slotIndex, ItemStack item) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            ItemStackData data = item.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(item);
            switch (slotIndex) {
                case 0: {
                    shell.set(ModDataComponents.COLLECTOR_ITEM_0.get(), (Object)data);
                    break;
                }
                case 1: {
                    shell.set(ModDataComponents.COLLECTOR_ITEM_1.get(), (Object)data);
                    break;
                }
                case 2: {
                    shell.set(ModDataComponents.COLLECTOR_ITEM_2.get(), (Object)data);
                    break;
                }
                case 3: {
                    shell.set(ModDataComponents.COLLECTOR_ITEM_3.get(), (Object)data);
                    break;
                }
                case 4: {
                    shell.set(ModDataComponents.COLLECTOR_ITEM_4.get(), (Object)data);
                }
            }
        }
    }

    public static void clearCollectorData(Player player) {
        WidgetDataHelper.setCollectorItem(player, 0, ItemStack.EMPTY);
        WidgetDataHelper.setCollectorItem(player, 1, ItemStack.EMPTY);
        WidgetDataHelper.setCollectorItem(player, 2, ItemStack.EMPTY);
        WidgetDataHelper.setCollectorItem(player, 3, ItemStack.EMPTY);
        WidgetDataHelper.setCollectorItem(player, 4, ItemStack.EMPTY);
    }

    public static ItemStack getCollectorTagGhost(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return ((ItemStackData)shell.getOrDefault(ModDataComponents.COLLECTOR_TAG_GHOST.get(), (Object)ItemStackData.EMPTY)).toItemStack();
    }

    public static void setCollectorTagGhost(Player player, ItemStack item) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            ItemStackData data = item.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(item);
            shell.set(ModDataComponents.COLLECTOR_TAG_GHOST.get(), (Object)data);
        }
    }

    public static List<ResourceLocation> getCollectorTags(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return new ArrayList<ResourceLocation>();
        }
        return (List)shell.getOrDefault(ModDataComponents.COLLECTOR_TAGS.get(), new ArrayList());
    }

    public static void setCollectorTags(Player player, List<ResourceLocation> tags) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.COLLECTOR_TAGS.get(), new ArrayList<ResourceLocation>(tags));
        }
    }

    public static boolean isCollectorTagWhitelist(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return true;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.COLLECTOR_TAG_WHITELIST.get(), (Object)true);
    }

    public static void setCollectorTagWhitelist(Player player, boolean whitelist) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.COLLECTOR_TAG_WHITELIST.get(), (Object)whitelist);
        }
    }

    public static ItemStack getAutoFeederFood(Player player, int slotIndex) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return switch (slotIndex) {
            case 0 -> ((ItemStackData)shell.getOrDefault(ModDataComponents.AUTO_FEEDER_FOOD_0.get(), (Object)ItemStackData.EMPTY)).toItemStack();
            case 1 -> ((ItemStackData)shell.getOrDefault(ModDataComponents.AUTO_FEEDER_FOOD_1.get(), (Object)ItemStackData.EMPTY)).toItemStack();
            case 2 -> ((ItemStackData)shell.getOrDefault(ModDataComponents.AUTO_FEEDER_FOOD_2.get(), (Object)ItemStackData.EMPTY)).toItemStack();
            case 3 -> ((ItemStackData)shell.getOrDefault(ModDataComponents.AUTO_FEEDER_FOOD_3.get(), (Object)ItemStackData.EMPTY)).toItemStack();
            case 4 -> ((ItemStackData)shell.getOrDefault(ModDataComponents.AUTO_FEEDER_FOOD_4.get(), (Object)ItemStackData.EMPTY)).toItemStack();
            default -> ItemStack.EMPTY;
        };
    }

    public static void setAutoFeederFood(Player player, int slotIndex, ItemStack item) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            ItemStackData data = item.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(item);
            switch (slotIndex) {
                case 0: {
                    shell.set(ModDataComponents.AUTO_FEEDER_FOOD_0.get(), (Object)data);
                    break;
                }
                case 1: {
                    shell.set(ModDataComponents.AUTO_FEEDER_FOOD_1.get(), (Object)data);
                    break;
                }
                case 2: {
                    shell.set(ModDataComponents.AUTO_FEEDER_FOOD_2.get(), (Object)data);
                    break;
                }
                case 3: {
                    shell.set(ModDataComponents.AUTO_FEEDER_FOOD_3.get(), (Object)data);
                    break;
                }
                case 4: {
                    shell.set(ModDataComponents.AUTO_FEEDER_FOOD_4.get(), (Object)data);
                }
            }
        }
    }

    public static void clearAutoFeederData(Player player) {
        WidgetDataHelper.setAutoFeederFood(player, 0, ItemStack.EMPTY);
        WidgetDataHelper.setAutoFeederFood(player, 1, ItemStack.EMPTY);
        WidgetDataHelper.setAutoFeederFood(player, 2, ItemStack.EMPTY);
        WidgetDataHelper.setAutoFeederFood(player, 3, ItemStack.EMPTY);
        WidgetDataHelper.setAutoFeederFood(player, 4, ItemStack.EMPTY);
    }

    public static ItemStack getAutoFeederTagGhost(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return ((ItemStackData)shell.getOrDefault(ModDataComponents.AUTO_FEEDER_TAG_GHOST.get(), (Object)ItemStackData.EMPTY)).toItemStack();
    }

    public static void setAutoFeederTagGhost(Player player, ItemStack item) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            ItemStackData data = item.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(item);
            shell.set(ModDataComponents.AUTO_FEEDER_TAG_GHOST.get(), (Object)data);
        }
    }

    public static List<ResourceLocation> getAutoFeederTags(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return new ArrayList<ResourceLocation>();
        }
        return (List)shell.getOrDefault(ModDataComponents.AUTO_FEEDER_TAGS.get(), new ArrayList());
    }

    public static void setAutoFeederTags(Player player, List<ResourceLocation> tags) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.AUTO_FEEDER_TAGS.get(), new ArrayList<ResourceLocation>(tags));
        }
    }

    public static boolean isAutoFeederTagWhitelist(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return true;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.AUTO_FEEDER_TAG_WHITELIST.get(), (Object)true);
    }

    public static void setAutoFeederTagWhitelist(Player player, boolean whitelist) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.AUTO_FEEDER_TAG_WHITELIST.get(), (Object)whitelist);
        }
    }

    public static boolean isAutoFeederFeedOnDamage(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return true;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.AUTO_FEEDER_FEED_ON_DAMAGE.get(), (Object)true);
    }

    public static void setAutoFeederFeedOnDamage(Player player, boolean feedOnDamage) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.AUTO_FEEDER_FEED_ON_DAMAGE.get(), (Object)feedOnDamage);
        }
    }

    public static boolean isAutoFeederWaitForFullHunger(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.AUTO_FEEDER_WAIT_FOR_FULL_HUNGER.get(), (Object)false);
    }

    public static void setAutoFeederWaitForFullHunger(Player player, boolean waitForFullHunger) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.AUTO_FEEDER_WAIT_FOR_FULL_HUNGER.get(), (Object)waitForFullHunger);
        }
    }

    public static boolean isAutoFeederWaitForFullDamage(Player player) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty()) {
            return false;
        }
        return (Boolean)shell.getOrDefault(ModDataComponents.AUTO_FEEDER_WAIT_FOR_FULL_DAMAGE.get(), (Object)false);
    }

    public static void setAutoFeederWaitForFullDamage(Player player, boolean waitForFullDamage) {
        ItemStack shell = ShellItem.findWornshell(player);
        if (!shell.isEmpty()) {
            shell.set(ModDataComponents.AUTO_FEEDER_WAIT_FOR_FULL_DAMAGE.get(), (Object)waitForFullDamage);
        }
    }
}

