/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell;

import com.etka.nomadsshell.compat.CuriosCompat;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.config.ShellConfig;
import com.etka.nomadsshell.init.ModCreativeTabs;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.init.ModFluids;
import com.etka.nomadsshell.init.ModItems;
import com.etka.nomadsshell.init.ModMenuTypes;
import com.etka.nomadsshell.network.ModPacketHandler;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Proxy;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import org.slf4j.Logger;

@Mod(value="nomadsshell")
public class NomadsShell {
    public static final String MODID = "nomadsshell";
    public static final Logger LOGGER = LogUtils.getLogger();

    public NomadsShell(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::registerPayloads);
        modEventBus.addListener(this::registerCapabilities);
        ModItems.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModFluids.register(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModDataComponents.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ShellConfig.SERVER_SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)OverlayConfig.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ModPacketHandler.register());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            if (CuriosCompat.isCuriosAvailable()) {
                try {
                    Class<?> shellLayerClass = Class.forName("com.etka.nomadsshell.client.curios.ShellLayer");
                    Supplier<Object> shellLayerSupplier = () -> {
                        try {
                            return shellLayerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to create ShellLayer instance", (Throwable)e);
                            return null;
                        }
                    };
                    CuriosCompat.registerCuriosRenderer(ModItems.shell.get(), shellLayerSupplier);
                    CuriosCompat.registerCuriosRenderer(ModItems.COPPER_shell.get(), shellLayerSupplier);
                    CuriosCompat.registerCuriosRenderer(ModItems.IRON_shell.get(), shellLayerSupplier);
                    CuriosCompat.registerCuriosRenderer(ModItems.GOLD_shell.get(), shellLayerSupplier);
                    CuriosCompat.registerCuriosRenderer(ModItems.EMERALD_shell.get(), shellLayerSupplier);
                    CuriosCompat.registerCuriosRenderer(ModItems.DIAMOND_shell.get(), shellLayerSupplier);
                    CuriosCompat.registerCuriosRenderer(ModItems.DIAMOND_BLOCK_shell.get(), shellLayerSupplier);
                    CuriosCompat.registerCuriosRenderer(ModItems.NETHERITE_shell.get(), shellLayerSupplier);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Failed to load ShellLayer class even though Curios is available", (Throwable)e);
                }
            }
        });
    }

    private void registerPayloads(RegisterPayloadHandlersEvent event) {
        ModPacketHandler.register(event);
    }

    @SubscribeEvent
    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        CuriosCompat.registerCuriosCapability(event, ModItems.shell.get(), (stack, context) -> {
            try {
                Class<?> iCurioClass = Class.forName("top.theillusivec4.curios.api.type.capability.ICurio");
                return Proxy.newProxyInstance(iCurioClass.getClassLoader(), new Class[]{iCurioClass}, (proxy, method, args) -> {
                    switch (method.getName()) {
                        case "getStack": {
                            return ItemStack.EMPTY;
                        }
                        case "canEquipFromUse": {
                            return true;
                        }
                    }
                    return null;
                });
            }
            catch (Exception e) {
                return null;
            }
        });
        BiFunction<ItemStack, Object, Object> createCurioCapability = (stack, context) -> {
            try {
                Class<?> iCurioClass = Class.forName("top.theillusivec4.curios.api.type.capability.ICurio");
                return Proxy.newProxyInstance(iCurioClass.getClassLoader(), new Class[]{iCurioClass}, (proxy, method, args) -> {
                    switch (method.getName()) {
                        case "getStack": {
                            return ItemStack.EMPTY;
                        }
                        case "canEquipFromUse": {
                            return true;
                        }
                    }
                    return null;
                });
            }
            catch (Exception e) {
                return null;
            }
        };
        CuriosCompat.registerCuriosCapability(event, ModItems.COPPER_shell.get(), createCurioCapability);
        CuriosCompat.registerCuriosCapability(event, ModItems.IRON_shell.get(), createCurioCapability);
        CuriosCompat.registerCuriosCapability(event, ModItems.GOLD_shell.get(), createCurioCapability);
        CuriosCompat.registerCuriosCapability(event, ModItems.EMERALD_shell.get(), createCurioCapability);
        CuriosCompat.registerCuriosCapability(event, ModItems.DIAMOND_shell.get(), createCurioCapability);
        CuriosCompat.registerCuriosCapability(event, ModItems.DIAMOND_BLOCK_shell.get(), createCurioCapability);
        CuriosCompat.registerCuriosCapability(event, ModItems.NETHERITE_shell.get(), createCurioCapability);
    }
}

