/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen;

import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.config.ShellConfig;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.item.ShellTier;
import com.etka.nomadsshell.network.UpdatePocketSettingsPacket;
import com.etka.nomadsshell.network.UpdateShellDimensionsPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;

public class AllSettingsScreen
extends Screen {
    private Tab currentTab = Tab.THIS_BACKPACK;
    private static final int TITLE_BAR_HEIGHT = 16;
    private static final int CLOSE_BTN_SIZE = 12;
    private static final int CONTENT_MARGIN = 12;
    private int tabHeight = 18;
    private int closeBtnX;
    private int closeBtnY;
    private int tabsX;
    private int tabsY;
    private int tabWidth;
    private int tabsGroupWidth;
    private int thisTabX;
    private int thisTabY;
    private int thisTabW;
    private int thisTabH;
    private int generalTabX;
    private int generalTabY;
    private int generalTabW;
    private int generalTabH;
    private int pocketTabX;
    private int pocketTabY;
    private int pocketTabW;
    private int pocketTabH;
    private EditBox widthField;
    private EditBox heightField;
    private Button applyBackpackBtn;
    private ItemStack shellStack = ItemStack.EMPTY;
    private ShellItem ShellItem;
    private boolean enableOverlay;
    private boolean enableTrash;
    private boolean enableFurnace;
    private boolean enableCrafting;
    private boolean enableSettings;
    private boolean enableUpgrade;
    private int displayMode;
    private int visibleHeight;
    private int tabCount;
    private int uiTheme;
    private int pocketWidth = 17;
    private int pocketLength = 17;
    private int pocketHeight = 25;
    private int pocketBackground = 0;
    private Button toggleOverlayBtn;
    private Button toggleTrashBtn;
    private Button toggleFurnaceBtn;
    private Button toggleCraftingBtn;
    private Button toggleSettingsBtn;
    private Button toggleUpgradeBtn;
    private Button cycleDisplayBtn;
    private Button vhMinusBtn;
    private Button vhPlusBtn;
    private Button tabMinusBtn;
    private Button tabPlusBtn;
    private Button applyGeneralBtn;
    private Button themeToggleBtn;
    private EditBox pocketWidthField;
    private EditBox pocketLengthField;
    private EditBox pocketHeightField;
    private Button pocketBackgroundBtn;
    private Button applyPocketBtn;

    public AllSettingsScreen() {
        super((Component)Component.literal((String)"All Settings"));
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            Item item;
            ItemStack worn = com.etka.nomadsshell.item.ShellItem.findWornshell((Player)player);
            if (!worn.isEmpty()) {
                this.shellStack = worn;
            } else {
                ItemStack main = player.getMainHandItem();
                if (main.getItem() instanceof ShellItem) {
                    this.shellStack = main;
                } else {
                    ItemStack off = player.getOffhandItem();
                    if (off.getItem() instanceof ShellItem) {
                        this.shellStack = off;
                    }
                }
            }
            if (!this.shellStack.isEmpty() && (item = this.shellStack.getItem()) instanceof ShellItem) {
                ShellItem ri;
                this.ShellItem = ri = (ShellItem)item;
            }
        }
        this.enableOverlay = (Boolean)OverlayConfig.ENABLE_OVERLAY_FEATURES.get();
        this.enableTrash = (Boolean)OverlayConfig.ENABLE_TRASH_BIN.get();
        this.enableFurnace = (Boolean)OverlayConfig.ENABLE_FURNACE.get();
        this.enableCrafting = (Boolean)OverlayConfig.ENABLE_CRAFTING_TABLE.get();
        this.enableSettings = (Boolean)OverlayConfig.ENABLE_SETTINGS.get();
        this.enableUpgrade = (Boolean)OverlayConfig.ENABLE_UPGRADE.get();
        this.displayMode = (Integer)OverlayConfig.SETTINGS_DISPLAY_MODE.get();
        this.visibleHeight = (Integer)OverlayConfig.SETTINGS_VISIBLE_HEIGHT.get();
        this.tabCount = (Integer)OverlayConfig.SETTINGS_TAB_COUNT.get();
        this.uiTheme = OverlayConfig.getUiTheme();
    }

    protected void init() {
        super.init();
        this.clearWidgets();
        int sw = this.width;
        int contentTop = 16;
        this.tabsY = contentTop + 6;
        this.tabWidth = Math.max(100, (sw - 24) / 6);
        this.tabsGroupWidth = this.tabWidth * 3 + 16;
        this.thisTabX = this.tabsX = (sw - this.tabsGroupWidth) / 2;
        this.thisTabY = this.tabsY;
        this.thisTabW = this.tabWidth;
        this.thisTabH = this.tabHeight;
        this.generalTabX = this.tabsX + this.tabWidth + 8;
        this.generalTabY = this.tabsY;
        this.generalTabW = this.tabWidth;
        this.generalTabH = this.tabHeight;
        this.pocketTabX = this.tabsX + this.tabWidth * 2 + 16;
        this.pocketTabY = this.tabsY;
        this.pocketTabW = this.tabWidth;
        this.pocketTabH = this.tabHeight;
        int contentX = 12;
        int contentY = this.tabsY + this.tabHeight + 10;
        if (this.currentTab == Tab.THIS_BACKPACK) {
            this.initBackpackTab(contentX, contentY);
        } else if (this.currentTab == Tab.GENERAL) {
            this.initGeneralTab(contentX, contentY);
        } else {
            this.initPocketDimensionTab(contentX, contentY);
        }
        this.closeBtnX = sw - 12 - 6;
        this.closeBtnY = 2;
    }

    private void switchTab(Tab tab) {
        if (this.currentTab != tab) {
            this.currentTab = tab;
            this.init();
        }
    }

    private void initBackpackTab(int contentX, int contentY) {
        int fieldW = 100;
        int fieldH = 20;
        int startY = contentY + 34;
        int labelX = contentX + 20;
        int fieldX = labelX + 110;
        if (this.ShellItem == null || this.shellStack.isEmpty()) {
            return;
        }
        int curW = this.ShellItem.getWidth(this.shellStack);
        int curH = this.ShellItem.getHeight(this.shellStack);
        this.widthField = new EditBox(this.font, fieldX, startY, fieldW, fieldH, (Component)Component.literal((String)"Width"));
        this.widthField.setMaxLength(5);
        this.widthField.setValue(String.valueOf(curW));
        this.widthField.setFilter(this::isNonNegativeInt);
        this.addRenderableWidget((GuiEventListener)this.widthField);
        this.heightField = new EditBox(this.font, fieldX, startY + 40, fieldW, fieldH, (Component)Component.literal((String)"Height"));
        this.heightField.setMaxLength(5);
        this.heightField.setValue(String.valueOf(curH));
        this.heightField.setFilter(this::isNonNegativeInt);
        this.addRenderableWidget((GuiEventListener)this.heightField);
        this.applyBackpackBtn = Button.builder((Component)Component.translatable((String)"nomadsshell.ui.apply"), this::applyBackpackChanges).bounds(fieldX - 10, startY + 80, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.applyBackpackBtn);
    }

    private void initGeneralTab(int contentX, int contentY) {
        int y = contentY + 40;
        int x = contentX + 20;
        int w = 140;
        this.themeToggleBtn = Button.builder((Component)Component.literal((String)this.themeLabel()), b -> {
            this.uiTheme = (this.uiTheme + 1) % 3;
            this.themeToggleBtn.setMessage((Component)Component.literal((String)this.themeLabel()));
        }).bounds(x, y, w + 40, 20).build();
        this.addRenderableWidget((GuiEventListener)this.themeToggleBtn);
        this.toggleOverlayBtn = Button.builder((Component)Component.literal((String)this.labelOnOff("Overlay Features", this.enableOverlay)), b -> {
            this.enableOverlay = !this.enableOverlay;
            this.toggleOverlayBtn.setMessage((Component)Component.literal((String)this.labelOnOff("Overlay Features", this.enableOverlay)));
        }).bounds(x, y += 26, w, 20).build();
        this.addRenderableWidget((GuiEventListener)this.toggleOverlayBtn);
        this.toggleTrashBtn = Button.builder((Component)Component.literal((String)this.labelOnOff("Trash Bin", this.enableTrash)), b -> {
            this.enableTrash = !this.enableTrash;
            this.toggleTrashBtn.setMessage((Component)Component.literal((String)this.labelOnOff("Trash Bin", this.enableTrash)));
        }).bounds(x, y += 24, w, 20).build();
        this.addRenderableWidget((GuiEventListener)this.toggleTrashBtn);
        this.toggleFurnaceBtn = Button.builder((Component)Component.literal((String)this.labelOnOff("Furnace", this.enableFurnace)), b -> {
            this.enableFurnace = !this.enableFurnace;
            this.toggleFurnaceBtn.setMessage((Component)Component.literal((String)this.labelOnOff("Furnace", this.enableFurnace)));
        }).bounds(x, y += 24, w, 20).build();
        this.addRenderableWidget((GuiEventListener)this.toggleFurnaceBtn);
        this.toggleCraftingBtn = Button.builder((Component)Component.literal((String)this.labelOnOff("Crafting", this.enableCrafting)), b -> {
            this.enableCrafting = !this.enableCrafting;
            this.toggleCraftingBtn.setMessage((Component)Component.literal((String)this.labelOnOff("Crafting", this.enableCrafting)));
        }).bounds(x, y += 24, w, 20).build();
        this.addRenderableWidget((GuiEventListener)this.toggleCraftingBtn);
        this.toggleSettingsBtn = Button.builder((Component)Component.literal((String)this.labelOnOff("Settings", this.enableSettings)), b -> {
            this.enableSettings = !this.enableSettings;
            this.toggleSettingsBtn.setMessage((Component)Component.literal((String)this.labelOnOff("Settings", this.enableSettings)));
        }).bounds(x, y += 24, w, 20).build();
        this.addRenderableWidget((GuiEventListener)this.toggleSettingsBtn);
        this.toggleUpgradeBtn = Button.builder((Component)Component.literal((String)this.labelOnOff("Upgrade", this.enableUpgrade)), b -> {
            this.enableUpgrade = !this.enableUpgrade;
            this.toggleUpgradeBtn.setMessage((Component)Component.literal((String)this.labelOnOff("Upgrade", this.enableUpgrade)));
        }).bounds(x, y += 24, w, 20).build();
        this.addRenderableWidget((GuiEventListener)this.toggleUpgradeBtn);
        this.cycleDisplayBtn = Button.builder((Component)Component.literal((String)this.displayModeLabel()), b -> {
            this.displayMode = (this.displayMode + 1) % 4;
            this.cycleDisplayBtn.setMessage((Component)Component.literal((String)this.displayModeLabel()));
        }).bounds(x, y += 30, w + 40, 20).build();
        this.addRenderableWidget((GuiEventListener)this.cycleDisplayBtn);
        this.vhMinusBtn = Button.builder((Component)Component.literal((String)"-"), b -> {
            int cur = this.visibleHeight <= 0 ? 10 : this.visibleHeight;
            this.visibleHeight = Math.max(1, cur - 1);
        }).bounds(x, y += 26, 20, 20).build();
        this.addRenderableWidget((GuiEventListener)this.vhMinusBtn);
        this.vhPlusBtn = Button.builder((Component)Component.literal((String)"+"), b -> {
            int maxRows = 512;
            int cur = this.visibleHeight <= 0 ? 10 : this.visibleHeight;
            this.visibleHeight = Math.min(maxRows, cur + 1);
        }).bounds(x + 24, y, 20, 20).build();
        this.addRenderableWidget((GuiEventListener)this.vhPlusBtn);
        this.tabMinusBtn = Button.builder((Component)Component.literal((String)"-"), b -> {
            this.tabCount = Math.max(1, this.tabCount - 1);
        }).bounds(x, y += 26, 20, 20).build();
        this.addRenderableWidget((GuiEventListener)this.tabMinusBtn);
        this.tabPlusBtn = Button.builder((Component)Component.literal((String)"+"), b -> {
            this.tabCount = Math.min(64, this.tabCount + 1);
        }).bounds(x + 24, y, 20, 20).build();
        this.addRenderableWidget((GuiEventListener)this.tabPlusBtn);
        this.applyGeneralBtn = Button.builder((Component)Component.translatable((String)"nomadsshell.ui.apply"), this::applyGeneralChanges).bounds(x, y += 30, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.applyGeneralBtn);
    }

    private void initPocketDimensionTab(int contentX, int contentY) {
        int y = contentY + 40;
        int x = contentX + 20;
        int fieldW = 100;
        int fieldH = 20;
        this.pocketWidthField = new EditBox(this.font, x + 120, y, fieldW, fieldH, (Component)Component.literal((String)"Width"));
        this.pocketWidthField.setMaxLength(5);
        this.pocketWidthField.setValue(String.valueOf(this.pocketWidth));
        this.pocketWidthField.setFilter(this::isNonNegativeInt);
        this.addRenderableWidget((GuiEventListener)this.pocketWidthField);
        this.pocketLengthField = new EditBox(this.font, x + 120, y += 30, fieldW, fieldH, (Component)Component.literal((String)"Length"));
        this.pocketLengthField.setMaxLength(5);
        this.pocketLengthField.setValue(String.valueOf(this.pocketLength));
        this.pocketLengthField.setFilter(this::isNonNegativeInt);
        this.addRenderableWidget((GuiEventListener)this.pocketLengthField);
        this.pocketHeightField = new EditBox(this.font, x + 120, y += 30, fieldW, fieldH, (Component)Component.literal((String)"Height"));
        this.pocketHeightField.setMaxLength(5);
        this.pocketHeightField.setValue(String.valueOf(this.pocketHeight));
        this.pocketHeightField.setFilter(this::isNonNegativeInt);
        this.addRenderableWidget((GuiEventListener)this.pocketHeightField);
        this.pocketBackgroundBtn = Button.builder((Component)Component.literal((String)this.pocketBackgroundLabel()), b -> {
            this.pocketBackground = (this.pocketBackground + 1) % 2;
            this.pocketBackgroundBtn.setMessage((Component)Component.literal((String)this.pocketBackgroundLabel()));
        }).bounds(x + 120, y += 30, 120, 20).build();
        this.addRenderableWidget((GuiEventListener)this.pocketBackgroundBtn);
        this.applyPocketBtn = Button.builder((Component)Component.translatable((String)"nomadsshell.ui.apply"), this::applyPocketChanges).bounds(x + 120, y += 40, 80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.applyPocketBtn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyBackpackChanges(Button ignored) {
        if (this.ShellItem == null || this.shellStack.isEmpty()) {
            return;
        }
        try {
            int w = Integer.parseInt(this.widthField.getValue());
            int h = Integer.parseInt(this.heightField.getValue());
            ShellTier tier = this.ShellItem.getTier();
            int maxW = ShellConfig.SERVER.getWidth(tier);
            int maxH = ShellConfig.SERVER.getHeight(tier);
            w = Math.max(1, Math.min(maxW, w));
            h = Math.max(1, Math.min(maxH, h));
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateShellDimensionsPacket(w, h), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (this.minecraft != null && this.minecraft.player == null) return;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyGeneralChanges(Button ignored) {
        try {
            OverlayConfig.ENABLE_OVERLAY_FEATURES.set((Object)this.enableOverlay);
            OverlayConfig.ENABLE_TRASH_BIN.set((Object)this.enableTrash);
            OverlayConfig.ENABLE_FURNACE.set((Object)this.enableFurnace);
            OverlayConfig.ENABLE_CRAFTING_TABLE.set((Object)this.enableCrafting);
            OverlayConfig.ENABLE_SETTINGS.set((Object)this.enableSettings);
            OverlayConfig.ENABLE_UPGRADE.set((Object)this.enableUpgrade);
            OverlayConfig.SETTINGS_DISPLAY_MODE.set((Object)this.displayMode);
            OverlayConfig.SETTINGS_VISIBLE_HEIGHT.set((Object)Math.max(0, this.visibleHeight));
            OverlayConfig.SETTINGS_TAB_COUNT.set((Object)Math.max(1, Math.min(64, this.tabCount)));
            OverlayConfig.UI_THEME.set((Object)this.uiTheme);
            OverlayConfig.SPEC.save();
            if (this.minecraft != null && this.minecraft.player == null) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyPocketChanges(Button ignored) {
        try {
            this.pocketWidth = Math.max(1, Integer.parseInt(this.pocketWidthField.getValue()));
            this.pocketLength = Math.max(1, Integer.parseInt(this.pocketLengthField.getValue()));
            this.pocketHeight = Math.max(3, Integer.parseInt(this.pocketHeightField.getValue()));
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdatePocketSettingsPacket(this.pocketWidth, this.pocketLength, this.pocketHeight, this.pocketBackground), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (this.minecraft != null && this.minecraft.player == null) return;
        }
        catch (NumberFormatException e) {
            if (this.minecraft != null && this.minecraft.player == null) return;
        }
    }

    private String pocketBackgroundLabel() {
        return this.pocketBackground == 1 ? "Background: Overworld" : "Background: End";
    }

    private boolean isNonNegativeInt(String s) {
        if (s == null || s.isEmpty()) {
            return true;
        }
        try {
            return Integer.parseInt(s) >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private String labelOnOff(String base, boolean on) {
        return base + ": " + (on ? Component.translatable((String)"nomadsshell.ui.on").getString() : Component.translatable((String)"nomadsshell.ui.off").getString());
    }

    private String displayModeLabel() {
        return switch (this.displayMode) {
            case 1 -> "Mode: Scroll Bar";
            case 2 -> Component.translatable((String)"nomadsshell.ui.mode_tabs").getString();
            case 3 -> Component.translatable((String)"nomadsshell.ui.mode_both").getString();
            default -> Component.translatable((String)"nomadsshell.ui.mode_default").getString();
        };
    }

    private String themeLabel() {
        return switch (this.uiTheme) {
            case 1 -> Component.translatable((String)"nomadsshell.ui.theme_light").getString();
            case 2 -> Component.translatable((String)"nomadsshell.ui.theme_minecraft").getString();
            default -> Component.translatable((String)"nomadsshell.ui.theme_dark").getString();
        };
    }

    public void renderBackground(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        g.fill(0, 0, this.width, this.height, Theme.overlayDim());
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(g, mouseX, mouseY, partialTick);
        int sw = this.width;
        int sh = this.height;
        g.fill(0, 0, sw, 16, Theme.titleBarBg());
        g.fill(0, 15, sw, 16, Theme.titleBarBorder());
        try {
            ItemStack ruck = com.etka.nomadsshell.item.ShellItem.findWornshell((Player)Minecraft.getInstance().player);
            if (!ruck.isEmpty()) {
                g.renderItem(ruck, 6, 2);
            } else {
                g.renderItem(new ItemStack((ItemLike)Items.BUNDLE), 6, 2);
            }
        }
        catch (Throwable ruck) {
            // empty catch block
        }
        g.drawString(this.font, Component.translatable((String)"nomadsshell.settings.title").getString(), 26, 4, Theme.titleText());
        g.drawString(this.font, Component.translatable((String)"nomadsshell.settings.close_hint").getString(), sw - 70, 4, Theme.hintText());
        int closeX = this.closeBtnX;
        int closeY = this.closeBtnY;
        g.fill(closeX, closeY, closeX + 12, closeY + 12, Theme.panelBg());
        g.fill(closeX - 1, closeY - 1, closeX + 12 + 1, closeY, Theme.titleBarBorder());
        g.fill(closeX - 1, closeY + 12, closeX + 12 + 1, closeY + 12 + 1, Theme.titleBarBorder());
        g.fill(closeX - 1, closeY, closeX, closeY + 12, Theme.titleBarBorder());
        g.fill(closeX + 12, closeY, closeX + 12 + 1, closeY + 12, Theme.titleBarBorder());
        g.fill(closeX + 3, closeY + 3, closeX + 12 - 3, closeY + 4, -1907998);
        g.fill(closeX + 3, closeY + 12 - 4, closeX + 12 - 3, closeY + 12 - 3, -1907998);
        g.fill(closeX + 3, closeY + 3, closeX + 4, closeY + 12 - 3, -1907998);
        g.fill(closeX + 12 - 4, closeY + 3, closeX + 12 - 3, closeY + 12 - 3, -1907998);
        int contentTop = 16;
        g.fill(0, contentTop, sw, sh, Theme.contentBg());
        g.fill(0, contentTop, sw, contentTop + 1, Theme.contentTopLine());
        this.renderTabs(g, mouseX, mouseY);
        int titleY = contentTop + 30;
        String title = switch (this.currentTab.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Component.translatable((String)"nomadsshell.ui.this_backpack").getString();
            case 1 -> Component.translatable((String)"nomadsshell.ui.general").getString();
            case 2 -> Component.translatable((String)"nomadsshell.ui.pocket_dimension").getString();
        };
        g.drawCenteredString(this.font, title, sw / 2, titleY, Theme.textPrimary());
        int contentX = 12;
        int contentY = contentTop + 28;
        if (this.currentTab == Tab.THIS_BACKPACK) {
            this.renderBackpackTab(g, contentX, contentY);
        } else if (this.currentTab == Tab.GENERAL) {
            this.renderGeneralTab(g, contentX, contentY);
        } else {
            this.renderPocketDimensionTab(g, contentX, contentY);
        }
        for (Renderable widget : this.renderables) {
            widget.render(g, mouseX, mouseY, partialTick);
        }
    }

    private void renderTabs(GuiGraphics g, int mouseX, int mouseY) {
        int sepY = this.tabsY + this.tabHeight + 2;
        g.fill(this.tabsX, sepY, this.tabsX + this.tabsGroupWidth, sepY + 1, Theme.contentTopLine());
        this.drawTab(g, mouseX, mouseY, this.thisTabX, this.thisTabY, this.thisTabW, this.thisTabH, Component.translatable((String)"nomadsshell.ui.this_backpack").getString(), this.currentTab == Tab.THIS_BACKPACK);
        this.drawTab(g, mouseX, mouseY, this.generalTabX, this.generalTabY, this.generalTabW, this.generalTabH, Component.translatable((String)"nomadsshell.ui.general").getString(), this.currentTab == Tab.GENERAL);
        this.drawTab(g, mouseX, mouseY, this.pocketTabX, this.pocketTabY, this.pocketTabW, this.pocketTabH, Component.translatable((String)"nomadsshell.ui.pocket_dimension").getString(), this.currentTab == Tab.POCKET_DIMENSION);
    }

    private void drawTab(GuiGraphics g, int mouseX, int mouseY, int x, int y, int w, int h, String label, boolean active) {
        boolean hovered;
        boolean bl = hovered = mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
        if (hovered && !active) {
            int hoverOverlay = Theme.isLight() ? 0x14000000 : 0x14FFFFFF;
            g.fill(x, y, x + w, y + h, hoverOverlay);
        }
        int tw = this.font.width(label);
        int tx = x + (w - tw) / 2;
        int ty = y + (h - 8) / 2;
        g.drawString(this.font, label, tx, ty, active ? Theme.textPrimary() : Theme.textSecondary());
        if (active) {
            int ux = x + Math.max(6, (w - tw) / 2 - 6);
            int uw = Math.min(w - 12, tw + 12);
            int uy = y + h + 1;
            g.fill(ux, uy, ux + uw, uy + 2, Theme.titleBarBorder());
        }
    }

    private void renderBackpackTab(GuiGraphics g, int contentX, int contentY) {
        int centerX = this.width / 2;
        if (this.ShellItem == null || this.shellStack.isEmpty()) {
            g.drawCenteredString(this.font, "No shell found to configure.", centerX, contentY + 60, 0xFF8888);
            return;
        }
        int curW = this.ShellItem.getWidth(this.shellStack);
        int curH = this.ShellItem.getHeight(this.shellStack);
        int slots = curW * curH;
        ShellTier tier = this.ShellItem.getTier();
        int maxW = ShellConfig.SERVER.getWidth(tier);
        int maxH = ShellConfig.SERVER.getHeight(tier);
        g.drawCenteredString(this.font, Component.translatable((String)"nomadsshell.settings.current_config", (Object[])new Object[]{curW, curH, slots}).getString(), centerX, contentY + 20, Theme.textSecondary());
        g.drawString(this.font, Component.translatable((String)"nomadsshell.settings.width").getString() + " (1.." + maxW + "):", contentX + 20, contentY + 44, Theme.textPrimary());
        g.drawString(this.font, Component.translatable((String)"nomadsshell.settings.height").getString() + " (1.." + maxH + "):", contentX + 20, contentY + 84, Theme.textPrimary());
        try {
            int w = Integer.parseInt(this.widthField.getValue());
            int h = Integer.parseInt(this.heightField.getValue());
            int total = Math.max(1, w) * Math.max(1, h);
            int color = total <= 256 ? 0x55FF55 : (total <= 1000 ? 0xFFAA00 : 0xFF5555);
            g.drawCenteredString(this.font, "Preview: " + w + "\u00d7" + h + " (" + total + ")", centerX, contentY + 114, color);
        }
        catch (NumberFormatException ignored) {
            g.drawCenteredString(this.font, "Invalid input", centerX, contentY + 114, 0xFF5555);
        }
    }

    private void renderGeneralTab(GuiGraphics g, int contentX, int contentY) {
        int x = contentX + 20;
        int sectionY = contentY + 40;
        g.drawString(this.font, Component.translatable((String)"nomadsshell.settings.widgets").getString(), x, sectionY - 12, Theme.textPrimary());
        int dispY = sectionY + 6 + 144 + 8;
        g.drawString(this.font, Component.translatable((String)"nomadsshell.settings.display").getString(), x, dispY - 12, Theme.textPrimary());
        g.drawString(this.font, Component.translatable((String)"nomadsshell.settings.visible_height_value", (Object[])new Object[]{this.visibleHeight <= 0 ? Component.translatable((String)"nomadsshell.ui.auto").getString() : String.valueOf(this.visibleHeight)}).getString(), x + 50, dispY + 16, Theme.textSecondary());
        g.drawString(this.font, Component.translatable((String)"nomadsshell.settings.tabs_value", (Object[])new Object[]{this.tabCount}).getString(), x + 50, dispY + 42, Theme.textSecondary());
    }

    private void renderPocketDimensionTab(GuiGraphics g, int contentX, int contentY) {
        int x = contentX + 20;
        int y = contentY + 40;
        g.drawString(this.font, Component.translatable((String)"nomadsshell.settings.pocket_width").getString(), x, y, Theme.textPrimary());
        g.drawString(this.font, Component.translatable((String)"nomadsshell.settings.pocket_length").getString(), x, y += 30, Theme.textPrimary());
        g.drawString(this.font, Component.translatable((String)"nomadsshell.settings.pocket_height").getString(), x, y += 30, Theme.textPrimary());
        g.drawString(this.font, Component.translatable((String)"nomadsshell.settings.pocket_background").getString(), x, y += 30, Theme.textPrimary());
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (mouseX >= (double)this.closeBtnX && mouseX <= (double)(this.closeBtnX + 12) && mouseY >= (double)this.closeBtnY && mouseY <= (double)(this.closeBtnY + 12)) {
                this.onClose();
                return true;
            }
            if (mouseX >= (double)this.thisTabX && mouseX <= (double)(this.thisTabX + this.thisTabW) && mouseY >= (double)this.thisTabY && mouseY <= (double)(this.thisTabY + this.thisTabH)) {
                this.switchTab(Tab.THIS_BACKPACK);
                return true;
            }
            if (mouseX >= (double)this.generalTabX && mouseX <= (double)(this.generalTabX + this.generalTabW) && mouseY >= (double)this.generalTabY && mouseY <= (double)(this.generalTabY + this.generalTabH)) {
                this.switchTab(Tab.GENERAL);
                return true;
            }
            if (mouseX >= (double)this.pocketTabX && mouseX <= (double)(this.pocketTabX + this.pocketTabW) && mouseY >= (double)this.pocketTabY && mouseY <= (double)(this.pocketTabY + this.pocketTabH)) {
                this.switchTab(Tab.POCKET_DIMENSION);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 69 || keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private static enum Tab {
        THIS_BACKPACK,
        GENERAL,
        POCKET_DIMENSION;

    }
}

