/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen;

import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.ShellConfig;
import com.etka.nomadsshell.item.ShellTier;
import com.etka.nomadsshell.network.ConfigUpdatePacket;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class ConfigScreen
extends Screen {
    private static final int BASE_PANEL_WIDTH = 500;
    private static final int BASE_PANEL_HEIGHT = 280;
    private static final int MIN_PANEL_WIDTH = 400;
    private static final int MIN_PANEL_HEIGHT = 220;
    private static final int BUTTON_WIDTH = 120;
    private static final int BUTTON_HEIGHT = 20;
    private static final int ROW_HEIGHT = 30;
    private int panelWidth;
    private int panelHeight;
    private int colSpacing;
    private int fieldWidth;
    private boolean useCompactLayout;
    private final Map<ShellTier, EditBox> widthFields = new HashMap<ShellTier, EditBox>();
    private final Map<ShellTier, EditBox> heightFields = new HashMap<ShellTier, EditBox>();

    public ConfigScreen() {
        super((Component)Component.literal((String)"shell Configuration"));
    }

    protected void init() {
        super.init();
        this.calculateLayout();
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int startX = centerX - this.panelWidth / 2 + 20;
        int startY = centerY - this.panelHeight / 2 + 40;
        ShellTier[] tiers = ShellTier.values();
        if (this.useCompactLayout) {
            this.createSingleColumnLayout(startX, startY, tiers);
        } else {
            this.createTwoColumnLayout(startX, startY, tiers);
        }
        int buttonY = centerY + this.panelHeight / 2 - 35;
        int totalButtonWidth = 260;
        if (totalButtonWidth <= this.panelWidth - 40) {
            int buttonStartX = centerX - totalButtonWidth / 2;
            Button saveButton = Button.builder((Component)Component.literal((String)"Save"), this::saveConfig).bounds(buttonStartX, buttonY, 120, 20).build();
            this.addRenderableWidget((GuiEventListener)saveButton);
            Button cancelButton = Button.builder((Component)Component.literal((String)"Cancel"), btn -> this.onClose()).bounds(buttonStartX + 120 + 20, buttonY, 120, 20).build();
            this.addRenderableWidget((GuiEventListener)cancelButton);
        } else {
            int buttonX = centerX - 60;
            Button saveButton = Button.builder((Component)Component.literal((String)"Save"), this::saveConfig).bounds(buttonX, buttonY - 12, 120, 20).build();
            this.addRenderableWidget((GuiEventListener)saveButton);
            Button cancelButton = Button.builder((Component)Component.literal((String)"Cancel"), btn -> this.onClose()).bounds(buttonX, buttonY + 12, 120, 20).build();
            this.addRenderableWidget((GuiEventListener)cancelButton);
        }
        if (!this.widthFields.isEmpty()) {
            this.setInitialFocus((GuiEventListener)this.widthFields.get((Object)ShellTier.LEATHER));
        }
    }

    private void calculateLayout() {
        double baseWidth = 800.0;
        double scaleX = (double)this.width / baseWidth;
        double baseHeight = 600.0;
        double scaleY = (double)this.height / baseHeight;
        double screenScale = Math.min(scaleX, scaleY);
        if (screenScale > 1.5) {
            screenScale = 1.0 + (screenScale - 1.0) * 0.6;
        }
        screenScale = Math.max(0.7, Math.min(2.0, screenScale));
        this.panelWidth = Math.max(400, (int)(500.0 * screenScale));
        this.panelHeight = Math.max(220, (int)(280.0 * screenScale));
        int marginX = Math.max(40, this.width / 20);
        int marginY = Math.max(40, this.height / 15);
        this.panelWidth = Math.min(this.panelWidth, this.width - marginX);
        this.panelHeight = Math.min(this.panelHeight, this.height - marginY);
        this.fieldWidth = Math.max(45, Math.min(70, this.panelWidth / 10));
        this.colSpacing = this.width >= 1920 ? this.panelWidth / 2 - 20 : (int)((double)this.panelWidth / 2.2);
        boolean bl = this.useCompactLayout = this.width < 700 || this.height < 450 || this.panelWidth < 500;
        if (this.useCompactLayout) {
            this.panelHeight = Math.max(this.panelHeight, 380);
            this.panelHeight = Math.min(this.panelHeight, this.height - marginY);
        }
    }

    private void createSingleColumnLayout(int startX, int startY, ShellTier[] tiers) {
        int tiersPerColumn = tiers.length;
        int currentRowHeight = Math.min(30, (this.panelHeight - 100) / tiersPerColumn);
        for (int i = 0; i < tiers.length; ++i) {
            ShellTier tier = tiers[i];
            int x = startX + 10;
            int y = startY + i * currentRowHeight;
            this.createTierFields(tier, x, y);
        }
    }

    private void createTwoColumnLayout(int startX, int startY, ShellTier[] tiers) {
        int tiersPerColumn = 4;
        for (int i = 0; i < tiers.length; ++i) {
            ShellTier tier = tiers[i];
            int col = i / tiersPerColumn;
            int row = i % tiersPerColumn;
            int x = startX + col * this.colSpacing;
            int y = startY + row * 30;
            this.createTierFields(tier, x, y);
        }
    }

    private void createTierFields(ShellTier tier, int x, int y) {
        int labelWidth = this.useCompactLayout ? Math.max(60, this.panelWidth / 8) : Math.max(80, this.panelWidth / 7);
        int spacing = this.useCompactLayout ? Math.max(10, this.fieldWidth / 5) : Math.max(12, this.fieldWidth / 4);
        int widthFieldX = x + labelWidth;
        int heightFieldX = widthFieldX + this.fieldWidth + spacing;
        EditBox widthField = new EditBox(this.font, widthFieldX, y, this.fieldWidth, 18, (Component)Component.literal((String)"Width"));
        widthField.setMaxLength(5);
        widthField.setValue(String.valueOf(ShellConfig.SERVER.getWidth(tier)));
        widthField.setFilter(this::isValidNumber);
        widthField.setBordered(true);
        this.addRenderableWidget((GuiEventListener)widthField);
        this.widthFields.put(tier, widthField);
        EditBox heightField = new EditBox(this.font, heightFieldX, y, this.fieldWidth, 18, (Component)Component.literal((String)"Height"));
        heightField.setMaxLength(5);
        heightField.setValue(String.valueOf(ShellConfig.SERVER.getHeight(tier)));
        heightField.setFilter(this::isValidNumber);
        heightField.setBordered(true);
        this.addRenderableWidget((GuiEventListener)heightField);
        this.heightFields.put(tier, heightField);
    }

    private boolean isValidNumber(String text) {
        if (text.isEmpty()) {
            return true;
        }
        try {
            int value = Integer.parseInt(text);
            return value > 0 && value <= 10000;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void saveConfig(Button button) {
        try {
            HashMap<ShellTier, ConfigUpdatePacket.ConfigData> tierConfigs = new HashMap<ShellTier, ConfigUpdatePacket.ConfigData>();
            for (ShellTier tier : ShellTier.values()) {
                String widthText = this.widthFields.get((Object)tier).getValue();
                String heightText = this.heightFields.get((Object)tier).getValue();
                if (widthText.isEmpty() || heightText.isEmpty()) {
                    if (this.minecraft == null || this.minecraft.player != null) {
                        // empty if block
                    }
                    return;
                }
                int width = Integer.parseInt(widthText);
                int height = Integer.parseInt(heightText);
                if (width <= 0 || height <= 0) {
                    if (this.minecraft == null || this.minecraft.player != null) {
                        // empty if block
                    }
                    return;
                }
                tierConfigs.put(tier, new ConfigUpdatePacket.ConfigData(width, height));
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ConfigUpdatePacket(tierConfigs), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (this.minecraft == null || this.minecraft.player != null) {
                // empty if block
            }
            this.onClose();
        }
        catch (NumberFormatException e) {
            if (this.minecraft == null || this.minecraft.player != null) {
                // empty if block
            }
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelX = centerX - this.panelWidth / 2;
        int panelY = centerY - this.panelHeight / 2;
        guiGraphics.fill(panelX, panelY, panelX + this.panelWidth, panelY + this.panelHeight, Theme.overlayDim());
        guiGraphics.fill(panelX + 1, panelY + 1, panelX + this.panelWidth - 1, panelY + this.panelHeight - 1, Theme.panelBg());
        guiGraphics.drawCenteredString(this.font, this.title, centerX, panelY + 10, 0xFFFFFF);
        int startX = centerX - this.panelWidth / 2 + 20;
        int startY = centerY - this.panelHeight / 2 + 40;
        if (this.useCompactLayout) {
            this.renderSingleColumnLayout(guiGraphics, startX, startY);
        } else {
            this.renderTwoColumnLayout(guiGraphics, startX, startY);
        }
        for (Renderable widget : this.renderables) {
            widget.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    private void renderSingleColumnLayout(GuiGraphics guiGraphics, int startX, int startY) {
        int labelWidth = Math.max(60, this.panelWidth / 8);
        int spacing = Math.max(10, this.fieldWidth / 5);
        int widthHeaderX = startX + labelWidth;
        int heightHeaderX = widthHeaderX + this.fieldWidth + spacing;
        int slotsHeaderX = heightHeaderX + this.fieldWidth + spacing + 15;
        guiGraphics.drawString(this.font, "Tier", startX, startY - 20, 0xFFFFFF);
        guiGraphics.drawString(this.font, "W", widthHeaderX, startY - 20, 0xFFFFFF);
        guiGraphics.drawString(this.font, "H", heightHeaderX, startY - 20, 0xFFFFFF);
        guiGraphics.drawString(this.font, "Slots", slotsHeaderX, startY - 20, 0xFFFFFF);
        ShellTier[] tiers = ShellTier.values();
        int currentRowHeight = Math.min(30, (this.panelHeight - 100) / tiers.length);
        for (int i = 0; i < tiers.length; ++i) {
            ShellTier tier = tiers[i];
            int y = startY + i * currentRowHeight;
            this.renderTierData(guiGraphics, tier, startX, y);
        }
    }

    private void renderTwoColumnLayout(GuiGraphics guiGraphics, int startX, int startY) {
        int labelWidth = Math.max(80, this.panelWidth / 7);
        int spacing = Math.max(12, this.fieldWidth / 4);
        int widthHeaderX = startX + labelWidth;
        int heightHeaderX = widthHeaderX + this.fieldWidth + spacing;
        int slotsHeaderX = heightHeaderX + this.fieldWidth + spacing + 15;
        guiGraphics.drawString(this.font, "Tier", startX, startY - 20, 0xFFFFFF);
        guiGraphics.drawString(this.font, "Width", widthHeaderX, startY - 20, 0xFFFFFF);
        guiGraphics.drawString(this.font, "Height", heightHeaderX, startY - 20, 0xFFFFFF);
        guiGraphics.drawString(this.font, "Slots", slotsHeaderX, startY - 20, 0xFFFFFF);
        int col2X = startX + this.colSpacing;
        int widthHeaderX2 = col2X + labelWidth;
        int heightHeaderX2 = widthHeaderX2 + this.fieldWidth + spacing;
        int slotsHeaderX2 = heightHeaderX2 + this.fieldWidth + spacing + 15;
        guiGraphics.drawString(this.font, "Tier", col2X, startY - 20, 0xFFFFFF);
        guiGraphics.drawString(this.font, "Width", widthHeaderX2, startY - 20, 0xFFFFFF);
        guiGraphics.drawString(this.font, "Height", heightHeaderX2, startY - 20, 0xFFFFFF);
        guiGraphics.drawString(this.font, "Slots", slotsHeaderX2, startY - 20, 0xFFFFFF);
        ShellTier[] tiers = ShellTier.values();
        int tiersPerColumn = 4;
        for (int i = 0; i < tiers.length; ++i) {
            ShellTier tier = tiers[i];
            int col = i / tiersPerColumn;
            int row = i % tiersPerColumn;
            int x = startX + col * this.colSpacing;
            int y = startY + row * 30;
            this.renderTierData(guiGraphics, tier, x, y);
        }
    }

    private void renderTierData(GuiGraphics guiGraphics, ShellTier tier, int x, int y) {
        String displayName;
        int labelWidth = this.useCompactLayout ? Math.max(60, this.panelWidth / 8) : Math.max(80, this.panelWidth / 7);
        int spacing = this.useCompactLayout ? Math.max(10, this.fieldWidth / 5) : Math.max(12, this.fieldWidth / 4);
        String tierName = tier.getName().replace("_", " ");
        if (this.useCompactLayout) {
            displayName = switch (tier) {
                default -> throw new MatchException(null, null);
                case ShellTier.LEATHER -> "Lthr";
                case ShellTier.COPPER -> "Cpr";
                case ShellTier.IRON -> "Iron";
                case ShellTier.GOLD -> "Gold";
                case ShellTier.EMERALD -> "Emrld";
                case ShellTier.DIAMOND -> "Dmnd";
                case ShellTier.DIAMOND_BLOCK -> "DBlk";
                case ShellTier.NETHERITE -> "Nthr";
            };
        } else {
            displayName = switch (tier) {
                case ShellTier.DIAMOND_BLOCK -> "Diamond Blk";
                default -> tierName.substring(0, 1).toUpperCase() + tierName.substring(1).toLowerCase();
            };
        }
        guiGraphics.drawString(this.font, displayName, x, y + 5, 0xFFFFFF);
        int multiplyX = x + labelWidth + this.fieldWidth + spacing / 2;
        if (this.useCompactLayout) {
            multiplyX += 2;
        }
        guiGraphics.drawString(this.font, "\u00d7", multiplyX, y + 5, 0xFFFFFF);
        EditBox widthField = this.widthFields.get((Object)tier);
        EditBox heightField = this.heightFields.get((Object)tier);
        if (widthField != null && heightField != null) {
            String widthText = widthField.getValue();
            String heightText = heightField.getValue();
            if (!widthText.isEmpty() && !heightText.isEmpty()) {
                try {
                    int color;
                    int width = Integer.parseInt(widthText);
                    int height = Integer.parseInt(heightText);
                    int totalSlots = width * height;
                    int n = color = totalSlots <= 256 ? 0x55FF55 : 0xFFAA00;
                    if (totalSlots > 1000) {
                        color = 0xFF5555;
                    }
                    int slotsX = x + labelWidth + this.fieldWidth * 2 + spacing * 2 + 15;
                    guiGraphics.drawString(this.font, String.valueOf(totalSlots), slotsX, y + 5, color);
                }
                catch (NumberFormatException e) {
                    int slotsX = x + labelWidth + this.fieldWidth * 2 + spacing * 2 + 15;
                    guiGraphics.drawString(this.font, "Invalid", slotsX, y + 5, 0xFF5555);
                }
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }
}

