/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.LockableWidget;
import com.etka.nomadsshell.client.screen.overlay.OverlayIdleState;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.menu.IShellMenu;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CompassWidget
extends LockableWidget {
    private static final int TITLE_BAR_HEIGHT = 12;
    private boolean imageMode = false;

    private static int loadPositionX(int defaultX) {
        int configX = (Integer)OverlayConfig.COMPASS_X.get();
        return configX != 0 ? configX : defaultX;
    }

    private static int loadPositionY(int defaultY) {
        int configY = (Integer)OverlayConfig.COMPASS_Y.get();
        return configY != 0 ? configY : defaultY;
    }

    private void savePositionToConfig() {
        OverlayConfig.COMPASS_X.set((Object)this.getX());
        OverlayConfig.COMPASS_Y.set((Object)this.getY());
        OverlayConfig.SPEC.save();
    }

    private void savePinStateToConfig() {
        OverlayConfig.COMPASS_PINNED.set((Object)this.isPinned);
        OverlayConfig.SPEC.save();
    }

    public CompassWidget(int x, int y, Font font, IShellMenu menu) {
        super(CompassWidget.loadPositionX(x), CompassWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.widget.compass"), font, WidgetUnlockSystem.WidgetType.COMPASS, menu);
        this.isPinned = (Boolean)OverlayConfig.COMPASS_PINNED.get();
    }

    @Override
    protected void renderExpandedContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void renderMainContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean titleBarHovered;
        int x = this.getX();
        int y = this.getY();
        int currentWidth = 36;
        boolean enableImageMode = (Boolean)OverlayConfig.COMPASS_USE_IMAGE_MODE.get();
        this.imageMode = enableImageMode && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.COMPASS);
        boolean hoveredWidget = mouseX >= x && mouseX <= x + 36 && mouseY >= y && mouseY <= y + 36;
        boolean showImageMode = this.imageMode && !hoveredWidget;
        guiGraphics.fill(x, y, x + currentWidth, y + 12, Theme.titleBarBg());
        guiGraphics.fill(x - 1, y - 1, x + currentWidth + 1, y + 12, Theme.panelBorder());
        guiGraphics.fill(x, y, x + currentWidth, y + 12, Theme.titleBarBg());
        boolean bl = titleBarHovered = mouseX >= x && mouseX <= x + currentWidth && mouseY >= y && mouseY <= y + 12;
        if (titleBarHovered || this.isDragging) {
            int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            guiGraphics.fill(x, y, x + currentWidth, y + 12, hoverOverlay);
        }
        int contentY = y + 12;
        int contentHeight = 24;
        guiGraphics.fill(x, contentY, x + 36, contentY + contentHeight, Theme.panelBg());
        guiGraphics.fill(x - 1, contentY - 1, x + 36 + 1, contentY + contentHeight + 1, Theme.panelBorder());
        guiGraphics.fill(x, contentY, x + 36, contentY + contentHeight, Theme.panelBg());
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            if (showImageMode) {
                this.renderCompassImage(guiGraphics, x, contentY, 36, contentHeight, mc.player.getYRot());
            } else {
                String direction = this.getPlayerDirection(mc.player.getYRot());
                int textWidth = this.font.width(direction);
                int textX = x + (36 - textWidth) / 2;
                Objects.requireNonNull(this.font);
                int textY = contentY + (contentHeight - 9) / 2;
                int textColor = Theme.isLight() ? -13421773 : -1;
                guiGraphics.drawString(this.font, direction, textX, textY, textColor, false);
            }
        }
        if (this.showContextMenu) {
            this.renderContextMenu(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderCompassImage(GuiGraphics guiGraphics, int x, int y, int width, int height, float playerYaw) {
        ResourceLocation compassTexture = Theme.icon("compass");
        float rotationAngle = 180.0f - playerYaw;
        int centerX = x + width / 2;
        int centerY = y + height / 2;
        int imageSize = 16;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)centerX, (float)centerY, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(rotationAngle));
        poseStack.translate((double)(-imageSize) / 2.0, (double)(-imageSize) / 2.0, 0.0);
        try {
            guiGraphics.blit(compassTexture, 0, 0, 0.0f, 0.0f, imageSize, imageSize, imageSize, imageSize);
        }
        catch (Throwable t) {
            this.drawSimpleArrow(guiGraphics, 0, 0, imageSize);
        }
        poseStack.popPose();
    }

    private void drawSimpleArrow(GuiGraphics guiGraphics, int x, int y, int size) {
        int centerX = x + size / 2;
        int color = -65536;
        guiGraphics.fill(centerX - 1, y + 4, centerX + 1, y + size - 2, color);
        guiGraphics.fill(centerX - 3, y + 4, centerX + 3, y + 5, color);
        guiGraphics.fill(centerX - 2, y + 3, centerX + 2, y + 4, color);
        guiGraphics.fill(centerX - 1, y + 2, centerX + 1, y + 3, color);
    }

    private String getPlayerDirection(float yaw) {
        if ((yaw = Mth.wrapDegrees((float)yaw)) < 0.0f) {
            yaw += 360.0f;
        }
        if ((double)yaw >= 337.5 || (double)yaw < 22.5) {
            return "S";
        }
        if ((double)yaw >= 22.5 && (double)yaw < 67.5) {
            return "SW";
        }
        if ((double)yaw >= 67.5 && (double)yaw < 112.5) {
            return "W";
        }
        if ((double)yaw >= 112.5 && (double)yaw < 157.5) {
            return "NW";
        }
        if ((double)yaw >= 157.5 && (double)yaw < 202.5) {
            return "N";
        }
        if ((double)yaw >= 202.5 && (double)yaw < 247.5) {
            return "NE";
        }
        if ((double)yaw >= 247.5 && (double)yaw < 292.5) {
            return "E";
        }
        return "SE";
    }

    @Override
    protected boolean hasSideEars() {
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isDragging && button == 0) {
            this.isDragging = false;
            this.savePositionToConfig();
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        this.savePinStateToConfig();
    }

    @Override
    protected String getContextMenuLabel() {
        boolean enabled = (Boolean)OverlayConfig.COMPASS_USE_IMAGE_MODE.get();
        return enabled ? Component.translatable((String)"nomadsshell.ui.disable_image_mode").getString() : Component.translatable((String)"nomadsshell.ui.enable_image_mode").getString();
    }

    @Override
    protected void handleContextMenuAction() {
        boolean enabled = (Boolean)OverlayConfig.COMPASS_USE_IMAGE_MODE.get();
        OverlayConfig.COMPASS_USE_IMAGE_MODE.set((Object)(!enabled ? 1 : 0));
        OverlayConfig.SPEC.save();
    }
}

