/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.LockableWidget;
import com.etka.nomadsshell.client.screen.overlay.OverlayIdleState;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.network.DripstoneFarmActionPacket;
import com.etka.nomadsshell.util.FluidStackData;
import com.etka.nomadsshell.util.WidgetDataHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.network.PacketDistributor;

public class DripstoneFarmWidget
extends LockableWidget {
    private static final int TITLE_BAR_HEIGHT = 12;
    private static final int DEFAULT_WIDTH = 168;
    private static final int DEFAULT_HEIGHT = 110;
    private static final int SLOT_SIZE = 18;
    private static final int CONTROL_BUTTON_SIZE = 8;
    private boolean logoMode = false;
    private int pendingForceIndex = -1;
    private int pendingTakeSourceIndex = -1;
    private int cachedCauldronCount = 0;
    private final FluidStackData[] cachedSourceFluids = new FluidStackData[5];
    private final int[] cachedCauldronMb = new int[5];
    private final ItemStack[] cachedBottomItems = new ItemStack[5];
    private final int[] cachedTargetContainers = new int[5];
    private final boolean[] waitingForSync = new boolean[5];

    private static int loadPositionX(int defaultX) {
        int cx = (Integer)OverlayConfig.DRIPSTONE_X.get();
        return cx != 0 ? cx : defaultX;
    }

    private static int loadPositionY(int defaultY) {
        int cy = (Integer)OverlayConfig.DRIPSTONE_Y.get();
        return cy != 0 ? cy : defaultY;
    }

    public DripstoneFarmWidget(int x, int y, Font font, IShellMenu menu) {
        super(DripstoneFarmWidget.loadPositionX(x), DripstoneFarmWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.widget.dripstone_farm"), font, WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, menu);
        this.width = 168;
        this.height = 110;
        this.isPinned = (Boolean)OverlayConfig.DRIPSTONE_PINNED.get();
        for (int i = 0; i < 5; ++i) {
            this.cachedSourceFluids[i] = FluidStackData.EMPTY;
            this.cachedCauldronMb[i] = 0;
            this.cachedBottomItems[i] = ItemStack.EMPTY;
            this.cachedTargetContainers[i] = 0;
        }
        this.syncFromServerData();
    }

    public void setX(int x) {
        super.setX(x);
        this.savePositionToConfig();
    }

    public void setY(int y) {
        super.setY(y);
        this.savePositionToConfig();
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        try {
            OverlayConfig.DRIPSTONE_PINNED.set((Object)this.isPinned);
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void savePositionToConfig() {
        try {
            OverlayConfig.DRIPSTONE_X.set((Object)this.getX());
            OverlayConfig.DRIPSTONE_Y.set((Object)this.getY());
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void renderLogoIcon(GuiGraphics guiGraphics, int x, int y, int currentWidth, int currentHeight) {
        int iconSize = 16;
        int iconX = x + (currentWidth - iconSize) / 2;
        int iconY = y + (currentHeight - iconSize) / 2;
        try {
            guiGraphics.blit(Theme.icon("drip"), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        }
        catch (Throwable t) {
            this.drawDripstoneIcon(guiGraphics, iconX, iconY, iconSize, iconSize);
        }
    }

    private void drawDripstoneIcon(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int dripstoneColor = -7638187;
        guiGraphics.fill(x + 6, y + 2, x + width - 6, y + height - 2, dripstoneColor);
        guiGraphics.fill(x + 7, y + 1, x + width - 7, y + 3, dripstoneColor);
        guiGraphics.fill(x + 8, y, x + width - 8, y + 2, dripstoneColor);
        int dripColor = -10575134;
        guiGraphics.fill(x + 7, y + height - 4, x + 8, y + height - 2, dripColor);
        guiGraphics.fill(x + 6, y + height - 3, x + 9, y + height - 1, dripColor);
    }

    @Override
    protected String getContextMenuLabel() {
        boolean enabled = (Boolean)OverlayConfig.DRIPSTONE_USE_IMAGE_MODE.get();
        return enabled ? Component.translatable((String)"nomadsshell.ui.disable_image_mode").getString() : Component.translatable((String)"nomadsshell.ui.enable_image_mode").getString();
    }

    @Override
    protected void handleContextMenuAction() {
        boolean enabled = (Boolean)OverlayConfig.DRIPSTONE_USE_IMAGE_MODE.get();
        OverlayConfig.DRIPSTONE_USE_IMAGE_MODE.set((Object)(!enabled ? 1 : 0));
        try {
            OverlayConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void renderExpandedContent(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void renderMainContent(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int i;
        int baseY;
        int baseX;
        int totalH;
        int lh;
        int maxTextW;
        boolean hoveredWidget;
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean imageEnabled = (Boolean)OverlayConfig.DRIPSTONE_USE_IMAGE_MODE.get();
        this.logoMode = imageEnabled && OverlayIdleState.isTimedOut(WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM);
        boolean bl = hoveredWidget = mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
        if (this.logoMode && !hoveredWidget) {
            this.renderLogoIcon(g, x, y + 12, w, h - 12);
            return;
        }
        g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
        g.fill(x, y + 12 - 1, x + w, y + 12, Theme.titleBarBorder());
        int contentX = x + 4;
        int contentY = y + 12 + 1;
        int contentH = h - 12 - 2;
        g.fill(x, contentY, x + w, contentY + contentH, Theme.panelBg());
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        int count = Math.max(0, Math.min(5, this.cachedCauldronCount));
        if (count <= 0) {
            g.drawString(this.font, Component.translatable((String)"nomadsshell.dripstone.unlock_cauldrons").getString(), contentX + 4, contentY + 6, Theme.textOnPanel());
            return;
        }
        int colW = 30;
        int gap = 6;
        int totalW = count * colW + (count - 1) * gap;
        int startX = contentX + (x + w - 4 - contentX - totalW) / 2;
        int topY = contentY + 8;
        int midY = topY + 26;
        int botY = midY + 26;
        for (int i2 = 0; i2 < count; ++i2) {
            boolean hasAutoTransfer;
            int col;
            FluidStackData src;
            int cx;
            block26: {
                cx = startX + i2 * (colW + gap);
                this.drawSlot(g, cx + 6, topY, mouseX, mouseY);
                src = this.cachedSourceFluids[i2];
                if (!src.isEmpty()) {
                    int fluidBarW = 16;
                    int fluidBarH = 3;
                    int fluidBarX = cx + 7;
                    int fluidBarY = topY - 5;
                    int fluidColor = this.isLava(src) ? -1672674 : -10575134;
                    g.fill(fluidBarX, fluidBarY, fluidBarX + fluidBarW, fluidBarY + fluidBarH, fluidColor);
                    g.renderOutline(fluidBarX, fluidBarY, fluidBarW, fluidBarH, Theme.slotBorder());
                    int highlightColor = this.isLava(src) ? -19610 : -8665857;
                    g.fill(fluidBarX + 1, fluidBarY + 1, fluidBarX + fluidBarW - 1, fluidBarY + 2, highlightColor);
                    if (this.inside(fluidBarX, fluidBarY, fluidBarW, fluidBarH, mouseX, mouseY)) {
                        FluidStack display = new FluidStack(src.fluid(), Math.min(src.amount(), 1000));
                        String fluidName = display.getHoverName().getString();
                        this.drawTooltip(g, Component.translatable((String)"nomadsshell.dripstone.tooltip.source", (Object[])new Object[]{fluidName}).getString(), mouseX, mouseY);
                    }
                    int borderColor = this.isLava(src) ? -2132379106 : -2141281566;
                    g.renderOutline(cx + 5, topY - 1, 20, 20, borderColor);
                    try {
                        if (this.isLava(src)) {
                            ResourceLocation lavaTexture = ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"textures/gui/natural/lava.png");
                            g.blit(lavaTexture, cx + 7, topY + 1, 0.0f, 0.0f, 14, 14, 16, 16);
                            break block26;
                        }
                        ResourceLocation waterTexture = ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"textures/gui/natural/water.png");
                        g.blit(waterTexture, cx + 7, topY + 1, 0.0f, 0.0f, 14, 14, 16, 16);
                    }
                    catch (Exception e) {
                        if (this.isLava(src)) {
                            g.renderItem(new ItemStack((ItemLike)Items.LAVA_BUCKET), cx + 7, topY + 1);
                            break block26;
                        }
                        g.renderItem(new ItemStack((ItemLike)Items.WATER_BUCKET), cx + 7, topY + 1);
                    }
                } else {
                    int emptyBarW = 16;
                    int emptyBarH = 2;
                    int emptyBarX = cx + 7;
                    int emptyBarY = topY - 4;
                    g.fill(emptyBarX, emptyBarY, emptyBarX + emptyBarW, emptyBarY + emptyBarH, Theme.slotFill());
                    g.renderOutline(emptyBarX, emptyBarY, emptyBarW, emptyBarH, Theme.slotBorder());
                    if (this.inside(emptyBarX, emptyBarY, emptyBarW, emptyBarH, mouseX, mouseY)) {
                        this.drawTooltip(g, Component.translatable((String)"nomadsshell.dripstone.tooltip.no_source").getString(), mouseX, mouseY);
                    }
                }
            }
            g.renderItem(new ItemStack((ItemLike)Items.POINTED_DRIPSTONE), cx + 6, midY + 2);
            int mb = WidgetDataHelper.getDripCauldronMbAt((Player)player, i2);
            int pW = 18;
            int pH = 4;
            int pX = cx + 6;
            int pY = midY + 20;
            g.fill(pX, pY, pX + pW, pY + pH, Theme.slotFill());
            g.renderOutline(pX, pY, pW, pH, Theme.slotBorder());
            int filled = Math.min(pW - 2, Math.max(0, mb * (pW - 2) / 1000));
            int n = col = !src.isEmpty() && this.isLava(src) ? -1672674 : -10575134;
            if (filled > 0 && !src.isEmpty()) {
                g.fill(pX + 1, pY + 1, pX + 1 + filled, pY + pH - 1, col);
            }
            this.drawSlot(g, cx + 6, botY, mouseX, mouseY);
            ItemStack bottom = WidgetDataHelper.getDripBottomItemAt((Player)player, i2);
            if (!bottom.isEmpty()) {
                g.renderItem(bottom, cx + 6, botY);
            }
            ItemStack shellStack = ShellItem.findWornshell((Player)player);
            int cauldronCount = this.cachedCauldronCount;
            boolean bl2 = hasAutoTransfer = !shellStack.isEmpty() && (Boolean)shellStack.getOrDefault(ModDataComponents.DRIP_AUTO_TRANSFER_ENABLED.get(), (Object)false) != false;
            if (hasAutoTransfer && cauldronCount >= 3) {
                int buttonY = botY + 20;
                int buttonW = 16;
                int buttonH = 12;
                int buttonX = cx + 8;
                int targetContainer = this.cachedTargetContainers[i2];
                boolean isHovered = this.inside(buttonX, buttonY, buttonW, buttonH, mouseX, mouseY);
                int bgColor = Theme.buttonBg(isHovered);
                g.fill(buttonX, buttonY, buttonX + buttonW, buttonY + buttonH, bgColor);
                g.renderOutline(buttonX, buttonY, buttonW, buttonH, Theme.slotBorder());
                String buttonText = targetContainer == 0 ? "X" : String.valueOf(targetContainer);
                int textColor = Theme.textOnPanel();
                int textX = buttonX + (buttonW - this.font.width(buttonText)) / 2;
                Objects.requireNonNull(this.font);
                int textY = buttonY + (buttonH - 9) / 2 + 1;
                g.drawString(this.font, buttonText, textX, textY, textColor, false);
                if (this.inside(buttonX, buttonY, buttonW, buttonH, mouseX, mouseY)) {
                    int[] validTargets = WidgetDataHelper.getValidDripTargetContainers((Player)Minecraft.getInstance().player, i2);
                    Object tooltip = validTargets.length == 1 && validTargets[0] == 0 ? Component.translatable((String)"nomadsshell.dripstone.tooltip.auto_transfer_disabled").getString() : (targetContainer == 0 ? Component.translatable((String)"nomadsshell.dripstone.tooltip.enable_auto_transfer").getString() : Component.translatable((String)"nomadsshell.dripstone.tooltip.auto_transfer_cycle", (Object[])new Object[]{targetContainer}).getString());
                    if (validTargets.length > 1) {
                        ArrayList<String> availableTanks = new ArrayList<String>();
                        for (int j = 1; j < validTargets.length; ++j) {
                            availableTanks.add(String.valueOf(validTargets[j]));
                        }
                        if (!availableTanks.isEmpty()) {
                            tooltip = (String)tooltip + "\nAvailable tanks: " + String.join((CharSequence)", ", availableTanks);
                        }
                    }
                    this.drawTooltip(g, (String)tooltip, mouseX, mouseY);
                }
            }
            if (this.inside(cx + 6, topY, 18, 18, mouseX, mouseY)) {
                String tip;
                if (src.isEmpty()) {
                    tip = Component.translatable((String)"nomadsshell.ui.feed_filled_bucket").getString();
                } else {
                    FluidStack display = new FluidStack(src.fluid(), Math.min(src.amount(), 1000));
                    String fluidName = display.getHoverName().getString();
                    tip = Component.translatable((String)"nomadsshell.dripstone.tooltip.currently_dripping", (Object[])new Object[]{fluidName}).getString();
                }
                this.drawTooltip(g, tip, mouseX, mouseY);
            }
            if (!this.inside(cx + 6, botY, 18, 18, mouseX, mouseY)) continue;
            String tip = !bottom.isEmpty() ? (bottom.is(Items.BUCKET) ? Component.translatable((String)"nomadsshell.dripstone.tooltip.waiting").getString() : Component.translatable((String)"nomadsshell.dripstone.tooltip.ready").getString()) : (mb >= 1000 ? Component.translatable((String)"nomadsshell.dripstone.tooltip.full").getString() : Component.translatable((String)"nomadsshell.dripstone.tooltip.ready_mb", (Object[])new Object[]{mb}).getString());
            this.drawTooltip(g, tip, mouseX, mouseY);
        }
        if (this.pendingForceIndex >= 0) {
            String msg = Component.translatable((String)"nomadsshell.dripstone.confirm.change_source").getString();
            PoseStack pose = g.pose();
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 3000.0f);
            int pad = 4;
            maxTextW = w - pad * 2 - 4;
            List<String> lines = this.wrapToWidth(msg, maxTextW);
            Objects.requireNonNull(this.font);
            lh = 9;
            totalH = lines.size() * lh;
            baseX = x + pad + 2;
            baseY = y + this.height - 2 - totalH;
            for (i = 0; i < lines.size(); ++i) {
                g.drawString(this.font, lines.get(i), baseX, baseY + i * lh, -1, false);
            }
            pose.popPose();
        }
        if (this.pendingTakeSourceIndex >= 0) {
            String msg = Component.translatable((String)"nomadsshell.dripstone.confirm.take_source").getString();
            PoseStack pose = g.pose();
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 3000.0f);
            int pad = 4;
            maxTextW = w - pad * 2 - 4;
            List<String> lines = this.wrapToWidth(msg, maxTextW);
            Objects.requireNonNull(this.font);
            lh = 9;
            totalH = lines.size() * lh;
            baseX = x + pad + 2;
            baseY = y + this.height - 2 - totalH;
            for (i = 0; i < lines.size(); ++i) {
                g.drawString(this.font, lines.get(i), baseX, baseY + i * lh, -1, false);
            }
            pose.popPose();
        }
    }

    @Override
    protected void renderControlButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int currentWidth, int currentHeight) {
        int buttonColor;
        int x = this.getX();
        int y = this.getY();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 500.0f);
        int toggleX = x + currentWidth - 16 - 4;
        int toggleY = y + 2;
        boolean toggleHovered = mouseX >= toggleX && mouseX <= toggleX + 8 && mouseY >= toggleY && mouseY <= toggleY + 8;
        boolean enabled = (Boolean)OverlayConfig.DRIPSTONE_FARM_ENABLED.get();
        int n = buttonColor = enabled ? -11751600 : -769226;
        if (toggleHovered) {
            buttonColor = enabled ? -10044566 : -38037;
        }
        guiGraphics.fill(toggleX, toggleY, toggleX + 8, toggleY + 8, buttonColor);
        int pinX = x + currentWidth - 8 - 2;
        int pinY = y + 2;
        boolean pinHovered = mouseX >= pinX && mouseX <= pinX + 8 && mouseY >= pinY && mouseY <= pinY + 8;
        guiGraphics.fill(pinX, pinY, pinX + 8, pinY + 8, Theme.buttonBg(pinHovered));
        if (this.isPinned) {
            int c = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 6, c);
            guiGraphics.fill(pinX + 2, pinY + 2, pinX + 6, pinY + 3, c);
        } else {
            int c = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 2, c);
            guiGraphics.fill(pinX + 3, pinY + 5, pinX + 5, pinY + 6, c);
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 3, pinY + 6, c);
            guiGraphics.fill(pinX + 5, pinY + 2, pinX + 5, pinY + 6, c);
        }
        guiGraphics.pose().popPose();
    }

    private void renderCauldrons(GuiGraphics g, int contentX, int contentY, int contentH, ItemStack shellStack, int cauldronCount, boolean autoPusherEnabled) {
        int maxColumns = Math.min(5, cauldronCount);
        if (maxColumns == 0) {
            return;
        }
        int slotSize = 18;
        int spacing = 2;
        int totalWidth = maxColumns * slotSize + (maxColumns - 1) * spacing;
        int startX = contentX + (168 - totalWidth) / 2;
        int startY = contentY + (contentH - slotSize) / 2;
        for (int i = 0; i < maxColumns; ++i) {
            int progressHeight;
            int fluidHeight;
            int slotX = startX + i * (slotSize + spacing);
            int slotY = startY;
            g.fill(slotX, slotY, slotX + slotSize, slotY + slotSize, -13816531);
            g.fill(slotX - 1, slotY - 1, slotX + slotSize + 1, slotY + slotSize + 1, Theme.slotBorder());
            FluidStackData fluid = this.getCauldronFluid(shellStack, i);
            int capacity = this.getCauldronCapacity(shellStack, i);
            int progress = this.getCauldronProgress(shellStack, i);
            PoseStack pose = g.pose();
            pose.pushPose();
            pose.translate((float)(slotX + 1), (float)(slotY + 1), 0.0f);
            pose.scale(1.0f, 1.0f, 1.0f);
            g.renderItem(new ItemStack((ItemLike)Items.CAULDRON), 0, 0);
            pose.popPose();
            if (!fluid.isEmpty() && capacity > 0 && (fluidHeight = (int)((float)fluid.amount() / (float)capacity * (float)(slotSize - 2))) > 0) {
                int fluidColor = -10575134;
                g.fill(slotX + 1, slotY + slotSize - 1 - fluidHeight, slotX + slotSize - 1, slotY + slotSize - 1, fluidColor);
            }
            if (progress <= 0 || (progressHeight = (int)((float)progress / 100.0f * (float)(slotSize - 2))) <= 0) continue;
            g.fill(slotX + 1, slotY + 1, slotX + slotSize - 1, slotY + 1 + progressHeight, -2130706433);
        }
        if (autoPusherEnabled) {
            int indicatorX = startX + totalWidth + 4;
            int indicatorY = startY + (slotSize - 8) / 2;
            g.fill(indicatorX, indicatorY, indicatorX + 8, indicatorY + 8, -16711936);
            g.drawString(this.font, "A", indicatorX + 2, indicatorY + 1, -1);
        }
    }

    private FluidStackData getCauldronFluid(ItemStack shellStack, int cauldronIndex) {
        return switch (cauldronIndex) {
            case 0 -> (FluidStackData)shellStack.getOrDefault(ModDataComponents.DRIP_SOURCE_FLUID_0.get(), (Object)FluidStackData.EMPTY);
            case 1 -> (FluidStackData)shellStack.getOrDefault(ModDataComponents.DRIP_SOURCE_FLUID_1.get(), (Object)FluidStackData.EMPTY);
            case 2 -> (FluidStackData)shellStack.getOrDefault(ModDataComponents.DRIP_SOURCE_FLUID_2.get(), (Object)FluidStackData.EMPTY);
            case 3 -> (FluidStackData)shellStack.getOrDefault(ModDataComponents.DRIP_SOURCE_FLUID_3.get(), (Object)FluidStackData.EMPTY);
            case 4 -> (FluidStackData)shellStack.getOrDefault(ModDataComponents.DRIP_SOURCE_FLUID_4.get(), (Object)FluidStackData.EMPTY);
            default -> FluidStackData.EMPTY;
        };
    }

    private int getCauldronCapacity(ItemStack shellStack, int cauldronIndex) {
        return switch (cauldronIndex) {
            case 0 -> (Integer)shellStack.getOrDefault(ModDataComponents.DRIP_CAULDRON_MB_0.get(), (Object)0);
            case 1 -> (Integer)shellStack.getOrDefault(ModDataComponents.DRIP_CAULDRON_MB_1.get(), (Object)0);
            case 2 -> (Integer)shellStack.getOrDefault(ModDataComponents.DRIP_CAULDRON_MB_2.get(), (Object)0);
            case 3 -> (Integer)shellStack.getOrDefault(ModDataComponents.DRIP_CAULDRON_MB_3.get(), (Object)0);
            case 4 -> (Integer)shellStack.getOrDefault(ModDataComponents.DRIP_CAULDRON_MB_4.get(), (Object)0);
            default -> 0;
        };
    }

    private int getCauldronProgress(ItemStack shellStack, int cauldronIndex) {
        return switch (cauldronIndex) {
            case 0 -> (Integer)shellStack.getOrDefault(ModDataComponents.DRIP_PROGRESS_0.get(), (Object)0);
            case 1 -> (Integer)shellStack.getOrDefault(ModDataComponents.DRIP_PROGRESS_1.get(), (Object)0);
            case 2 -> (Integer)shellStack.getOrDefault(ModDataComponents.DRIP_PROGRESS_2.get(), (Object)0);
            case 3 -> (Integer)shellStack.getOrDefault(ModDataComponents.DRIP_PROGRESS_3.get(), (Object)0);
            case 4 -> (Integer)shellStack.getOrDefault(ModDataComponents.DRIP_PROGRESS_4.get(), (Object)0);
            default -> 0;
        };
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int topYc;
        int gapc;
        int colWc;
        int totalWc;
        int contentWc;
        int startXc;
        int cxc;
        int countConf;
        int contentY;
        int idx;
        boolean inside;
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        if (!inside) {
            return false;
        }
        OverlayIdleState.recordInteraction(WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM);
        this.logoMode = false;
        int dripstoneX = x + w - 16 - 4;
        int dripstoneY = y + 2;
        if (mouseX >= (double)dripstoneX && mouseX <= (double)(dripstoneX + 8) && mouseY >= (double)dripstoneY && mouseY <= (double)(dripstoneY + 8)) {
            boolean currentState = (Boolean)OverlayConfig.DRIPSTONE_FARM_ENABLED.get();
            OverlayConfig.DRIPSTONE_FARM_ENABLED.set((Object)(!currentState ? 1 : 0));
            try {
                OverlayConfig.SPEC.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        if (this.pendingForceIndex >= 0) {
            idx = this.pendingForceIndex;
            contentY = y + 12 + 1;
            if (this.inside(x, y, w, 12, (int)mouseX, (int)mouseY)) {
                this.pendingForceIndex = -1;
                return true;
            }
            countConf = Math.max(0, Math.min(5, this.cachedCauldronCount));
            if (countConf > 0 && this.inside((cxc = (startXc = x + 4 + ((contentWc = this.width - 8) - (totalWc = countConf * (colWc = 30) + (countConf - 1) * (gapc = 6))) / 2) + idx * (colWc + gapc)) + 6, topYc = contentY + 6, 18, 18, (int)mouseX, (int)mouseY)) {
                FluidStack fs;
                Optional opt;
                ItemStack carried;
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null && !(carried = player.containerMenu.getCarried()).isEmpty() && (opt = FluidUtil.getFluidContained((ItemStack)carried)).isPresent() && (fs = (FluidStack)opt.get()).getAmount() >= 1000) {
                    this.cachedSourceFluids[idx] = new FluidStackData(fs.getFluid(), fs.getAmount());
                    this.waitingForSync[idx] = true;
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new DripstoneFarmActionPacket(DripstoneFarmActionPacket.Action.FEED_SOURCE_BUCKET_FORCE, idx), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.pendingForceIndex = -1;
                return true;
            }
            if (this.inside(x, contentY, w, this.height - (contentY - y), (int)mouseX, (int)mouseY)) {
                return true;
            }
        }
        if (this.pendingTakeSourceIndex >= 0) {
            idx = this.pendingTakeSourceIndex;
            contentY = y + 12 + 1;
            if (this.inside(x, y, w, 12, (int)mouseX, (int)mouseY)) {
                this.pendingTakeSourceIndex = -1;
                return true;
            }
            countConf = Math.max(0, Math.min(5, this.cachedCauldronCount));
            if (countConf > 0 && this.inside((cxc = (startXc = x + 4 + ((contentWc = this.width - 8) - (totalWc = countConf * (colWc = 30) + (countConf - 1) * (gapc = 6))) / 2) + idx * (colWc + gapc)) + 6, topYc = contentY + 6, 18, 18, (int)mouseX, (int)mouseY)) {
                this.cachedSourceFluids[idx] = FluidStackData.EMPTY;
                this.waitingForSync[idx] = true;
                PacketDistributor.sendToServer((CustomPacketPayload)new DripstoneFarmActionPacket(DripstoneFarmActionPacket.Action.TAKE_SOURCE_BUCKET, idx), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.pendingTakeSourceIndex = -1;
                return true;
            }
            if (this.inside(x, contentY, w, this.height - (contentY - y), (int)mouseX, (int)mouseY)) {
                return true;
            }
        }
        if (!this.isUnlocked()) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        int contentY2 = y + 12 + 1;
        int contentW = this.width - 8;
        int count = Math.max(0, Math.min(5, this.cachedCauldronCount));
        if (count > 0) {
            int colW = 30;
            int gap = 6;
            int totalW = count * colW + (count - 1) * gap;
            int startX = x + 4 + (contentW - totalW) / 2;
            int topY = contentY2 + 6;
            int botY = topY + 26 + 26;
            for (int i = 0; i < count; ++i) {
                int buttonH;
                int buttonW;
                int buttonY;
                int buttonX;
                boolean hasAutoTransfer;
                ItemStack carried;
                LocalPlayer player;
                int cx = startX + i * (colW + gap);
                if (this.inside(cx + 6, topY, 18, 18, (int)mouseX, (int)mouseY)) {
                    FluidStackData src;
                    player = Minecraft.getInstance().player;
                    if (player == null) {
                        return true;
                    }
                    carried = player.containerMenu.getCarried();
                    if (!carried.isEmpty()) {
                        FluidStackData src2 = this.cachedSourceFluids[i];
                        if (src2.isEmpty()) {
                            FluidStack fs;
                            Optional opt = FluidUtil.getFluidContained((ItemStack)carried);
                            if (opt.isPresent() && (fs = (FluidStack)opt.get()).getAmount() >= 1000) {
                                this.cachedSourceFluids[i] = new FluidStackData(fs.getFluid(), fs.getAmount());
                                this.waitingForSync[i] = true;
                            }
                            PacketDistributor.sendToServer((CustomPacketPayload)new DripstoneFarmActionPacket(DripstoneFarmActionPacket.Action.FEED_SOURCE_BUCKET, i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        } else {
                            FluidStack fs;
                            Optional opt = FluidUtil.getFluidContained((ItemStack)carried);
                            if (opt.isPresent() && (fs = (FluidStack)opt.get()).getAmount() >= 1000 && src2.fluid() != fs.getFluid()) {
                                this.openConfirmChangeFluid(i);
                            }
                        }
                    }
                    if (!carried.isEmpty() && carried.is(Items.BUCKET) && !(src = this.cachedSourceFluids[i]).isEmpty()) {
                        this.openConfirmTakeSource(i);
                    }
                    return true;
                }
                if (this.inside(cx + 6, botY, 18, 18, (int)mouseX, (int)mouseY)) {
                    player = Minecraft.getInstance().player;
                    if (player == null) {
                        return true;
                    }
                    carried = player.containerMenu.getCarried();
                    if (!carried.isEmpty() && carried.is(Items.BUCKET) && WidgetDataHelper.getDripBottomItemAt((Player)player, i).isEmpty()) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new DripstoneFarmActionPacket(DripstoneFarmActionPacket.Action.PLACE_BOTTOM_BUCKET, i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        return true;
                    }
                    if (!WidgetDataHelper.getDripBottomItemAt((Player)player, i).isEmpty()) {
                        int mb = WidgetDataHelper.getDripCauldronMbAt((Player)player, i);
                        if (mb >= 1000 && !this.cachedSourceFluids[i].isEmpty()) {
                            PacketDistributor.sendToServer((CustomPacketPayload)new DripstoneFarmActionPacket(DripstoneFarmActionPacket.Action.COLLECT_OUTPUT_BUCKET, i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        } else {
                            PacketDistributor.sendToServer((CustomPacketPayload)new DripstoneFarmActionPacket(DripstoneFarmActionPacket.Action.TAKE_BOTTOM_ITEM, i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                        return true;
                    }
                    return true;
                }
                player = Minecraft.getInstance().player;
                if (player == null) continue;
                ItemStack shellStack = ShellItem.findWornshell((Player)player);
                int cauldronCount = WidgetDataHelper.getDripCauldronCount((Player)player);
                boolean bl2 = hasAutoTransfer = !shellStack.isEmpty() && (Boolean)shellStack.getOrDefault(ModDataComponents.DRIP_AUTO_TRANSFER_ENABLED.get(), (Object)false) != false;
                if (!hasAutoTransfer || cauldronCount < 3 || !this.inside(buttonX = cx + 8, buttonY = botY + 20, buttonW = 16, buttonH = 12, (int)mouseX, (int)mouseY)) continue;
                int[] validTargets = WidgetDataHelper.getValidDripTargetContainers((Player)Minecraft.getInstance().player, i);
                if (validTargets.length > 0) {
                    int currentIndex = -1;
                    for (int j = 0; j < validTargets.length; ++j) {
                        if (validTargets[j] != this.cachedTargetContainers[i]) continue;
                        currentIndex = j;
                        break;
                    }
                    int nextIndex = (currentIndex + 1) % validTargets.length;
                    this.cachedTargetContainers[i] = validTargets[nextIndex];
                    this.waitingForSync[i] = true;
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new DripstoneFarmActionPacket(DripstoneFarmActionPacket.Action.CYCLE_TARGET_CONTAINER, i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            if (this.isDragging && button == 0) {
                return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        if (mouseY >= (double)y && mouseY <= (double)(y + 12) && mouseX >= (double)x && mouseX <= (double)(x + w)) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
            if (this.isDragging && button == 0) {
                return super.mouseReleased(mouseX, mouseY, button);
            }
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    protected void updateWidgetNarration(NarrationElementOutput output) {
        output.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"nomadsshell.widget.dripstone_farm"));
    }

    public void tick() {
        if (!this.isUnlocked()) {
            return;
        }
        this.syncFromshellData();
    }

    private void syncFromshellData() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        this.cachedCauldronCount = WidgetDataHelper.getDripCauldronCount((Player)mc.player);
        for (int i = 0; i < 5; ++i) {
            FluidStackData serverFluid = WidgetDataHelper.getDripSourceFluidAt((Player)mc.player, i);
            int serverMb = WidgetDataHelper.getDripCauldronMbAt((Player)mc.player, i);
            ItemStack serverBottom = WidgetDataHelper.getDripBottomItemAt((Player)mc.player, i);
            int serverTargetContainer = WidgetDataHelper.getDripTargetContainerAt((Player)mc.player, i);
            if (this.waitingForSync[i]) {
                boolean matches = true;
                if (!this.cachedSourceFluids[i].equals(serverFluid)) {
                    matches = false;
                }
                if (this.cachedTargetContainers[i] != serverTargetContainer) {
                    matches = false;
                }
                if (!ItemStack.matches((ItemStack)this.cachedBottomItems[i], (ItemStack)serverBottom)) {
                    matches = false;
                }
                if (matches) {
                    this.waitingForSync[i] = false;
                }
                this.cachedCauldronMb[i] = serverMb;
                continue;
            }
            if (!this.cachedSourceFluids[i].equals(serverFluid)) {
                this.cachedSourceFluids[i] = serverFluid;
            }
            this.cachedCauldronMb[i] = serverMb;
            if (!ItemStack.matches((ItemStack)this.cachedBottomItems[i], (ItemStack)serverBottom)) {
                this.cachedBottomItems[i] = serverBottom.copy();
            }
            this.cachedTargetContainers[i] = serverTargetContainer;
        }
    }

    private void syncFromServerData() {
        this.syncFromshellData();
    }

    private void drawSlot(GuiGraphics g, int x, int y, int mouseX, int mouseY) {
        g.fill(x, y, x + 18, y + 18, Theme.slotFill());
        g.renderOutline(x, y, 18, 18, Theme.slotBorder());
    }

    private boolean inside(int x, int y, int w, int h, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
    }

    private boolean isLava(FluidStackData fluid) {
        return fluid.fluid() == Fluids.LAVA;
    }

    private void drawTooltip(GuiGraphics g, String text, int mouseX, int mouseY) {
        g.renderTooltip(this.font, (Component)Component.literal((String)text), mouseX, mouseY);
    }

    private List<String> wrapToWidth(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            if (this.font.width(testLine) <= maxWidth) {
                currentLine = new StringBuilder(testLine);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private void openConfirmChangeFluid(int cauldronIndex) {
        this.pendingForceIndex = cauldronIndex;
    }

    private void openConfirmTakeSource(int cauldronIndex) {
        this.pendingTakeSourceIndex = cauldronIndex;
    }
}

