/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.VirtualShellScreen;
import com.etka.nomadsshell.client.screen.overlay.AnvilWidget;
import com.etka.nomadsshell.client.screen.overlay.CollectorWidget;
import com.etka.nomadsshell.client.screen.overlay.CompassWidget;
import com.etka.nomadsshell.client.screen.overlay.CraftingTableWidget;
import com.etka.nomadsshell.client.screen.overlay.DripstoneFarmWidget;
import com.etka.nomadsshell.client.screen.overlay.FluidTankWidget;
import com.etka.nomadsshell.client.screen.overlay.FurnaceWidget;
import com.etka.nomadsshell.client.screen.overlay.MagnetWidget;
import com.etka.nomadsshell.client.screen.overlay.OverlayWidget;
import com.etka.nomadsshell.client.screen.overlay.SettingsWidget;
import com.etka.nomadsshell.client.screen.overlay.TrashBinWidget;
import com.etka.nomadsshell.client.screen.overlay.TravelersGardenWidget;
import com.etka.nomadsshell.client.screen.overlay.UpgradeWidget;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.overlay.autofeeder.AutoFeederWidget;
import com.etka.nomadsshell.menu.IShellMenu;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;

public class OverlayManager {
    private final List<OverlayWidget> overlays = new ArrayList<OverlayWidget>();
    private final Screen parentScreen;
    private final Font font;
    private final IShellMenu menu;
    private int baseX;
    private int baseY;
    private int mainGuiWidth;
    private int mainGuiHeight;
    private boolean memorizeModeActive = false;

    public OverlayManager(Screen parentScreen, Font font, IShellMenu menu) {
        this.parentScreen = parentScreen;
        this.font = font;
        this.menu = menu;
        this.baseX = -1;
        this.baseY = -1;
    }

    public void setMemorizeMode(boolean active) {
        this.memorizeModeActive = active;
    }

    public boolean isMemorizeModeActive() {
        return this.memorizeModeActive;
    }

    public void clearMemorizeMode() {
        this.memorizeModeActive = false;
    }

    public void updateMainGuiBounds(int x, int y, int width, int height) {
        int offsetX = x - this.baseX;
        int offsetY = y - this.baseY;
        if (this.baseX != -1 && this.baseY != -1 && (this.baseX != x || this.baseY != y)) {
            for (OverlayWidget overlay : this.overlays) {
                if (overlay.isPinned()) continue;
                int currentX = overlay.getX();
                int currentY = overlay.getY();
                overlay.forceUpdatePosition(currentX + offsetX, currentY + offsetY);
            }
        }
        this.baseX = x;
        this.baseY = y;
        this.mainGuiWidth = width;
        this.mainGuiHeight = height;
        this.updateDefaultPositions();
    }

    private void updateDefaultPositions() {
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc != null && mc.getWindow() != null ? mc.getWindow().getGuiScaledWidth() : 1920;
        int screenHeight = mc != null && mc.getWindow() != null ? mc.getWindow().getGuiScaledHeight() : 1080;
        int spacing = this.calculateOptimalSpacing(screenWidth);
        int startY = this.calculateOptimalStartY(screenHeight);
        int currentX = this.baseX;
        int currentY = startY;
        for (OverlayWidget overlay : this.overlays) {
            if (!overlay.isPinned()) {
                overlay.setDefaultPosition(currentX, currentY);
                if ((currentX += overlay.getWidth() + spacing) + overlay.getWidth() <= screenWidth - 20) continue;
                currentX = this.baseX;
                currentY += overlay.getHeight() + spacing;
                continue;
            }
            if ((currentX += overlay.getWidth() + spacing) + overlay.getWidth() <= screenWidth - 20) continue;
            currentX = this.baseX;
            currentY += overlay.getHeight() + spacing;
        }
    }

    private int calculateOptimalSpacing(int screenWidth) {
        if (screenWidth < 800) {
            return 2;
        }
        if (screenWidth < 1200) {
            return 3;
        }
        return 5;
    }

    private int calculateOptimalStartY(int screenHeight) {
        if (screenHeight < 600) {
            return Math.max(10, this.baseY - 30);
        }
        if (screenHeight < 800) {
            return Math.max(20, this.baseY - 40);
        }
        return this.baseY - 45;
    }

    public void addOverlay(OverlayWidget overlay) {
        if (!this.overlays.contains((Object)overlay)) {
            this.overlays.add(overlay);
            this.enforceWidgetOrder();
            this.updateDefaultPositions();
        }
    }

    public void removeOverlay(OverlayWidget overlay) {
        if (this.overlays.remove((Object)overlay)) {
            this.enforceWidgetOrder();
            this.updateDefaultPositions();
        }
    }

    public void removeTrashBin() {
        TrashBinWidget tb = this.getTrashBin();
        if (tb != null) {
            this.removeOverlay(tb);
        }
    }

    public void removeFurnace() {
        FurnaceWidget fw = this.getFurnace();
        if (fw != null) {
            this.removeOverlay(fw);
        }
    }

    public void removeCraftingTable() {
        CraftingTableWidget ctw = this.getCraftingTable();
        if (ctw != null) {
            this.removeOverlay(ctw);
        }
    }

    private void enforceWidgetOrder() {
        if (this.menu == null) {
            return;
        }
        ItemStack stack = this.menu.getshellStack();
        List<WidgetUnlockSystem.WidgetType> order = WidgetUnlockSystem.getUnlockOrder(stack);
        this.overlays.sort((a, b) -> {
            int cb;
            int ca = this.categoryRank((OverlayWidget)((Object)a));
            if (ca != (cb = this.categoryRank((OverlayWidget)((Object)b)))) {
                return Integer.compare(ca, cb);
            }
            int ia = this.unlockIndex((OverlayWidget)((Object)a), order);
            int ib = this.unlockIndex((OverlayWidget)((Object)b), order);
            return Integer.compare(ia, ib);
        });
    }

    private int categoryRank(OverlayWidget ow) {
        if (ow instanceof SettingsWidget) {
            return 0;
        }
        if (ow instanceof UpgradeWidget) {
            return 1;
        }
        return 2;
    }

    private int unlockIndex(OverlayWidget ow, List<WidgetUnlockSystem.WidgetType> order) {
        WidgetUnlockSystem.WidgetType type = null;
        if (ow instanceof TrashBinWidget) {
            type = WidgetUnlockSystem.WidgetType.TRASH_BIN;
        } else if (ow instanceof FurnaceWidget) {
            type = WidgetUnlockSystem.WidgetType.FURNACE;
        } else if (ow instanceof CraftingTableWidget) {
            type = WidgetUnlockSystem.WidgetType.CRAFTING_TABLE;
        } else if (ow instanceof FluidTankWidget) {
            type = WidgetUnlockSystem.WidgetType.FLUID_TANK;
        } else if (ow instanceof DripstoneFarmWidget) {
            type = WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM;
        } else if (ow instanceof TravelersGardenWidget) {
            type = WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN;
        } else if (ow instanceof AnvilWidget) {
            type = WidgetUnlockSystem.WidgetType.ANVIL;
        } else if (((Object)((Object)ow)).getClass().getName().equals("com.etka.nomadsshell.client.screen.overlay.TeleportWidget")) {
            type = WidgetUnlockSystem.WidgetType.TELEPORTER;
        } else if (((Object)((Object)ow)).getClass().getName().equals("com.etka.nomadsshell.client.screen.overlay.autofeeder.AutoFeederWidget")) {
            type = WidgetUnlockSystem.WidgetType.AUTO_FEEDER;
        }
        if (type == null) {
            return 0x7FFFFFFE;
        }
        int idx = order.indexOf((Object)type);
        return idx >= 0 ? idx : Integer.MAX_VALUE;
    }

    public void tick() {
        for (OverlayWidget overlay : this.overlays) {
            if (overlay instanceof TrashBinWidget) {
                TrashBinWidget trashBin = (TrashBinWidget)overlay;
                trashBin.tick();
                continue;
            }
            if (overlay instanceof FurnaceWidget) {
                FurnaceWidget furnace = (FurnaceWidget)overlay;
                furnace.tick();
                continue;
            }
            if (overlay instanceof CraftingTableWidget) {
                CraftingTableWidget craftingTable = (CraftingTableWidget)overlay;
                craftingTable.tick();
                continue;
            }
            if (overlay instanceof FluidTankWidget) {
                FluidTankWidget fluidTank = (FluidTankWidget)overlay;
                fluidTank.tick();
                continue;
            }
            if (overlay instanceof DripstoneFarmWidget) {
                DripstoneFarmWidget df = (DripstoneFarmWidget)overlay;
                df.tick();
                continue;
            }
            if (overlay instanceof TravelersGardenWidget) {
                TravelersGardenWidget tg = (TravelersGardenWidget)overlay;
                continue;
            }
            if (overlay instanceof AnvilWidget) {
                AnvilWidget anvil = (AnvilWidget)overlay;
                anvil.tick();
                continue;
            }
            if (!((Object)((Object)overlay)).getClass().getName().equals("com.etka.nomadsshell.client.screen.overlay.guardian.GuardianWidget") && !((Object)((Object)overlay)).getClass().getName().equals("com.etka.nomadsshell.client.screen.overlay.autofeeder.AutoFeederWidget")) continue;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean upgradeOnTop;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, 1000.0);
        UpgradeWidget upgrade = this.getUpgrade();
        boolean bl = upgradeOnTop = upgrade != null && upgrade.isFullscreenOpen();
        if (!upgradeOnTop) {
            for (OverlayWidget overlay : this.overlays) {
                if (!overlay.visible) continue;
                overlay.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        } else if (upgrade.visible) {
            upgrade.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        poseStack.popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        UpgradeWidget upgrade = this.getUpgrade();
        if (upgrade != null && upgrade.visible && upgrade.isFullscreenOpen()) {
            return upgrade.mouseClicked(mouseX, mouseY, button);
        }
        for (int i = this.overlays.size() - 1; i >= 0; --i) {
            OverlayWidget overlay = this.overlays.get(i);
            if (!overlay.visible || !overlay.mouseClicked(mouseX, mouseY, button)) continue;
            this.overlays.remove(i);
            this.overlays.add(overlay);
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        UpgradeWidget upgrade = this.getUpgrade();
        if (upgrade != null && upgrade.visible && upgrade.isFullscreenOpen()) {
            return upgrade.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        for (OverlayWidget overlay : this.overlays) {
            if (!overlay.visible || !overlay.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        UpgradeWidget upgrade = this.getUpgrade();
        if (upgrade != null && upgrade.visible && upgrade.isFullscreenOpen()) {
            return upgrade.mouseReleased(mouseX, mouseY, button);
        }
        for (OverlayWidget overlay : this.overlays) {
            if (!overlay.visible || !overlay.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        UpgradeWidget upgrade = this.getUpgrade();
        if (upgrade != null && upgrade.visible && upgrade.isFullscreenOpen()) {
            return upgrade.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        for (OverlayWidget overlay : this.overlays) {
            if (!overlay.visible || !overlay.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        UpgradeWidget upgrade = this.getUpgrade();
        if (upgrade != null && upgrade.visible && upgrade.isFullscreenOpen()) {
            return upgrade.keyPressed(keyCode, scanCode, modifiers);
        }
        for (OverlayWidget overlay : this.overlays) {
            if (!overlay.visible || !overlay.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        UpgradeWidget upgrade = this.getUpgrade();
        if (upgrade != null && upgrade.visible && upgrade.isFullscreenOpen()) {
            return upgrade.charTyped(codePoint, modifiers);
        }
        for (OverlayWidget overlay : this.overlays) {
            if (!overlay.visible || !overlay.charTyped(codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    public void updateHoverStates(double mouseX, double mouseY) {
        for (OverlayWidget overlay : this.overlays) {
            if (!overlay.visible) continue;
            boolean wasHovered = overlay.isHovered();
            boolean isHovered = overlay.isMouseOver(mouseX, mouseY);
            if (overlay instanceof TrashBinWidget) {
                TrashBinWidget trashBin = (TrashBinWidget)overlay;
                trashBin.onHoverStateChanged(isHovered);
            }
            if (wasHovered == isHovered) continue;
            overlay.onHoverStateChanged(isHovered);
        }
    }

    public TrashBinWidget getTrashBin() {
        return this.overlays.stream().filter(TrashBinWidget.class::isInstance).map(TrashBinWidget.class::cast).findFirst().orElse(null);
    }

    public FurnaceWidget getFurnace() {
        return this.overlays.stream().filter(FurnaceWidget.class::isInstance).map(FurnaceWidget.class::cast).findFirst().orElse(null);
    }

    public CraftingTableWidget getCraftingTable() {
        return this.overlays.stream().filter(CraftingTableWidget.class::isInstance).map(CraftingTableWidget.class::cast).findFirst().orElse(null);
    }

    public FluidTankWidget getFluidTank() {
        return this.overlays.stream().filter(FluidTankWidget.class::isInstance).map(FluidTankWidget.class::cast).findFirst().orElse(null);
    }

    public DripstoneFarmWidget getDripstoneFarm() {
        return this.overlays.stream().filter(DripstoneFarmWidget.class::isInstance).map(DripstoneFarmWidget.class::cast).findFirst().orElse(null);
    }

    public TravelersGardenWidget getTravelersGarden() {
        return this.overlays.stream().filter(TravelersGardenWidget.class::isInstance).map(TravelersGardenWidget.class::cast).findFirst().orElse(null);
    }

    public SettingsWidget getSettings() {
        return this.overlays.stream().filter(SettingsWidget.class::isInstance).map(SettingsWidget.class::cast).findFirst().orElse(null);
    }

    public UpgradeWidget getUpgrade() {
        return this.overlays.stream().filter(UpgradeWidget.class::isInstance).map(UpgradeWidget.class::cast).findFirst().orElse(null);
    }

    public List<OverlayWidget> getOverlays() {
        return new ArrayList<OverlayWidget>(this.overlays);
    }

    public void resetAllPositions() {
        for (OverlayWidget overlay : this.overlays) {
            if (overlay.isPinned()) continue;
            overlay.resetPosition();
        }
    }

    public void setAllVisible(boolean visible) {
        for (OverlayWidget overlay : this.overlays) {
            overlay.visible = visible;
        }
    }

    public void resetUnpinnedWidgets() {
        for (OverlayWidget overlay : this.overlays) {
            if (overlay.isPinned()) continue;
            overlay.resetPosition();
        }
    }

    public TrashBinWidget createTrashBin() {
        TrashBinWidget trashBin = new TrashBinWidget(0, 0, this.font, this.menu);
        this.addOverlay(trashBin);
        return trashBin;
    }

    public FurnaceWidget createFurnace() {
        FurnaceWidget furnace = new FurnaceWidget(0, 0, this.font, this.menu);
        this.addOverlay(furnace);
        return furnace;
    }

    public CraftingTableWidget createCraftingTable() {
        CraftingTableWidget craftingTable = new CraftingTableWidget(0, 0, this.font, this.menu);
        this.addOverlay(craftingTable);
        return craftingTable;
    }

    public FluidTankWidget createFluidTank() {
        FluidTankWidget w = new FluidTankWidget(0, 0, this.font, this.menu);
        this.addOverlay(w);
        return w;
    }

    public DripstoneFarmWidget createDripstoneFarm() {
        DripstoneFarmWidget w = new DripstoneFarmWidget(0, 0, this.font, this.menu);
        this.addOverlay(w);
        return w;
    }

    public SettingsWidget createSettings() {
        SettingsWidget settings = new SettingsWidget(0, 0, this.font, this.menu, this);
        this.addOverlay(settings);
        return settings;
    }

    public UpgradeWidget createUpgrade() {
        UpgradeWidget upgrade = new UpgradeWidget(0, 0, this.font, this.menu);
        this.addOverlay(upgrade);
        return upgrade;
    }

    public CollectorWidget createCollector() {
        CollectorWidget collector = new CollectorWidget(0, 0, this.font, this.menu);
        this.addOverlay(collector);
        return collector;
    }

    public MagnetWidget createMagnet() {
        MagnetWidget magnet = new MagnetWidget(0, 0, this.font, this.menu);
        this.addOverlay(magnet);
        return magnet;
    }

    public CompassWidget createCompass() {
        CompassWidget compass = new CompassWidget(0, 0, this.font, this.menu);
        this.addOverlay(compass);
        return compass;
    }

    public OverlayWidget createTeleporter() {
        try {
            Class<?> cls = Class.forName("com.etka.nomadsshell.client.screen.overlay.TeleportWidget");
            Constructor<?> ctor = cls.getConstructor(Integer.TYPE, Integer.TYPE, Font.class, IShellMenu.class);
            Object widget = ctor.newInstance(0, 0, this.font, this.menu);
            if (widget instanceof OverlayWidget) {
                OverlayWidget ow = (OverlayWidget)((Object)widget);
                this.addOverlay(ow);
                return ow;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Object createGuardian() {
        try {
            Class<?> cls = Class.forName("com.etka.nomadsshell.client.screen.overlay.guardian.GuardianWidget");
            Constructor<?> ctor = cls.getConstructor(Integer.TYPE, Integer.TYPE, Font.class, IShellMenu.class);
            int guardianX = this.baseX + this.mainGuiWidth + 10;
            int guardianY = this.baseY - 45;
            Object widget = ctor.newInstance(guardianX, guardianY, this.font, this.menu);
            if (widget instanceof OverlayWidget) {
                OverlayWidget ow = (OverlayWidget)((Object)widget);
                this.addOverlay(ow);
            }
            return widget;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public TravelersGardenWidget createTravelersGarden() {
        try {
            if (!ModList.get().isLoaded("travelersgarden")) {
                return null;
            }
        }
        catch (Throwable t) {
            return null;
        }
        TravelersGardenWidget w = new TravelersGardenWidget(0, 0, this.font, this.menu);
        this.addOverlay(w);
        return w;
    }

    public AnvilWidget createAnvil() {
        AnvilWidget anvil = new AnvilWidget(0, 0, this.font, this.menu);
        this.addOverlay(anvil);
        return anvil;
    }

    public AutoFeederWidget createAutoFeeder() {
        AutoFeederWidget autoFeeder = new AutoFeederWidget(0, 0, this.font, this.menu);
        this.addOverlay(autoFeeder);
        return autoFeeder;
    }

    public boolean adjustHeight(int delta) {
        for (OverlayWidget overlay : this.overlays) {
            if (!(overlay instanceof SettingsWidget)) continue;
            SettingsWidget settingsWidget = (SettingsWidget)overlay;
            return settingsWidget.adjustHeight(delta);
        }
        return false;
    }

    public boolean adjustWidth(int delta) {
        for (OverlayWidget overlay : this.overlays) {
            if (!(overlay instanceof SettingsWidget)) continue;
            SettingsWidget settingsWidget = (SettingsWidget)overlay;
            return settingsWidget.adjustWidth(delta);
        }
        return false;
    }

    public void triggerScreenRecalculation() {
        Screen screen = this.parentScreen;
        if (screen instanceof VirtualShellScreen) {
            VirtualShellScreen virtualScreen = (VirtualShellScreen)screen;
            virtualScreen.refreshDimensions();
        }
    }

    public int[] getCachedDimensions() {
        for (OverlayWidget overlay : this.overlays) {
            if (!(overlay instanceof SettingsWidget)) continue;
            SettingsWidget settingsWidget = (SettingsWidget)overlay;
            return settingsWidget.getCachedDimensions();
        }
        return null;
    }

    public int getCursorCountOverride() {
        for (OverlayWidget overlay : this.overlays) {
            int override;
            if (!(overlay instanceof CraftingTableWidget)) continue;
            CraftingTableWidget craftingWidget = (CraftingTableWidget)overlay;
            if (!overlay.visible || (override = craftingWidget.getCursorCountOverride()) < 0) continue;
            return override;
        }
        return -1;
    }
}

