/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.theme.Theme;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public abstract class OverlayWidget
extends AbstractWidget {
    protected boolean isDragging = false;
    protected boolean isPinned = false;
    protected boolean isExpanded = false;
    protected boolean canExpand = false;
    protected int dragOffsetX = 0;
    protected int dragOffsetY = 0;
    protected int defaultX;
    protected int defaultY;
    protected static final int BASE_WIDTH = 36;
    protected static final int BASE_HEIGHT = 36;
    protected static final int EXPANDED_WIDTH = 72;
    protected static final int EXPANDED_HEIGHT = 70;
    protected static final int COMPACT_WIDTH = 28;
    protected static final int COMPACT_HEIGHT = 28;
    protected static final int COMPACT_EXPANDED_WIDTH = 56;
    protected static final int COMPACT_EXPANDED_HEIGHT = 56;
    protected static final int PIN_BUTTON_SIZE = 8;
    protected static final int EXPAND_BUTTON_SIZE = 8;
    protected static final int TITLE_BAR_HEIGHT = 12;
    protected Font font;
    protected boolean showContextMenu = false;
    protected int contextMenuX = 0;
    protected int contextMenuY = 0;

    public OverlayWidget(int x, int y, Component message, Font font) {
        super(x, y, 36, 36, message);
        this.defaultX = x;
        this.defaultY = y;
        this.font = font;
        this.updateWidgetDimensions();
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int currentWidth = this.width;
        int currentHeight = this.height;
        this.drawWidgetBackground(guiGraphics, currentWidth, currentHeight);
        this.renderMainContent(guiGraphics, mouseX, mouseY, partialTick);
        if (this.isTitleBarHovered(mouseX, mouseY) || this.isDragging) {
            int x = this.getX();
            int y = this.getY();
            int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            guiGraphics.fill(x, y, x + currentWidth, y + 12, hoverOverlay);
        }
        this.renderControlButtons(guiGraphics, mouseX, mouseY, currentWidth, currentHeight);
        if (this.showContextMenu) {
            this.renderContextMenu(guiGraphics, mouseX, mouseY);
        }
    }

    protected void drawWidgetBackground(GuiGraphics guiGraphics, int currentWidth, int currentHeight) {
        int x = this.getX();
        int y = this.getY();
        int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
        guiGraphics.fill(x, y, x + currentWidth, y + currentHeight, Theme.panelBg());
        guiGraphics.fill(x - 1, y - 1, x + currentWidth + 1, y + currentHeight + 1, Theme.panelBorder());
        guiGraphics.fill(x, y, x + currentWidth, y + currentHeight, Theme.panelBg());
        if (this.hasSideEars()) {
            guiGraphics.fill(x - 3, y + 2, x - 1, y + 8, Theme.panelBorder());
            guiGraphics.fill(x - 2, y + 3, x - 1, y + 7, Theme.panelBg());
            int rightEarX = x + currentWidth + 1;
            guiGraphics.fill(rightEarX, y + 2, rightEarX + 2, y + 8, Theme.panelBorder());
            guiGraphics.fill(rightEarX, y + 3, rightEarX + 1, y + 7, Theme.panelBg());
        }
    }

    protected boolean hasSideEars() {
        return false;
    }

    protected void renderControlButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, int currentWidth, int currentHeight) {
        int x = this.getX();
        int y = this.getY();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 500.0f);
        int pinX = x + currentWidth - 8 - 2;
        int pinY = y + 2;
        boolean pinHovered = mouseX >= pinX && mouseX <= pinX + 8 && mouseY >= pinY && mouseY <= pinY + 8;
        guiGraphics.fill(pinX, pinY, pinX + 8, pinY + 8, Theme.buttonBg(pinHovered));
        if (this.isPinned) {
            int c = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 6, c);
            guiGraphics.fill(pinX + 2, pinY + 2, pinX + 6, pinY + 3, c);
        } else {
            int c = Theme.textOnPanel();
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 5, pinY + 2, c);
            guiGraphics.fill(pinX + 3, pinY + 5, pinX + 5, pinY + 6, c);
            guiGraphics.fill(pinX + 3, pinY + 2, pinX + 3, pinY + 6, c);
            guiGraphics.fill(pinX + 5, pinY + 2, pinX + 5, pinY + 6, c);
        }
        guiGraphics.pose().popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isActive()) {
            return false;
        }
        if (button == 0 && this.showContextMenu) {
            boolean handled = this.handleContextMenuClick(mouseX, mouseY);
            if (handled) {
                return true;
            }
            this.showContextMenu = false;
            return true;
        }
        int x = this.getX();
        int y = this.getY();
        int currentWidth = this.width;
        int currentHeight = this.height;
        int pinX = x + currentWidth - 8 - 2;
        int pinY = y + 2;
        if (mouseX >= (double)pinX && mouseX <= (double)(pinX + 8) && mouseY >= (double)pinY && mouseY <= (double)(pinY + 8)) {
            this.togglePin();
            return true;
        }
        if (button == 1) {
            boolean titleBar;
            int titleBarHeight = 12;
            boolean bl = titleBar = mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + titleBarHeight);
            if (titleBar) {
                this.showContextMenu = true;
                this.contextMenuX = (int)mouseX;
                this.contextMenuY = (int)mouseY;
                return true;
            }
        }
        if (mouseX >= (double)x && mouseX <= (double)(x + currentWidth) && mouseY >= (double)y && mouseY <= (double)(y + currentHeight) && button == 0) {
            this.startDragging((int)mouseX, (int)mouseY);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void renderContextMenu(GuiGraphics g, int mouseX, int mouseY) {
        String label = this.getContextMenuLabel();
        if (label == null) {
            this.showContextMenu = false;
            return;
        }
        String[] lines = label.split("\\n");
        int w = 0;
        for (String line : lines) {
            w = Math.max(w, this.font.width(line) + 10);
        }
        int h = 12 * lines.length;
        int x = this.contextMenuX;
        int y = this.contextMenuY;
        g.fill(x, y, x + w, y + h, Theme.panelBg());
        g.fill(x - 1, y - 1, x + w + 1, y + h + 1, Theme.panelBorder());
        for (int i = 0; i < lines.length; ++i) {
            int hoverOverlay;
            int ly = y + i * 12;
            boolean hovered = mouseX >= x && mouseX <= x + w && mouseY >= ly && mouseY <= ly + 12;
            int n = hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
            if (hovered) {
                g.fill(x, ly, x + w, ly + 12, hoverOverlay);
            }
            g.drawString(this.font, lines[i], x + 5, ly + 2, Theme.textOnPanel());
        }
    }

    protected boolean handleContextMenuClick(double mouseX, double mouseY) {
        boolean inside;
        String label = this.getContextMenuLabel();
        if (label == null) {
            this.showContextMenu = false;
            return false;
        }
        String[] lines = label.split("\\n");
        int w = 0;
        for (String line : lines) {
            w = Math.max(w, this.font.width(line) + 10);
        }
        int h = 12 * lines.length;
        int x = this.contextMenuX;
        int y = this.contextMenuY;
        boolean bl = inside = mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h);
        if (inside) {
            this.showContextMenu = false;
            int index = (int)((mouseY - (double)y) / 12.0);
            if (index < 0) {
                index = 0;
            }
            if (index >= lines.length) {
                index = lines.length - 1;
            }
            this.handleContextMenuAction(index);
            return true;
        }
        this.showContextMenu = false;
        return false;
    }

    protected String getContextMenuLabel() {
        return null;
    }

    protected void handleContextMenuAction() {
    }

    protected void handleContextMenuAction(int index) {
        this.handleContextMenuAction();
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDragging && button == 0) {
            this.setPosition((int)mouseX - this.dragOffsetX, (int)mouseY - this.dragOffsetY);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isDragging && button == 0) {
            this.stopDragging();
            return true;
        }
        return false;
    }

    protected void startDragging(int mouseX, int mouseY) {
        if (!this.isPinned) {
            this.isDragging = true;
            this.dragOffsetX = mouseX - this.getX();
            this.dragOffsetY = mouseY - this.getY();
        }
    }

    protected void stopDragging() {
        if (this.isDragging) {
            this.isDragging = false;
        }
    }

    protected void togglePin() {
        this.isPinned = !this.isPinned;
    }

    protected void toggleExpansion() {
        if (this.canExpand) {
            this.isExpanded = !this.isExpanded;
            this.updateWidgetDimensions();
        }
    }

    protected void updateWidgetDimensions() {
        boolean useCompactMode = this.shouldUseCompactMode();
        if (this.isExpanded) {
            this.width = useCompactMode ? 56 : 72;
            this.height = useCompactMode ? 56 : 70;
        } else {
            this.width = useCompactMode ? 28 : 36;
            this.height = useCompactMode ? 28 : 36;
        }
    }

    protected boolean shouldUseCompactMode() {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.getWindow() == null) {
            return false;
        }
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        return screenWidth < 800 || screenHeight < 600;
    }

    public void resetPosition() {
        this.setPosition(this.defaultX, this.defaultY);
    }

    public void setPosition(int x, int y) {
        x = this.constrainToScreenBounds(x, this.width, true);
        y = this.constrainToScreenBounds(y, this.height, false);
        this.setX(x);
        this.setY(y);
    }

    private int constrainToScreenBounds(int pos, int size, boolean isX) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.getWindow() == null) {
            return pos;
        }
        int screenSize = isX ? mc.getWindow().getGuiScaledWidth() : mc.getWindow().getGuiScaledHeight();
        int minPos = 0;
        int maxPos = screenSize - size;
        if (screenSize < 800) {
            int minVisible = Math.max(20, size / 5);
            minPos = -size + minVisible;
            maxPos = screenSize - minVisible;
        }
        return Math.max(minPos, Math.min(maxPos, pos));
    }

    public void setDefaultPosition(int x, int y) {
        if (!this.isPinned) {
            this.defaultX = x;
            this.defaultY = y;
            this.setPosition(x, y);
        }
    }

    public void forceUpdatePosition(int x, int y) {
        this.setPosition(x, y);
    }

    public void onHoverStateChanged(boolean hovered) {
    }

    protected abstract void renderMainContent(GuiGraphics var1, int var2, int var3, float var4);

    protected abstract void renderExpandedContent(GuiGraphics var1, int var2, int var3, float var4);

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        if (this.isPinned) {
            // empty if block
        }
    }

    public boolean isPinned() {
        return this.isPinned;
    }

    protected boolean isTitleBarHovered(int mouseX, int mouseY) {
        int x = this.getX();
        int y = this.getY();
        int currentWidth = this.width;
        return mouseX >= x && mouseX <= x + currentWidth && mouseY >= y && mouseY <= y + 12;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public boolean canExpand() {
        return this.canExpand;
    }
}

