/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.client.screen.overlay;

import com.etka.nomadsshell.client.screen.overlay.OverlayWidget;
import com.etka.nomadsshell.client.screen.overlay.UpgradeDefinitions;
import com.etka.nomadsshell.client.screen.overlay.UpgradeGridConfig;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.client.screen.theme.Theme;
import com.etka.nomadsshell.config.OverlayConfig;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.network.ExecuteUpgradeCommandPacket;
import com.etka.nomadsshell.network.PurchaseDripstoneCauldronPacket;
import com.etka.nomadsshell.network.PurchaseFurnacePerfUpgradePacket;
import com.etka.nomadsshell.network.PurchaseFurnaceSlotUpgradePacket;
import com.etka.nomadsshell.network.PurchaseWidgetPacket;
import com.etka.nomadsshell.upgrade.UpgradeCommand;
import com.etka.nomadsshell.upgrade.UpgradeCommandRegistry;
import com.etka.nomadsshell.util.InventoryUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;

public class UpgradeWidget
extends OverlayWidget {
    private final IShellMenu menu;
    private boolean fullscreenOpen = false;
    private float zoom = 1.0f;
    private float panX = 0.0f;
    private float panY = 0.0f;
    private boolean panning = false;
    private int panStartMouseX;
    private int panStartMouseY;
    private float panStartX;
    private float panStartY;
    private boolean showDetailsPanel = false;
    private String selectedNodeId = null;
    private int detailsPanelX;
    private int detailsPanelY;
    private int detailsPanelW;
    private int detailsPanelH;
    private int unlockButtonX;
    private int unlockButtonY;
    private int unlockButtonW = 200;
    private int unlockButtonH = 24;
    private int closeButtonX;
    private int closeButtonY;
    private int closeButtonW = 24;
    private int closeButtonH = 24;
    private Map<String, Boolean> nodeUnlockCache = new HashMap<String, Boolean>();
    private ItemStack cachedShellStack = ItemStack.EMPTY;

    public UpgradeWidget(int x, int y, Font font, IShellMenu menu) {
        super(UpgradeWidget.loadPositionX(x), UpgradeWidget.loadPositionY(y), (Component)Component.translatable((String)"nomadsshell.upgrade.button"), font);
        this.menu = menu;
        this.isPinned = (Boolean)OverlayConfig.UPGRADE_PINNED.get();
        UpgradeDefinitions.getAllNodes();
    }

    private static int loadPositionX(int defaultX) {
        int cx = (Integer)OverlayConfig.UPGRADE_X.get();
        return cx != 0 ? cx : defaultX;
    }

    private static int loadPositionY(int defaultY) {
        int cy = (Integer)OverlayConfig.UPGRADE_Y.get();
        return cy != 0 ? cy : defaultY;
    }

    public void setX(int x) {
        super.setX(x);
        this.savePositionToConfig();
    }

    public void setY(int y) {
        super.setY(y);
        this.savePositionToConfig();
    }

    @Override
    protected void togglePin() {
        super.togglePin();
        this.savePinStateToConfig();
    }

    private void savePositionToConfig() {
        try {
            OverlayConfig.UPGRADE_X.set((Object)this.getX());
            OverlayConfig.UPGRADE_X.save();
            OverlayConfig.UPGRADE_Y.set((Object)this.getY());
            OverlayConfig.UPGRADE_Y.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void savePinStateToConfig() {
        try {
            OverlayConfig.UPGRADE_PINNED.set((Object)this.isPinned);
            OverlayConfig.UPGRADE_PINNED.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void renderWidget(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        if (!this.fullscreenOpen) {
            int x = this.getX();
            int y = this.getY();
            int w = this.width;
            int h = this.height;
            g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
            g.fill(x - 1, y - 1, x + w + 1, y + 12, Theme.panelBorder());
            g.fill(x, y, x + w, y + 12, Theme.titleBarBg());
            if (this.isTitleBarHovered(mouseX, mouseY) || this.isDragging) {
                int hoverOverlay = Theme.isLight() ? 0x30000000 : 0x30FFFFFF;
                g.fill(x, y, x + w, y + 12, hoverOverlay);
            }
            int contentY = y + 12;
            int contentHeight = h - 12;
            g.fill(x, contentY, x + w, contentY + contentHeight, Theme.panelBg());
            g.fill(x - 1, contentY - 1, x + w + 1, contentY + contentHeight + 1, Theme.panelBorder());
            g.fill(x, contentY, x + w, contentY + contentHeight, Theme.panelBg());
            this.renderMainContent(g, mouseX, mouseY, partialTick);
            this.renderControlButtons(g, mouseX, mouseY, w, h);
        } else {
            this.renderFullscreenGrid(g, mouseX, mouseY);
        }
    }

    @Override
    protected void renderMainContent(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int x = this.getX();
        int y = this.getY();
        int w = this.width;
        int h = this.height;
        int contentY = y + 12;
        int contentHeight = h - 12;
        int iconSize = 16;
        int iconX = x + (w - iconSize) / 2;
        int iconY = contentY + (contentHeight - iconSize) / 2;
        g.blit(Theme.icon("upgrade"), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
    }

    @Override
    protected void renderExpandedContent(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
    }

    private void renderFullscreenGrid(GuiGraphics g, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.getInstance();
        int sw = mc.getWindow().getGuiScaledWidth();
        int sh = mc.getWindow().getGuiScaledHeight();
        PoseStack pose = g.pose();
        pose.pushPose();
        g.fill(0, 0, sw, sh, -15066598);
        this.drawGridDots(g, sw, sh);
        pose.pushPose();
        pose.translate((float)sw / 2.0f + this.panX, (float)sh / 2.0f + this.panY, 0.0f);
        pose.scale(this.zoom, this.zoom, 1.0f);
        this.drawConnections(g);
        this.drawNodes(g, mouseX, mouseY, sw, sh);
        pose.popPose();
        if (this.showDetailsPanel && this.selectedNodeId != null) {
            this.drawDetailsPanel(g, sw, sh, mouseX, mouseY);
        }
        this.drawZoomControls(g, sw, sh, mouseX, mouseY);
        this.drawCloseButton(g, sw, sh, mouseX, mouseY);
        pose.popPose();
    }

    private void drawGridDots(GuiGraphics g, int sw, int sh) {
        int spacing = 40;
        int startX = (int)(((float)(-sw / 2) - this.panX) / this.zoom / (float)spacing) * spacing;
        int endX = (int)(((float)(sw / 2) - this.panX) / this.zoom / (float)spacing + 1.0f) * spacing;
        int startY = (int)(((float)(-sh / 2) - this.panY) / this.zoom / (float)spacing) * spacing;
        int endY = (int)(((float)(sh / 2) - this.panY) / this.zoom / (float)spacing + 1.0f) * spacing;
        for (int x = startX; x <= endX; x += spacing) {
            for (int y = startY; y <= endY; y += spacing) {
                int screenX = (int)((float)x * this.zoom + (float)(sw / 2) + this.panX);
                int screenY = (int)((float)y * this.zoom + (float)(sh / 2) + this.panY);
                if (screenX < 0 || screenX >= sw || screenY < 0 || screenY >= sh) continue;
                g.fill(screenX, screenY, screenX + 1, screenY + 1, 0x1AFFFFFF);
            }
        }
    }

    private void drawConnections(GuiGraphics g) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack shellStack = ShellItem.findWornshell((Player)player);
        for (UpgradeDefinitions.UpgradeNode node : UpgradeDefinitions.getAllNodes()) {
            int startX = UpgradeGridConfig.gridToPixel(node.gridX);
            int startY = UpgradeGridConfig.gridToPixelY(node.gridY);
            for (String connectionId : node.connections) {
                int lineColor;
                UpgradeDefinitions.UpgradeNode targetNode = UpgradeDefinitions.getNode(connectionId);
                if (targetNode == null) continue;
                int endX = UpgradeGridConfig.gridToPixel(targetNode.gridX);
                int endY = UpgradeGridConfig.gridToPixelY(targetNode.gridY);
                boolean startUnlocked = this.isNodeUnlocked(node, shellStack);
                boolean endUnlocked = this.isNodeUnlocked(targetNode, shellStack);
                if (startUnlocked && endUnlocked) {
                    lineColor = -2387198;
                } else if (startUnlocked) {
                    if (this.isNodeAvailable(targetNode, shellStack)) {
                        LocalPlayer playerLocal = Minecraft.getInstance().player;
                        boolean hasEnoughItems = playerLocal != null && this.hasRequiredItems(targetNode, (Player)playerLocal);
                        lineColor = hasEnoughItems ? -30669 : -3394765;
                    } else {
                        lineColor = -10461088;
                    }
                } else {
                    lineColor = -12566464;
                }
                this.drawLine(g, startX, startY, endX, endY, lineColor);
            }
        }
    }

    private void drawLine(GuiGraphics g, int x1, int y1, int x2, int y2, int color) {
        int lineWidth = 2;
        int dx = x2 - x1;
        int dy = y2 - y1;
        double length = Math.sqrt(dx * dx + dy * dy);
        if (length == 0.0) {
            return;
        }
        int steps = (int)length;
        for (int i = 0; i <= steps; ++i) {
            float t = (float)i / (float)steps;
            int x = (int)((float)x1 + (float)dx * t);
            int y = (int)((float)y1 + (float)dy * t);
            g.fill(x - lineWidth / 2, y - lineWidth / 2, x + lineWidth / 2, y + lineWidth / 2, color);
        }
    }

    private void drawNodes(GuiGraphics g, int mouseX, int mouseY, int sw, int sh) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack shellStack = ShellItem.findWornshell((Player)player);
        for (UpgradeDefinitions.UpgradeNode node : UpgradeDefinitions.getAllNodes()) {
            int borderColor;
            int nodeColor;
            int worldX = UpgradeGridConfig.gridToPixel(node.gridX);
            int worldY = UpgradeGridConfig.gridToPixelY(node.gridY);
            if (!node.alwaysVisible && !this.canSeeNode(node, shellStack)) continue;
            boolean unlocked = this.isNodeUnlocked(node, shellStack);
            boolean available = this.isNodeAvailable(node, shellStack);
            boolean isStartNode = node.id.equals("start");
            int nodeSize = isStartNode ? 48 : 24;
            int halfSize = nodeSize / 2;
            boolean hovered = this.isNodeHovered(worldX, worldY, mouseX, mouseY, sw, sh, nodeSize);
            if (isStartNode) {
                nodeColor = -217853;
                borderColor = -2387198;
                if (hovered) {
                    nodeColor = this.brightenColor(nodeColor);
                }
            } else if (unlocked) {
                nodeColor = -217853;
                borderColor = -2387198;
                if (hovered) {
                    nodeColor = this.brightenColor(nodeColor);
                }
            } else if (available) {
                boolean hasEnoughItems = this.hasRequiredItems(node, (Player)player);
                if (hasEnoughItems) {
                    nodeColor = -30669;
                    borderColor = -2263262;
                    if (hovered) {
                        nodeColor = this.brightenColor(nodeColor);
                    }
                } else {
                    nodeColor = -3394765;
                    borderColor = -5627358;
                    if (hovered) {
                        nodeColor = this.brightenColor(nodeColor);
                    }
                }
            } else {
                nodeColor = -12961222;
                borderColor = -14013910;
                if (hovered) {
                    nodeColor = this.brightenColor(nodeColor);
                }
            }
            g.fill(worldX - halfSize - 1, worldY - halfSize - 1, worldX + halfSize + 1, worldY + halfSize + 1, borderColor);
            g.fill(worldX - halfSize, worldY - halfSize, worldX + halfSize, worldY + halfSize, nodeColor);
            if (node.icon.isEmpty()) continue;
            PoseStack pose = g.pose();
            pose.pushPose();
            int iconSize = isStartNode ? 32 : 16;
            pose.translate((float)(worldX - iconSize / 2), (float)(worldY - iconSize / 2), 1.0f);
            pose.scale((float)iconSize / 16.0f, (float)iconSize / 16.0f, 1.0f);
            g.renderItem(node.icon, 0, 0);
            pose.popPose();
        }
    }

    private int brightenColor(int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = Math.min(255, (int)((float)red * 1.3f));
        green = Math.min(255, (int)((float)green * 1.3f));
        blue = Math.min(255, (int)((float)blue * 1.3f));
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    private boolean isNodeHovered(int worldX, int worldY, int mouseX, int mouseY, int sw, int sh) {
        return this.isNodeHovered(worldX, worldY, mouseX, mouseY, sw, sh, 24);
    }

    private boolean isNodeHovered(int worldX, int worldY, int mouseX, int mouseY, int sw, int sh, int nodeSize) {
        float worldMouseX = ((float)mouseX - (float)sw / 2.0f - this.panX) / this.zoom;
        float worldMouseY = ((float)mouseY - (float)sh / 2.0f - this.panY) / this.zoom;
        int halfSize = nodeSize / 2;
        return worldMouseX >= (float)(worldX - halfSize) && worldMouseX <= (float)(worldX + halfSize) && worldMouseY >= (float)(worldY - halfSize) && worldMouseY <= (float)(worldY + halfSize);
    }

    private boolean canSeeNode(UpgradeDefinitions.UpgradeNode node, ItemStack shellStack) {
        if (node.alwaysVisible) {
            return true;
        }
        for (UpgradeDefinitions.UpgradeNode other : UpgradeDefinitions.getAllNodes()) {
            if (!other.connections.contains(node.id) || !this.isNodeUnlocked(other, shellStack)) continue;
            return true;
        }
        return false;
    }

    private boolean isNodeAvailable(UpgradeDefinitions.UpgradeNode node, ItemStack shellStack) {
        if (this.isNodeUnlocked(node, shellStack)) {
            return false;
        }
        if (node.id.equals("start")) {
            return true;
        }
        for (UpgradeDefinitions.UpgradeNode other : UpgradeDefinitions.getAllNodes()) {
            if (!other.connections.contains(node.id) || !this.isNodeUnlocked(other, shellStack)) continue;
            return true;
        }
        return false;
    }

    private boolean hasRequiredItems(UpgradeDefinitions.UpgradeNode node, Player player) {
        int playerHas;
        if (player == null) {
            return false;
        }
        if (node.tagRequirement != null && node.tagCount > 0 && (playerHas = InventoryUtils.countItemByTagAcrossInventoryAndshell(player, ResourceLocation.parse((String)node.tagRequirement))) < node.tagCount) {
            return false;
        }
        for (ItemStack req : node.requirements) {
            int playerHas2 = InventoryUtils.countItemAcrossInventoryAndshell(player, req.getItem());
            if (playerHas2 >= req.getCount()) continue;
            return false;
        }
        return true;
    }

    private boolean isNodeUnlocked(UpgradeDefinitions.UpgradeNode node, ItemStack shellStack) {
        if (node.id.equals("start")) {
            return true;
        }
        if (node.widgetType != null) {
            boolean widgetUnlocked = WidgetUnlockSystem.isUnlocked(node.widgetType, shellStack);
            WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(node.widgetType, shellStack);
            return widgetUnlocked && currentTier.getLevel() >= node.tier.getLevel();
        }
        return this.isSubUpgradeUnlocked(node.id, shellStack);
    }

    private boolean isSubUpgradeUnlocked(String nodeId, ItemStack shellStack) {
        if (shellStack.isEmpty()) {
            return false;
        }
        if (nodeId.startsWith("furnace_smelt_speed_") || nodeId.startsWith("furnace_fuel_eff_")) {
            int n;
            try {
                n = Integer.parseInt(nodeId.substring(nodeId.lastIndexOf("_") + 1));
            }
            catch (NumberFormatException e) {
                return false;
            }
            int requiredLevel = nodeId.startsWith("furnace_smelt_speed_") ? Math.max(1, 2 * n - 1) : Math.min(6, 2 * n);
            int perfLevel = (Integer)shellStack.getOrDefault(ModDataComponents.FURNACE_PERF_UPGRADE_LEVEL.get(), (Object)0);
            return perfLevel >= requiredLevel;
        }
        switch (nodeId) {
            case "dripstone_1": 
            case "dripstone_2": 
            case "dripstone_3": 
            case "dripstone_4": 
            case "dripstone_5": {
                int requiredCauldrons;
                UpgradeCommand command;
                String commandId = this.getCommandIdForNode(nodeId);
                if (commandId != null && (command = UpgradeCommandRegistry.getCommand(commandId)) != null) {
                    int requiredCauldrons2;
                    int cauldronCount = (Integer)shellStack.getOrDefault(ModDataComponents.DRIP_CAULDRON_COUNT.get(), (Object)0);
                    return cauldronCount >= (requiredCauldrons2 = Integer.parseInt(nodeId.substring(nodeId.lastIndexOf("_") + 1)));
                }
                int cauldronCount = (Integer)shellStack.getOrDefault(ModDataComponents.DRIP_CAULDRON_COUNT.get(), (Object)0);
                return cauldronCount >= (requiredCauldrons = Integer.parseInt(nodeId.substring(nodeId.lastIndexOf("_") + 1)));
            }
            case "dripstone_auto_transfer": {
                UpgradeCommand autoTransferCommand;
                String autoTransferCommandId = this.getCommandIdForNode(nodeId);
                if (autoTransferCommandId != null && (autoTransferCommand = UpgradeCommandRegistry.getCommand(autoTransferCommandId)) != null) {
                    boolean alreadyEnabled = (Boolean)shellStack.getOrDefault(ModDataComponents.DRIP_AUTO_TRANSFER_ENABLED.get(), (Object)false);
                    return alreadyEnabled;
                }
                if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, shellStack)) {
                    return false;
                }
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_II.getLevel();
            }
            case "collector_unlock": {
                return WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.COLLECTOR, shellStack);
            }
            case "collector_tier2": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.COLLECTOR, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_II.getLevel();
            }
            case "furnace_unlock": {
                return WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.FURNACE, shellStack);
            }
            case "furnace_tier2": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FURNACE, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_II.getLevel();
            }
            case "furnace_smelt_speed_1": 
            case "furnace_fuel_eff_1": 
            case "furnace_smelt_speed_2": 
            case "furnace_fuel_eff_2": 
            case "furnace_smelt_speed_3": 
            case "furnace_fuel_eff_3": {
                int n;
                int perfLevel = (Integer)shellStack.getOrDefault(ModDataComponents.FURNACE_PERF_UPGRADE_LEVEL.get(), (Object)0);
                try {
                    n = Integer.parseInt(nodeId.substring(nodeId.lastIndexOf("_") + 1));
                }
                catch (NumberFormatException e) {
                    return false;
                }
                int requiredLevel = nodeId.startsWith("furnace_smelt_speed_") ? Math.max(1, 2 * n - 1) : Math.min(6, 2 * n);
                return perfLevel >= requiredLevel;
            }
            case "furnace_template_1": 
            case "furnace_template_2": 
            case "furnace_template_3": 
            case "furnace_template_4": {
                int templateSlots = (Integer)shellStack.getOrDefault(ModDataComponents.FURNACE_EXTRA_TEMPLATE_SLOTS.get(), (Object)0);
                int requiredSlots = Integer.parseInt(nodeId.substring(nodeId.lastIndexOf("_") + 1));
                return templateSlots >= requiredSlots;
            }
            case "furnace_tag_puller": {
                int tagPullerSlots = (Integer)shellStack.getOrDefault(ModDataComponents.FURNACE_EXTRA_TEMPLATE_SLOTS.get(), (Object)0);
                return tagPullerSlots >= 5;
            }
            case "guardian_leather": {
                return WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.GUARDIAN, shellStack);
            }
            case "guardian_gold": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.GUARDIAN, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_II.getLevel();
            }
            case "guardian_iron": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.GUARDIAN, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_III.getLevel();
            }
            case "guardian_diamond": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.GUARDIAN, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_IV.getLevel();
            }
            case "guardian_netherite": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.GUARDIAN, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_V.getLevel();
            }
            case "guardian_light": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.GUARDIAN, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_VI.getLevel();
            }
            case "guardian_powder_snow": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.GUARDIAN, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_VII.getLevel();
            }
            case "guardian_piglin": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.GUARDIAN, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_VIII.getLevel();
            }
            case "guardian_slowfall": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.GUARDIAN, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_IX.getLevel();
            }
            case "guardian_invisibility": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.GUARDIAN, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_X.getLevel();
            }
            case "teleporter_unlock": {
                return WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.TELEPORTER, shellStack);
            }
            case "teleporter_nether": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.TELEPORTER, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_II.getLevel();
            }
            case "teleporter_near": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.TELEPORTER, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_III.getLevel();
            }
            case "teleporter_pocket": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.TELEPORTER, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_IV.getLevel();
            }
            case "teleporter_end": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.TELEPORTER, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_V.getLevel();
            }
            case "fluid_unlock": {
                return WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.FLUID_TANK, shellStack);
            }
            case "fluid_tier2": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_II.getLevel();
            }
            case "fluid_tier3": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_III.getLevel();
            }
            case "fluid_tier4": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_IV.getLevel();
            }
            case "fluid_tier5": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_V.getLevel();
            }
            case "fluid_tier6": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_VI.getLevel();
            }
            case "fluid_tier7": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_VII.getLevel();
            }
            case "fluid_tier8": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.FLUID_TANK, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_VIII.getLevel();
            }
            case "crafting_2x2": {
                return WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE, shellStack);
            }
            case "crafting_3x3": {
                return WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE, shellStack).getLevel() >= WidgetUnlockSystem.WidgetTier.TIER_II.getLevel();
            }
            case "auto_crafter_unlock": {
                return (Boolean)shellStack.getOrDefault(ModDataComponents.AUTO_CRAFTER_UNLOCKED.get(), (Object)false);
            }
        }
        return false;
    }

    private void drawDetailsPanel(GuiGraphics g, int sw, int sh, int mouseX, int mouseY) {
        int playerHas;
        UpgradeDefinitions.UpgradeNode node = UpgradeDefinitions.getNode(this.selectedNodeId);
        if (node == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack shellStack = ShellItem.findWornshell((Player)player);
        this.detailsPanelW = 280;
        this.detailsPanelH = sh;
        this.detailsPanelX = sw - this.detailsPanelW;
        this.detailsPanelY = 0;
        PoseStack pose = g.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, 200.0f);
        RenderSystem.disableDepthTest();
        g.fill(this.detailsPanelX - 1, this.detailsPanelY, this.detailsPanelX, this.detailsPanelH, -12566464);
        g.fill(this.detailsPanelX, this.detailsPanelY, this.detailsPanelX + this.detailsPanelW, this.detailsPanelH, -534765536);
        int contentX = this.detailsPanelX + 12;
        int contentY = 12;
        this.closeButtonX = this.detailsPanelX + this.detailsPanelW - 32;
        this.closeButtonY = 8;
        boolean closeHovered = mouseX >= this.closeButtonX && mouseX <= this.closeButtonX + this.closeButtonW && mouseY >= this.closeButtonY && mouseY <= this.closeButtonY + this.closeButtonH;
        g.fill(this.closeButtonX, this.closeButtonY, this.closeButtonX + this.closeButtonW, this.closeButtonY + this.closeButtonH, closeHovered ? -11513776 : -12961222);
        g.drawString(this.font, "\u00d7", this.closeButtonX + 8, this.closeButtonY + 8, -1);
        if (!node.icon.isEmpty()) {
            PoseStack itemPose = g.pose();
            itemPose.pushPose();
            itemPose.translate((float)contentX, (float)contentY, 100.0f);
            g.renderItem(node.icon, 0, 0);
            itemPose.popPose();
        }
        String title = Component.translatable((String)node.titleKey).getString();
        g.drawString(this.font, title, contentX + 24, contentY + 4, -1);
        contentY += 28;
        String desc = Component.translatable((String)node.descriptionKey).getString();
        List<String> descLines = this.wrapText(desc, this.detailsPanelW - 24);
        for (String line : descLines) {
            g.drawString(this.font, line, contentX, contentY, -5592406);
            contentY += 12;
        }
        contentY += 8;
        if (!node.requirements.isEmpty() || node.tagRequirement != null) {
            g.drawString(this.font, Component.translatable((String)"nomadsshell.ui.requirements").getString(), contentX, contentY, -3355444);
            contentY += 14;
            if (node.tagRequirement != null && node.tagCount > 0) {
                List<Item> applicableItems = InventoryUtils.getTagExpansion(node.tagRequirement);
                int cycleIndex = 0;
                if (!applicableItems.isEmpty()) {
                    long currentTime = System.currentTimeMillis();
                    cycleIndex = (int)(currentTime / 1500L % (long)applicableItems.size());
                }
                PoseStack tagPose = g.pose();
                tagPose.pushPose();
                tagPose.translate((float)contentX, (float)contentY, 100.0f);
                Item displayItem = applicableItems.isEmpty() ? Items.COBBLESTONE : (Item)applicableItems.get(cycleIndex);
                g.renderItem(new ItemStack((ItemLike)displayItem), 0, 0);
                tagPose.popPose();
                playerHas = InventoryUtils.countItemByTagAcrossInventoryAndshell((Player)player, ResourceLocation.parse((String)node.tagRequirement));
                int required = node.tagCount;
                String tagTranslationKey = "nomadsshell.tag." + node.tagRequirement.replace(":", ".");
                MutableComponent tagNameComponent = Component.translatable((String)tagTranslationKey);
                String reqText = required + "x " + tagNameComponent.getString();
                g.drawString(this.font, reqText, contentX + 20, contentY + 4, -1);
                MutableComponent countComponent = Component.translatable((String)"nomadsshell.upgrade.requirement.you_have", (Object[])new Object[]{playerHas});
                int textColor = playerHas >= required ? -16711936 : -65536;
                g.drawString(this.font, countComponent.getString(), contentX + 20, contentY + 16, textColor);
                contentY += 32;
            }
            for (ItemStack req : node.requirements) {
                PoseStack reqPose = g.pose();
                reqPose.pushPose();
                reqPose.translate((float)contentX, (float)contentY, 100.0f);
                g.renderItem(req, 0, 0);
                reqPose.popPose();
                int playerHas2 = InventoryUtils.countItemAcrossInventoryAndshell((Player)player, req.getItem());
                int required = req.getCount();
                String reqText = required + "x " + req.getHoverName().getString();
                g.drawString(this.font, reqText, contentX + 20, contentY + 4, -1);
                String countText = Component.translatable((String)"nomadsshell.ui.you_have", (Object[])new Object[]{playerHas2}).getString();
                int textColor = playerHas2 >= required ? -16711936 : -65536;
                g.drawString(this.font, countText, contentX + 20, contentY + 16, textColor);
                contentY += 32;
            }
        }
        boolean unlocked = this.isNodeUnlocked(node, shellStack);
        boolean available = this.isNodeAvailable(node, shellStack);
        this.unlockButtonX = contentX;
        this.unlockButtonY = contentY += 12;
        if (unlocked) {
            g.fill(this.unlockButtonX, this.unlockButtonY, this.unlockButtonX + this.unlockButtonW, this.unlockButtonY + this.unlockButtonH, -13792723);
            text = Component.translatable((String)"nomadsshell.ui.unlocked").getString();
            int textW = this.font.width(text);
            g.drawString(this.font, text, this.unlockButtonX + (this.unlockButtonW - textW) / 2, this.unlockButtonY + 8, -1);
        } else if (available) {
            boolean btnHovered;
            boolean isCreative;
            boolean hasRequiredItems = isCreative = player != null && player.getAbilities().instabuild;
            if (!isCreative) {
                hasRequiredItems = true;
                if (node.tagRequirement != null && node.tagCount > 0 && (playerHas = InventoryUtils.countItemByTagAcrossInventoryAndshell((Player)player, ResourceLocation.parse((String)node.tagRequirement))) < node.tagCount) {
                    hasRequiredItems = false;
                }
                if (hasRequiredItems) {
                    for (ItemStack req : node.requirements) {
                        int playerHas3 = InventoryUtils.countItemAcrossInventoryAndshell((Player)player, req.getItem());
                        if (playerHas3 >= req.getCount()) continue;
                        hasRequiredItems = false;
                        break;
                    }
                }
            }
            boolean bl = btnHovered = mouseX >= this.unlockButtonX && mouseX <= this.unlockButtonX + this.unlockButtonW && mouseY >= this.unlockButtonY && mouseY <= this.unlockButtonY + this.unlockButtonH;
            int btnColor = hasRequiredItems ? (btnHovered ? -9783553 : -11886849) : -12566464;
            g.fill(this.unlockButtonX, this.unlockButtonY, this.unlockButtonX + this.unlockButtonW, this.unlockButtonY + this.unlockButtonH, btnColor);
            String text = hasRequiredItems ? Component.translatable((String)"nomadsshell.ui.unlock").getString() : Component.translatable((String)"nomadsshell.ui.need_items").getString();
            int textW = this.font.width(text);
            int textColor = hasRequiredItems ? -1 : -8355712;
            g.drawString(this.font, text, this.unlockButtonX + (this.unlockButtonW - textW) / 2, this.unlockButtonY + 8, textColor);
        } else {
            g.fill(this.unlockButtonX, this.unlockButtonY, this.unlockButtonX + this.unlockButtonW, this.unlockButtonY + this.unlockButtonH, -12566464);
            text = Component.translatable((String)"nomadsshell.ui.locked").getString();
            int textW = this.font.width(text);
            g.drawString(this.font, text, this.unlockButtonX + (this.unlockButtonW - textW) / 2, this.unlockButtonY + 8, -8355712);
        }
        RenderSystem.enableDepthTest();
        pose.popPose();
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (this.font.width(String.valueOf(currentLine) + word) > maxWidth && currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder();
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private void drawZoomControls(GuiGraphics g, int sw, int sh, int mouseX, int mouseY) {
        int btnSize = 32;
        int btnX = sw - 48;
        int btnY = sh - 48 - btnSize * 3;
        boolean zoomInHovered = mouseX >= btnX && mouseX <= btnX + btnSize && mouseY >= btnY && mouseY <= btnY + btnSize;
        g.fill(btnX, btnY, btnX + btnSize, btnY + btnSize, zoomInHovered ? -11513776 : -12961222);
        g.drawString(this.font, "+", btnX + 12, btnY + 12, -1);
        boolean zoomOutHovered = mouseX >= btnX && mouseX <= btnX + btnSize && mouseY >= (btnY += btnSize + 8) && mouseY <= btnY + btnSize;
        g.fill(btnX, btnY, btnX + btnSize, btnY + btnSize, zoomOutHovered ? -11513776 : -12961222);
        g.drawString(this.font, "-", btnX + 13, btnY + 12, -1);
        boolean resetHovered = mouseX >= btnX && mouseX <= btnX + btnSize && mouseY >= (btnY += btnSize + 8) && mouseY <= btnY + btnSize;
        g.fill(btnX, btnY, btnX + btnSize, btnY + btnSize, resetHovered ? -11513776 : -12961222);
        g.drawString(this.font, "\u25cb", btnX + 11, btnY + 12, -1);
    }

    private void drawCloseButton(GuiGraphics g, int sw, int sh, int mouseX, int mouseY) {
        int btnSize = 32;
        int btnX = 16;
        int btnY = 16;
        boolean hovered = mouseX >= btnX && mouseX <= btnX + btnSize && mouseY >= btnY && mouseY <= btnY + btnSize;
        g.fill(btnX, btnY, btnX + btnSize, btnY + btnSize, hovered ? -11513776 : -12961222);
        g.drawString(this.font, "\u2715", btnX + 10, btnY + 12, -1);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.fullscreenOpen) {
            int x = this.getX();
            int y = this.getY();
            int w = this.width;
            int pinX = x + w - 8 - 2;
            int pinY = y + 2;
            if (mouseX >= (double)pinX && mouseX <= (double)(pinX + 8) && mouseY >= (double)pinY && mouseY <= (double)(pinY + 8)) {
                this.togglePin();
                return true;
            }
            if (this.isTitleBarHovered((int)mouseX, (int)mouseY)) {
                return super.mouseClicked(mouseX, mouseY, button);
            }
            if (button == 0 && this.isMouseOver(mouseX, mouseY)) {
                this.fullscreenOpen = true;
                return true;
            }
        } else {
            Minecraft mc = Minecraft.getInstance();
            int sw = mc.getWindow().getGuiScaledWidth();
            int sh = mc.getWindow().getGuiScaledHeight();
            int closeBtnX = 16;
            int closeBtnY = 16;
            int closeBtnSize = 32;
            if (mouseX >= (double)closeBtnX && mouseX <= (double)(closeBtnX + closeBtnSize) && mouseY >= (double)closeBtnY && mouseY <= (double)(closeBtnY + closeBtnSize)) {
                this.fullscreenOpen = false;
                this.showDetailsPanel = false;
                return true;
            }
            if (this.showDetailsPanel && mouseX >= (double)this.closeButtonX && mouseX <= (double)(this.closeButtonX + this.closeButtonW) && mouseY >= (double)this.closeButtonY && mouseY <= (double)(this.closeButtonY + this.closeButtonH)) {
                this.showDetailsPanel = false;
                this.selectedNodeId = null;
                return true;
            }
            if (this.showDetailsPanel && mouseX >= (double)this.unlockButtonX && mouseX <= (double)(this.unlockButtonX + this.unlockButtonW) && mouseY >= (double)this.unlockButtonY && mouseY <= (double)(this.unlockButtonY + this.unlockButtonH)) {
                this.handleUnlockClick();
                return true;
            }
            int btnSize = 32;
            int btnX = sw - 48;
            int btnY = sh - 48 - btnSize * 3;
            if (mouseX >= (double)btnX && mouseX <= (double)(btnX + btnSize) && mouseY >= (double)btnY && mouseY <= (double)(btnY + btnSize)) {
                this.zoom = UpgradeGridConfig.clampZoom(this.zoom + 0.2f);
                return true;
            }
            btnY += btnSize + 8;
            if (mouseX >= (double)btnX && mouseX <= (double)(btnX + btnSize) && mouseY >= (double)btnY && mouseY <= (double)(btnY + btnSize)) {
                this.zoom = UpgradeGridConfig.clampZoom(this.zoom - 0.2f);
                return true;
            }
            btnY += btnSize + 8;
            if (mouseX >= (double)btnX && mouseX <= (double)(btnX + btnSize) && mouseY >= (double)btnY && mouseY <= (double)(btnY + btnSize)) {
                this.zoom = 1.0f;
                this.panX = 0.0f;
                this.panY = 0.0f;
                return true;
            }
            if (button == 0) {
                LocalPlayer player = mc.player;
                if (player != null) {
                    ItemStack shellStack = ShellItem.findWornshell((Player)player);
                    for (UpgradeDefinitions.UpgradeNode node : UpgradeDefinitions.getAllNodes()) {
                        int nodeSize;
                        int worldY;
                        if (!node.alwaysVisible && !this.canSeeNode(node, shellStack)) continue;
                        int worldX = UpgradeGridConfig.gridToPixel(node.gridX);
                        if (!this.isNodeHovered(worldX, worldY = UpgradeGridConfig.gridToPixelY(node.gridY), (int)mouseX, (int)mouseY, sw, sh, nodeSize = node.id.equals("start") ? 48 : 24)) continue;
                        this.selectedNodeId = node.id;
                        this.showDetailsPanel = true;
                        return true;
                    }
                }
                this.panning = true;
                this.panStartMouseX = (int)mouseX;
                this.panStartMouseY = (int)mouseY;
                this.panStartX = this.panX;
                this.panStartY = this.panY;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.panning && button == 0) {
            this.panning = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.panning) {
            this.panX = this.panStartX + (float)((int)mouseX - this.panStartMouseX);
            this.panY = this.panStartY + (float)((int)mouseY - this.panStartMouseY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.fullscreenOpen) {
            float zoomDelta = (float)scrollY * 0.1f;
            this.zoom = UpgradeGridConfig.clampZoom(this.zoom + zoomDelta);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    private void handleUnlockClick() {
        boolean isCreative;
        if (this.selectedNodeId == null) {
            return;
        }
        UpgradeDefinitions.UpgradeNode node = UpgradeDefinitions.getNode(this.selectedNodeId);
        if (node == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack shellStack = ShellItem.findWornshell((Player)player);
        if (!this.isNodeAvailable(node, shellStack) || this.isNodeUnlocked(node, shellStack)) {
            return;
        }
        boolean hasRequiredItems = isCreative = player.getAbilities().instabuild;
        if (!isCreative) {
            int playerHas;
            hasRequiredItems = true;
            if (node.tagRequirement != null && node.tagCount > 0 && (playerHas = InventoryUtils.countItemByTagAcrossInventoryAndshell((Player)player, ResourceLocation.parse((String)node.tagRequirement))) < node.tagCount) {
                hasRequiredItems = false;
            }
            if (hasRequiredItems) {
                for (ItemStack req : node.requirements) {
                    int playerHas2 = InventoryUtils.countItemAcrossInventoryAndshell((Player)player, req.getItem());
                    if (playerHas2 >= req.getCount()) continue;
                    hasRequiredItems = false;
                    break;
                }
            }
            if (!hasRequiredItems) {
                return;
            }
        }
        if (node.widgetType != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new PurchaseWidgetPacket(node.widgetType, node.tier), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            String commandId = this.getCommandIdForNode(node.id);
            if (commandId != null) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ExecuteUpgradeCommandPacket(commandId), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ItemStack clientShellStack = ShellItem.findWornshell((Player)player);
                if (!clientShellStack.isEmpty()) {
                    this.executeCommandClientSide(commandId, clientShellStack);
                }
            } else {
                this.handleSubUpgradeUnlock(node.id, (Player)player);
            }
        }
        this.nodeUnlockCache.clear();
        this.cachedShellStack = ItemStack.EMPTY;
    }

    private String getCommandIdForNode(String nodeId) {
        return switch (nodeId) {
            case "dripstone_1" -> "add_dripstone_cauldron_1";
            case "dripstone_2" -> "add_dripstone_cauldron_2";
            case "dripstone_3" -> "add_dripstone_cauldron_3";
            case "dripstone_4" -> "add_dripstone_cauldron_4";
            case "dripstone_5" -> "add_dripstone_cauldron_5";
            case "dripstone_auto_transfer" -> "enable_dripstone_auto_pusher";
            case "collector_unlock" -> "unlock_collector";
            case "collector_tier2" -> "upgrade_collector_tier2";
            case "furnace_unlock" -> "unlock_furnace";
            case "furnace_tier2" -> "upgrade_furnace_tier2";
            case "furnace_smelt_speed_1", "furnace_fuel_eff_1", "furnace_smelt_speed_2", "furnace_fuel_eff_2", "furnace_smelt_speed_3", "furnace_fuel_eff_3" -> "upgrade_furnace_performance";
            case "furnace_template_1", "furnace_template_2", "furnace_template_3", "furnace_template_4", "furnace_tag_puller" -> "upgrade_furnace_template_slots";
            case "guardian_leather" -> "unlock_guardian";
            case "guardian_gold" -> "upgrade_guardian_tier_ii";
            case "guardian_iron" -> "upgrade_guardian_tier_iii";
            case "guardian_diamond" -> "upgrade_guardian_tier_iv";
            case "guardian_netherite" -> "upgrade_guardian_tier_v";
            case "guardian_light" -> "upgrade_guardian_tier_vi";
            case "guardian_powder_snow" -> "upgrade_guardian_tier_vii";
            case "guardian_piglin" -> "upgrade_guardian_tier_viii";
            case "guardian_slowfall" -> "upgrade_guardian_tier_ix";
            case "guardian_invisibility" -> "upgrade_guardian_tier_x";
            case "teleporter_unlock" -> "unlock_teleporter";
            case "teleporter_nether" -> "upgrade_teleporter_tier_ii";
            case "teleporter_near" -> "upgrade_teleporter_tier_iii";
            case "teleporter_pocket" -> "upgrade_teleporter_tier_iv";
            case "teleporter_end" -> "upgrade_teleporter_tier_v";
            case "fluid_unlock" -> "unlock_fluid_tank";
            case "fluid_tier2" -> "upgrade_fluid_tank_tier_ii";
            case "fluid_tier3" -> "upgrade_fluid_tank_tier_iii";
            case "fluid_tier4" -> "upgrade_fluid_tank_tier_iv";
            case "fluid_tier5" -> "upgrade_fluid_tank_tier_v";
            case "fluid_tier6" -> "upgrade_fluid_tank_tier_vi";
            case "fluid_tier7" -> "upgrade_fluid_tank_tier_vii";
            case "fluid_tier8" -> "upgrade_fluid_tank_tier_viii";
            case "crafting_2x2" -> "unlock_crafting";
            case "crafting_3x3" -> "upgrade_crafting_tier2";
            case "auto_crafter_unlock" -> "unlock_auto_crafter";
            default -> null;
        };
    }

    private void executeCommandClientSide(String commandId, ItemStack shellStack) {
        UpgradeCommand command = UpgradeCommandRegistry.getCommand(commandId);
        if (command != null) {
            command.execute(shellStack, null);
        }
    }

    private void handleSubUpgradeUnlock(String nodeId, Player player) {
        if (nodeId.startsWith("furnace_smelt_speed_") || nodeId.startsWith("furnace_fuel_eff_")) {
            PacketDistributor.sendToServer((CustomPacketPayload)new PurchaseFurnacePerfUpgradePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        switch (nodeId) {
            case "furnace_template_1": 
            case "furnace_template_2": 
            case "furnace_template_3": 
            case "furnace_template_4": 
            case "furnace_tag_puller": {
                PacketDistributor.sendToServer((CustomPacketPayload)new PurchaseFurnaceSlotUpgradePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                break;
            }
            case "dripstone_2": 
            case "dripstone_3": 
            case "dripstone_4": 
            case "dripstone_5": {
                PacketDistributor.sendToServer((CustomPacketPayload)new PurchaseDripstoneCauldronPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                break;
            }
            case "dripstone_auto_transfer": {
                PacketDistributor.sendToServer((CustomPacketPayload)new PurchaseWidgetPacket(WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM, WidgetUnlockSystem.WidgetTier.TIER_II), (CustomPacketPayload[])new CustomPacketPayload[0]);
                break;
            }
            default: {
                if (player == null) break;
                player.sendSystemMessage((Component)Component.translatable((String)"nomadsshell.ui.unknown_upgrade", (Object[])new Object[]{nodeId}));
            }
        }
    }

    public boolean isFullscreenOpen() {
        return this.fullscreenOpen;
    }

    @Override
    protected void updateWidgetNarration(NarrationElementOutput output) {
        output.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"nomadsshell.widget.upgrade_tree"));
    }
}

