/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.compat;

import com.etka.nomadsshell.item.ShellItem;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class CuriosCompat {
    public static boolean isCuriosAvailable() {
        try {
            Class<?> modListClass = Class.forName("net.neoforged.fml.ModList");
            Object modList = modListClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
            boolean loaded = (Boolean)modList.getClass().getMethod("isLoaded", String.class).invoke(modList, "curios");
            if (!loaded) {
                return false;
            }
        }
        catch (Throwable modListClass) {
            // empty catch block
        }
        try {
            Class.forName("top.theillusivec4.curios.api.CuriosApi");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static ItemStack findWornShell(Player player) {
        ItemStack chestSlot = player.getItemBySlot(EquipmentSlot.CHEST);
        if (chestSlot.getItem() instanceof ShellItem) {
            return chestSlot;
        }
        if (CuriosCompat.isCuriosAvailable()) {
            return CuriosCompat.findShellInCurios(player);
        }
        return ItemStack.EMPTY;
    }

    private static ItemStack findShellInCurios(Player player) {
        try {
            boolean present;
            Class<?> curiosApiClass = Class.forName("top.theillusivec4.curios.api.CuriosApi");
            Class<?> livingEntityClass = Class.forName("net.minecraft.world.entity.LivingEntity");
            Method getCuriosInventoryMethod = curiosApiClass.getMethod("getCuriosInventory", livingEntityClass);
            Object optionalHandler = getCuriosInventoryMethod.invoke(null, player);
            Class<?> optionalClass = Class.forName("java.util.Optional");
            Object handler = null;
            if (optionalClass.isInstance(optionalHandler) && (present = ((Boolean)optionalClass.getMethod("isPresent", new Class[0]).invoke(optionalHandler, new Object[0])).booleanValue())) {
                handler = optionalClass.getMethod("get", new Class[0]).invoke(optionalHandler, new Object[0]);
            }
            if (handler != null) {
                boolean present2;
                Method findFirstCurioMethod = handler.getClass().getMethod("findFirstCurio", Predicate.class);
                Predicate<ItemStack> predicate = stack -> stack.getItem() instanceof ShellItem;
                Object slotResultOptional = findFirstCurioMethod.invoke(handler, predicate);
                Object slotResult = null;
                if (optionalClass.isInstance(slotResultOptional) && (present2 = ((Boolean)optionalClass.getMethod("isPresent", new Class[0]).invoke(slotResultOptional, new Object[0])).booleanValue())) {
                    slotResult = optionalClass.getMethod("get", new Class[0]).invoke(slotResultOptional, new Object[0]);
                }
                if (slotResult != null) {
                    Method getStackMethod = slotResult.getClass().getMethod("stack", new Class[0]);
                    return (ItemStack)getStackMethod.invoke(slotResult, new Object[0]);
                }
            }
            return ItemStack.EMPTY;
        }
        catch (Exception e) {
            return ItemStack.EMPTY;
        }
    }

    public static boolean hasCuriosInventory(Player player) {
        if (!CuriosCompat.isCuriosAvailable()) {
            return false;
        }
        try {
            Class<?> curiosApiClass = Class.forName("top.theillusivec4.curios.api.CuriosApi");
            Class<?> livingEntityClass = Class.forName("net.minecraft.world.entity.LivingEntity");
            Method getCuriosInventoryMethod = curiosApiClass.getMethod("getCuriosInventory", livingEntityClass);
            Object optionalHandler = getCuriosInventoryMethod.invoke(null, player);
            Class<?> optionalClass = Class.forName("java.util.Optional");
            if (optionalClass.isInstance(optionalHandler)) {
                return (Boolean)optionalClass.getMethod("isPresent", new Class[0]).invoke(optionalHandler, new Object[0]);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Optional<Object> getCuriosInventory(Player player) {
        if (!CuriosCompat.isCuriosAvailable()) {
            return Optional.empty();
        }
        try {
            boolean present;
            Class<?> curiosApiClass = Class.forName("top.theillusivec4.curios.api.CuriosApi");
            Class<?> livingEntityClass = Class.forName("net.minecraft.world.entity.LivingEntity");
            Method getCuriosInventoryMethod = curiosApiClass.getMethod("getCuriosInventory", livingEntityClass);
            Object optionalHandler = getCuriosInventoryMethod.invoke(null, player);
            Class<?> optionalClass = Class.forName("java.util.Optional");
            if (optionalClass.isInstance(optionalHandler) && (present = ((Boolean)optionalClass.getMethod("isPresent", new Class[0]).invoke(optionalHandler, new Object[0])).booleanValue())) {
                Object handler = optionalClass.getMethod("get", new Class[0]).invoke(optionalHandler, new Object[0]);
                return Optional.ofNullable(handler);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static void registerCuriosRenderer(Item item, Supplier<Object> rendererSupplier) {
        if (!CuriosCompat.isCuriosAvailable()) {
            return;
        }
        try {
            Class<?> curiosRendererRegistryClass = Class.forName("top.theillusivec4.curios.api.client.CuriosRendererRegistry");
            Method registerMethod = curiosRendererRegistryClass.getMethod("register", Item.class, Supplier.class);
            registerMethod.invoke(null, item, rendererSupplier);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void registerCurioPredicate(ResourceLocation predicateId, Function<Object, Boolean> predicate) {
        if (!CuriosCompat.isCuriosAvailable()) {
            return;
        }
        try {
            Class<?> curiosApiClass = Class.forName("top.theillusivec4.curios.api.CuriosApi");
            Method registerCurioPredicateMethod = curiosApiClass.getMethod("registerCurioPredicate", ResourceLocation.class, Function.class);
            registerCurioPredicateMethod.invoke(null, predicateId, predicate);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void registerCuriosCapability(RegisterCapabilitiesEvent event, Item item, BiFunction<ItemStack, Object, Object> capabilityProvider) {
        if (!CuriosCompat.isCuriosAvailable()) {
            return;
        }
        try {
            Class<?> curiosCapabilityClass = Class.forName("top.theillusivec4.curios.api.CuriosCapability");
            Object curiosCapabilityItem = curiosCapabilityClass.getField("ITEM").get(null);
            Method registerItemMethod = event.getClass().getMethod("registerItem", Object.class, Function.class, Item.class);
            registerItemMethod.invoke((Object)event, curiosCapabilityItem, capabilityProvider, item);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

