/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.init;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((Registry)BuiltInRegistries.FLUID, (String)"nomadsshell");
    public static final Supplier<Fluid> MILK = FLUIDS.register("milk", () -> new PlaceholderFluid("milk", Items.MILK_BUCKET));
    public static final Supplier<Fluid> POWDER_SNOW = FLUIDS.register("powder_snow", () -> new PlaceholderFluid("powder_snow", Items.POWDER_SNOW_BUCKET));
    public static final Supplier<Fluid> HONEY = FLUIDS.register("honey", () -> new PlaceholderFluid("honey", Items.HONEY_BOTTLE));
    public static final Supplier<Fluid> POTION = FLUIDS.register("potion", () -> new PlaceholderFluid("potion", Items.POTION));

    public static void register(IEventBus eventBus) {
        FLUIDS.register(eventBus);
    }

    private static final class PlaceholderFluid
    extends Fluid {
        private final String descriptionId;
        private final Item bucketItem;

        private PlaceholderFluid(String name, Item bucketItem) {
            this.descriptionId = "fluid.nomadsshell." + name;
            this.bucketItem = bucketItem;
        }

        public String toString() {
            return this.descriptionId;
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
        }

        public boolean isSame(Fluid fluid) {
            return fluid == this;
        }

        public boolean canBeReplacedWith(FluidState state, BlockGetter level, BlockPos pos, Fluid fluid, Direction direction) {
            return false;
        }

        public int getTickDelay(LevelReader level) {
            return 0;
        }

        protected float getExplosionResistance() {
            return 100.0f;
        }

        public Item getBucket() {
            return this.bucketItem;
        }

        public VoxelShape getShape(FluidState state, BlockGetter level, BlockPos pos) {
            return Shapes.empty();
        }

        public boolean isSource(FluidState state) {
            return true;
        }

        public int getAmount(FluidState state) {
            return 8;
        }

        public BlockState createLegacyBlock(FluidState state) {
            return Blocks.AIR.defaultBlockState();
        }

        public float getOwnHeight(FluidState state) {
            return 1.0f;
        }

        public float getHeight(FluidState state, BlockGetter level, BlockPos pos) {
            return 1.0f;
        }

        public Vec3 getFlow(BlockGetter level, BlockPos pos, FluidState state) {
            return Vec3.ZERO;
        }

        public int getSlopeFindDistance(LevelReader level) {
            return 0;
        }

        public int getDropOff(LevelReader level) {
            return 0;
        }

        public FluidType getFluidType() {
            return new FluidType(FluidType.Properties.create().descriptionId(this.descriptionId).canSwim(false).canDrown(false).canExtinguish(false).canConvertToSource(false).supportsBoating(false).canHydrate(false).canPushEntity(false).motionScale(0.0).fallDistanceModifier(0.0f).lightLevel(0).density(0).temperature(0).viscosity(0)){

                public Component getDescription() {
                    return Component.translatable((String)descriptionId);
                }
            };
        }
    }
}

