/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.item;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.compat.CuriosCompat;
import com.etka.nomadsshell.init.ModArmorMaterials;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.inventory.VirtualInventory;
import com.etka.nomadsshell.item.ShellTier;
import com.etka.nomadsshell.menu.VirtualShellMenu;
import com.etka.nomadsshell.util.RegistryHelper;
import com.etka.nomadsshell.util.WidgetDataHelper;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ShellItem
extends ArmorItem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ShellTier tier;

    public ShellItem(Item.Properties properties, ShellTier tier) {
        super(ModArmorMaterials.shell, ArmorItem.Type.CHESTPLATE, properties);
        this.tier = tier;
    }

    public ShellTier getTier() {
        return this.tier;
    }

    private boolean isPiglinProtectionEnabled(ItemStack stack, Player player) {
        if (player == null) {
            return false;
        }
        ItemStack shell = ShellItem.findWornshell(player);
        if (shell.isEmpty() || !shell.equals(stack)) {
            return false;
        }
        Set unlockedWidgets = (Set)shell.getOrDefault(ModDataComponents.UNLOCKED_WIDGETS.get(), Set.of());
        if (!unlockedWidgets.contains((Object)WidgetUnlockSystem.WidgetType.GUARDIAN)) {
            return false;
        }
        Map widgetTiers = (Map)shell.getOrDefault(ModDataComponents.WIDGET_TIERS.get(), Map.of());
        WidgetUnlockSystem.WidgetTier guardianTier = (WidgetUnlockSystem.WidgetTier)((Object)widgetTiers.get((Object)WidgetUnlockSystem.WidgetType.GUARDIAN));
        if (guardianTier == null || guardianTier.getLevel() < 7) {
            return false;
        }
        return WidgetDataHelper.isGuardianPiglinEnabled(player);
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        Player player;
        if (wearer instanceof Player && this.isPiglinProtectionEnabled(stack, player = (Player)wearer)) {
            return true;
        }
        return super.makesPiglinsNeutral(stack, wearer);
    }

    public int getWidth(ItemStack stack) {
        List dimensions = (List)stack.getOrDefault(ModDataComponents.shell_DIMENSIONS.get(), Arrays.asList(this.tier.getColumns(), this.tier.getRows()));
        return (Integer)dimensions.get(0);
    }

    public int getHeight(ItemStack stack) {
        List dimensions = (List)stack.getOrDefault(ModDataComponents.shell_DIMENSIONS.get(), Arrays.asList(this.tier.getColumns(), this.tier.getRows()));
        return (Integer)dimensions.get(1);
    }

    public int getshellSize(ItemStack stack) {
        return this.getWidth(stack) * this.getHeight(stack);
    }

    public void setDimensions(ItemStack stack, int width, int height) {
        stack.set(ModDataComponents.shell_DIMENSIONS.get(), Arrays.asList(width, height));
        if (!stack.has(ModDataComponents.VIRTUAL_INVENTORY.get())) {
            CompoundTag inventoryTag = new CompoundTag();
            inventoryTag.putInt("Width", width);
            inventoryTag.putInt("Height", height);
            inventoryTag.putBoolean("incomplete", true);
            stack.set(ModDataComponents.VIRTUAL_INVENTORY.get(), (Object)inventoryTag);
        }
    }

    public int getshellSize() {
        return this.tier.getTotalSlots();
    }

    public int getRows() {
        return this.tier.getRows();
    }

    public int getColumns() {
        return this.tier.getColumns();
    }

    public static ItemStack findWornshell(Player player) {
        return CuriosCompat.findWornShell(player);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack wornshell = ShellItem.findWornshell(player);
            if (!wornshell.isEmpty() && ItemStack.isSameItem((ItemStack)wornshell, (ItemStack)itemStack)) {
                ShellItem.openshell(serverPlayer, wornshell);
            } else {
                if (wornshell.isEmpty()) {
                    ItemStack chestSlot = player.getItemBySlot(EquipmentSlot.CHEST);
                    if (chestSlot.isEmpty()) {
                        player.setItemSlot(EquipmentSlot.CHEST, itemStack.copy());
                        player.setItemInHand(usedHand, ItemStack.EMPTY);
                        return InteractionResultHolder.success((Object)ItemStack.EMPTY);
                    }
                    player.setItemSlot(EquipmentSlot.CHEST, itemStack.copy());
                    player.setItemInHand(usedHand, chestSlot.copy());
                    return InteractionResultHolder.success((Object)chestSlot);
                }
                ItemStack chestSlot = player.getItemBySlot(EquipmentSlot.CHEST);
                player.setItemSlot(EquipmentSlot.CHEST, itemStack.copy());
                player.setItemInHand(usedHand, chestSlot.copy());
                return InteractionResultHolder.success((Object)chestSlot);
            }
        }
        return InteractionResultHolder.success((Object)itemStack);
    }

    public static void openshell(ServerPlayer player, final ItemStack shellStack) {
        if (shellStack.isEmpty() || !(shellStack.getItem() instanceof ShellItem)) {
            return;
        }
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                Item item = shellStack.getItem();
                if (item instanceof ShellItem) {
                    ShellItem ShellItem2 = (ShellItem)item;
                    int width = ShellItem2.getWidth(shellStack);
                    int height = ShellItem2.getHeight(shellStack);
                    return Component.translatable((String)("container.nomadsshell.shell." + ShellItem2.getTier().getName())).append(" (" + width + "\u00d7" + height + ")");
                }
                return Component.translatable((String)"container.nomadsshell.shell");
            }

            @Nullable
            public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
                return new VirtualShellMenu(containerId, playerInventory, shellStack);
            }
        });
    }

    public static VirtualInventory getVirtualInventory(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof ShellItem)) {
            return new VirtualInventory(9, 4);
        }
        ShellItem ShellItem2 = (ShellItem)item;
        CompoundTag inventoryTag = (CompoundTag)stack.get(ModDataComponents.VIRTUAL_INVENTORY.get());
        HolderLookup.Provider registryAccess = RegistryHelper.getRegistryAccess();
        if (inventoryTag != null && registryAccess != null) {
            if (!inventoryTag.contains("Width") && inventoryTag.contains("width")) {
                inventoryTag.putInt("Width", inventoryTag.getInt("width"));
            }
            if (!inventoryTag.contains("Height") && inventoryTag.contains("height")) {
                inventoryTag.putInt("Height", inventoryTag.getInt("height"));
            }
            if (inventoryTag.getInt("Width") <= 0 || inventoryTag.getInt("Height") <= 0) {
                inventoryTag.putInt("Width", ShellItem2.getWidth(stack));
                inventoryTag.putInt("Height", ShellItem2.getHeight(stack));
            }
            VirtualInventory inv = VirtualInventory.load(inventoryTag, registryAccess);
            if (inventoryTag.getBoolean("incomplete")) {
                CompoundTag full = inv.save(registryAccess);
                full.putBoolean("incomplete", false);
                stack.set(ModDataComponents.VIRTUAL_INVENTORY.get(), (Object)full);
            }
            return inv;
        }
        int width = ShellItem2.getWidth(stack);
        int height = ShellItem2.getHeight(stack);
        return new VirtualInventory(width, height);
    }

    public static void setVirtualInventory(ItemStack stack, VirtualInventory inventory) {
        HolderLookup.Provider registryAccess = RegistryHelper.getRegistryAccess();
        if (registryAccess != null) {
            CompoundTag inventoryTag = inventory.save(registryAccess);
            inventoryTag.putBoolean("incomplete", false);
            stack.set(ModDataComponents.VIRTUAL_INVENTORY.get(), (Object)inventoryTag);
        } else {
            CompoundTag inventoryTag = new CompoundTag();
            inventoryTag.putInt("Width", inventory.getWidth());
            inventoryTag.putInt("Height", inventory.getHeight());
            inventoryTag.putBoolean("incomplete", true);
            stack.set(ModDataComponents.VIRTUAL_INVENTORY.get(), (Object)inventoryTag);
        }
    }

    public static ItemContainerContents getshellContents(ItemStack stack) {
        VirtualInventory virtualInventory = ShellItem.getVirtualInventory(stack);
        if (virtualInventory != null) {
            NonNullList items = NonNullList.withSize((int)Math.min(virtualInventory.getWidth() * virtualInventory.getHeight(), 256), (Object)ItemStack.EMPTY);
            for (int i = 0; i < items.size(); ++i) {
                ItemStack item = virtualInventory.getItem(i);
                items.set(i, (Object)item);
            }
            return ItemContainerContents.fromItems((List)items);
        }
        return (ItemContainerContents)stack.getOrDefault(ModDataComponents.shell_CONTENTS.get(), (Object)ItemContainerContents.EMPTY);
    }

    public static void setshellContents(ItemStack stack, ItemContainerContents contents) {
        VirtualInventory virtualInventory = ShellItem.getVirtualInventory(stack);
        if (virtualInventory != null) {
            for (int i = 0; i < Math.min(contents.getSlots(), virtualInventory.getTotalSlots()); ++i) {
                ItemStack item = contents.getStackInSlot(i);
                virtualInventory.setItem(i, item);
            }
            ShellItem.setVirtualInventory(stack, virtualInventory);
        } else {
            stack.set(ModDataComponents.shell_CONTENTS.get(), (Object)contents);
        }
    }

    public void curioTick(Object slotContext, ItemStack stack) {
    }

    public void onEquip(Object slotContext, ItemStack previousStack, ItemStack stack) {
    }

    public void onUnequip(Object slotContext, ItemStack newStack, ItemStack stack) {
    }

    public boolean canEquip(Object slotContext, ItemStack stack) {
        if (CuriosCompat.isCuriosAvailable()) {
            try {
                String id;
                Method identifierMethod = slotContext.getClass().getMethod("identifier", new Class[0]);
                Object identifierObj = identifierMethod.invoke(slotContext, new Object[0]);
                if (identifierObj instanceof ResourceLocation) {
                    ResourceLocation rl = (ResourceLocation)identifierObj;
                    id = rl.getPath();
                } else {
                    id = identifierObj != null ? identifierObj.toString() : "";
                }
                return "back".equals(id) || "curios:back".equals(id);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public boolean canUnequip(Object slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquipFromUse(Object slotContext, ItemStack stack) {
        return this.canEquip(slotContext, stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        VirtualInventory inventory = ShellItem.getVirtualInventory(stack);
        if (!inventory.isEmpty()) {
            int width = this.getWidth(stack);
            int height = this.getHeight(stack);
            int totalSlots = width * height;
            int usedSlots = 0;
            for (int i = 0; i < inventory.getTotalSlots(); ++i) {
                if (inventory.getItem(i).isEmpty()) continue;
                ++usedSlots;
            }
            tooltipComponents.add((Component)Component.literal((String)Component.translatable((String)"nomadsshell.tooltip.used_format", (Object[])new Object[]{usedSlots, totalSlots}).getString()).withStyle(ChatFormatting.BLUE));
        }
        if (this.tier.hasNextTier()) {
            ShellTier nextTier = this.tier.getNextTier();
            String nextTierName = nextTier.getName().replace("_", " ");
            String capitalizedNextTier = nextTierName.substring(0, 1).toUpperCase() + nextTierName.substring(1);
            tooltipComponents.add((Component)Component.literal((String)("Next: " + capitalizedNextTier + " Shell")).withStyle(ChatFormatting.GREEN));
        } else {
            tooltipComponents.add((Component)Component.literal((String)Component.translatable((String)"nomadsshell.tooltip.max_tier_reached").getString()).withStyle(ChatFormatting.AQUA));
        }
    }
}

