/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.menu.IShellMenu;
import com.etka.nomadsshell.menu.VirtualAnvilMenu;
import com.etka.nomadsshell.network.AnvilSyncPacket;
import com.etka.nomadsshell.util.WidgetDataHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record AnvilSlotInteractionPacket(SlotType slotType, ActionType actionType, ItemStack carriedItem, String renameText) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AnvilSlotInteractionPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"anvil_slot_interaction"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AnvilSlotInteractionPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, AnvilSlotInteractionPacket>(){

        public AnvilSlotInteractionPacket decode(RegistryFriendlyByteBuf buffer) {
            SlotType slotType = (SlotType)buffer.readEnum(SlotType.class);
            ActionType actionType = (ActionType)buffer.readEnum(ActionType.class);
            boolean hasItem = buffer.readBoolean();
            ItemStack carriedItem = hasItem ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer) : ItemStack.EMPTY;
            String renameText = buffer.readUtf();
            return new AnvilSlotInteractionPacket(slotType, actionType, carriedItem, renameText);
        }

        public void encode(RegistryFriendlyByteBuf buffer, AnvilSlotInteractionPacket packet) {
            buffer.writeEnum((Enum)packet.slotType());
            buffer.writeEnum((Enum)packet.actionType());
            boolean hasItem = !packet.carriedItem().isEmpty();
            buffer.writeBoolean(hasItem);
            if (hasItem) {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)packet.carriedItem());
            }
            buffer.writeUtf(packet.renameText());
        }
    };
    private static final ConcurrentHashMap<String, ItemStack> anvilInputItems = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ItemStack> anvilMaterialItems = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ItemStack> anvilResultItems = new ConcurrentHashMap();

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(AnvilSlotInteractionPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            AbstractContainerMenu patt1$temp = player.containerMenu;
            if (!(patt1$temp instanceof IShellMenu)) {
                return;
            }
            IShellMenu ShellMenu2 = (IShellMenu)patt1$temp;
            ItemStack shellStack = ShellMenu2.getshellStack();
            if (shellStack.isEmpty()) {
                return;
            }
            ItemStack carried = player.containerMenu.getCarried();
            switch (packet.slotType().ordinal()) {
                case 0: {
                    if (packet.actionType() == ActionType.RENAME) {
                        AnvilSlotInteractionPacket.handleRenameTextUpdate(packet, (Player)player, shellStack);
                        break;
                    }
                    AnvilSlotInteractionPacket.handleInputSlot(packet, (Player)player, carried, shellStack);
                    break;
                }
                case 1: {
                    AnvilSlotInteractionPacket.handleMaterialSlot(packet, (Player)player, carried, shellStack);
                    break;
                }
                case 2: {
                    AnvilSlotInteractionPacket.handleResultSlot(packet, (Player)player, carried, shellStack);
                }
            }
        });
    }

    private static void handleRenameTextUpdate(AnvilSlotInteractionPacket packet, Player player, ItemStack shellStack) {
        WidgetDataHelper.setAnvilRenameText(player, packet.renameText());
        AnvilSlotInteractionPacket.updateAnvilResult(player, shellStack);
        AnvilSlotInteractionPacket.syncAnvilDataToClient((ServerPlayer)player);
    }

    private static void handleInputSlot(AnvilSlotInteractionPacket packet, Player player, ItemStack carried, ItemStack shellStack) {
        ItemStack currentInput = AnvilSlotInteractionPacket.getAnvilInputItem((ServerPlayer)player);
        switch (packet.actionType().ordinal()) {
            case 0: {
                if (carried.isEmpty()) break;
                if (currentInput.isEmpty()) {
                    AnvilSlotInteractionPacket.setAnvilInputItem((ServerPlayer)player, carried.copy());
                    player.containerMenu.setCarried(ItemStack.EMPTY);
                } else if (!ItemStack.isSameItemSameComponents((ItemStack)currentInput, (ItemStack)carried)) {
                    ItemStack previous = currentInput.copy();
                    AnvilSlotInteractionPacket.setAnvilInputItem((ServerPlayer)player, carried.copy());
                    player.containerMenu.setCarried(previous);
                } else {
                    int transferable = Math.min(carried.getCount(), currentInput.getMaxStackSize() - currentInput.getCount());
                    if (transferable > 0) {
                        currentInput.grow(transferable);
                        carried.shrink(transferable);
                        AnvilSlotInteractionPacket.setAnvilInputItem((ServerPlayer)player, currentInput);
                    }
                }
                AnvilSlotInteractionPacket.updateAnvilResult(player, shellStack);
                AnvilSlotInteractionPacket.syncAnvilDataToClient((ServerPlayer)player);
                break;
            }
            case 1: {
                if (carried.isEmpty()) break;
                if (currentInput.isEmpty()) {
                    ItemStack oneItem = carried.split(1);
                    AnvilSlotInteractionPacket.setAnvilInputItem((ServerPlayer)player, oneItem);
                    AnvilSlotInteractionPacket.updateAnvilResult(player, shellStack);
                    AnvilSlotInteractionPacket.syncAnvilDataToClient((ServerPlayer)player);
                    break;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)currentInput, (ItemStack)carried) || currentInput.getCount() >= currentInput.getMaxStackSize()) break;
                currentInput.grow(1);
                carried.shrink(1);
                AnvilSlotInteractionPacket.setAnvilInputItem((ServerPlayer)player, currentInput);
                AnvilSlotInteractionPacket.updateAnvilResult(player, shellStack);
                AnvilSlotInteractionPacket.syncAnvilDataToClient((ServerPlayer)player);
                break;
            }
            case 2: {
                if (currentInput.isEmpty() || !carried.isEmpty()) break;
                player.containerMenu.setCarried(currentInput.copy());
                AnvilSlotInteractionPacket.setAnvilInputItem((ServerPlayer)player, ItemStack.EMPTY);
                AnvilSlotInteractionPacket.updateAnvilResult(player, shellStack);
                AnvilSlotInteractionPacket.syncAnvilDataToClient((ServerPlayer)player);
                break;
            }
            case 3: {
                int halfCount;
                if (currentInput.isEmpty() || !carried.isEmpty() || (halfCount = currentInput.getCount() / 2) <= 0) break;
                ItemStack taken = currentInput.split(halfCount);
                player.containerMenu.setCarried(taken);
                AnvilSlotInteractionPacket.setAnvilInputItem((ServerPlayer)player, currentInput);
                AnvilSlotInteractionPacket.updateAnvilResult(player, shellStack);
                AnvilSlotInteractionPacket.syncAnvilDataToClient((ServerPlayer)player);
            }
        }
    }

    private static void handleMaterialSlot(AnvilSlotInteractionPacket packet, Player player, ItemStack carried, ItemStack shellStack) {
        ItemStack currentMaterial = AnvilSlotInteractionPacket.getAnvilMaterialItem((ServerPlayer)player);
        switch (packet.actionType().ordinal()) {
            case 0: {
                if (carried.isEmpty()) break;
                if (currentMaterial.isEmpty()) {
                    AnvilSlotInteractionPacket.setAnvilMaterialItem((ServerPlayer)player, carried.copy());
                    player.containerMenu.setCarried(ItemStack.EMPTY);
                } else if (!ItemStack.isSameItemSameComponents((ItemStack)currentMaterial, (ItemStack)carried)) {
                    ItemStack previous = currentMaterial.copy();
                    AnvilSlotInteractionPacket.setAnvilMaterialItem((ServerPlayer)player, carried.copy());
                    player.containerMenu.setCarried(previous);
                } else {
                    int transferable = Math.min(carried.getCount(), currentMaterial.getMaxStackSize() - currentMaterial.getCount());
                    if (transferable > 0) {
                        currentMaterial.grow(transferable);
                        carried.shrink(transferable);
                        AnvilSlotInteractionPacket.setAnvilMaterialItem((ServerPlayer)player, currentMaterial);
                    }
                }
                AnvilSlotInteractionPacket.updateAnvilResult(player, shellStack);
                AnvilSlotInteractionPacket.syncAnvilDataToClient((ServerPlayer)player);
                break;
            }
            case 1: {
                if (carried.isEmpty()) break;
                if (currentMaterial.isEmpty()) {
                    ItemStack oneItem = carried.split(1);
                    AnvilSlotInteractionPacket.setAnvilMaterialItem((ServerPlayer)player, oneItem);
                    AnvilSlotInteractionPacket.updateAnvilResult(player, shellStack);
                    AnvilSlotInteractionPacket.syncAnvilDataToClient((ServerPlayer)player);
                    break;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)currentMaterial, (ItemStack)carried) || currentMaterial.getCount() >= currentMaterial.getMaxStackSize()) break;
                currentMaterial.grow(1);
                carried.shrink(1);
                AnvilSlotInteractionPacket.setAnvilMaterialItem((ServerPlayer)player, currentMaterial);
                AnvilSlotInteractionPacket.updateAnvilResult(player, shellStack);
                AnvilSlotInteractionPacket.syncAnvilDataToClient((ServerPlayer)player);
                break;
            }
            case 2: {
                if (currentMaterial.isEmpty() || !carried.isEmpty()) break;
                player.containerMenu.setCarried(currentMaterial.copy());
                AnvilSlotInteractionPacket.setAnvilMaterialItem((ServerPlayer)player, ItemStack.EMPTY);
                AnvilSlotInteractionPacket.updateAnvilResult(player, shellStack);
                AnvilSlotInteractionPacket.syncAnvilDataToClient((ServerPlayer)player);
                break;
            }
            case 3: {
                int halfCount;
                if (currentMaterial.isEmpty() || !carried.isEmpty() || (halfCount = currentMaterial.getCount() / 2) <= 0) break;
                ItemStack taken = currentMaterial.split(halfCount);
                player.containerMenu.setCarried(taken);
                AnvilSlotInteractionPacket.setAnvilMaterialItem((ServerPlayer)player, currentMaterial);
                AnvilSlotInteractionPacket.updateAnvilResult(player, shellStack);
                AnvilSlotInteractionPacket.syncAnvilDataToClient((ServerPlayer)player);
            }
        }
    }

    private static void handleResultSlot(AnvilSlotInteractionPacket packet, Player player, ItemStack carried, ItemStack shellStack) {
        ItemStack currentResult = AnvilSlotInteractionPacket.getAnvilResultItem((ServerPlayer)player);
        switch (packet.actionType().ordinal()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (currentResult.isEmpty() || !carried.isEmpty()) break;
                player.containerMenu.setCarried(currentResult.copy());
                AnvilSlotInteractionPacket.setAnvilResultItem((ServerPlayer)player, ItemStack.EMPTY);
                ItemStack input = AnvilSlotInteractionPacket.getAnvilInputItem((ServerPlayer)player);
                ItemStack material = AnvilSlotInteractionPacket.getAnvilMaterialItem((ServerPlayer)player);
                if (!input.isEmpty()) {
                    input.shrink(1);
                    if (input.isEmpty()) {
                        AnvilSlotInteractionPacket.setAnvilInputItem((ServerPlayer)player, ItemStack.EMPTY);
                    } else {
                        AnvilSlotInteractionPacket.setAnvilInputItem((ServerPlayer)player, input);
                    }
                }
                if (!material.isEmpty()) {
                    material.shrink(1);
                    if (material.isEmpty()) {
                        AnvilSlotInteractionPacket.setAnvilMaterialItem((ServerPlayer)player, ItemStack.EMPTY);
                    } else {
                        AnvilSlotInteractionPacket.setAnvilMaterialItem((ServerPlayer)player, material);
                    }
                }
                WidgetDataHelper.setAnvilRepairCost(player, 0);
                WidgetDataHelper.setAnvilRenameText(player, "");
                AnvilSlotInteractionPacket.updateAnvilResult(player, shellStack);
                AnvilSlotInteractionPacket.syncAnvilDataToClient((ServerPlayer)player);
            }
        }
    }

    private static void updateAnvilResult(Player player, ItemStack shellStack) {
        ItemStack input = AnvilSlotInteractionPacket.getAnvilInputItem((ServerPlayer)player);
        ItemStack material = AnvilSlotInteractionPacket.getAnvilMaterialItem((ServerPlayer)player);
        String renameText = WidgetDataHelper.getAnvilRenameText(player);
        if (input.isEmpty()) {
            AnvilSlotInteractionPacket.setAnvilResultItem((ServerPlayer)player, ItemStack.EMPTY);
            WidgetDataHelper.setAnvilRepairCost(player, 0);
            return;
        }
        ItemStack result = AnvilSlotInteractionPacket.calculateAnvilResultUsingVanilla((ServerPlayer)player, input, material, renameText);
        AnvilSlotInteractionPacket.setAnvilResultItem((ServerPlayer)player, result);
        int cost = AnvilSlotInteractionPacket.getVanillaRepairCost((ServerPlayer)player, input, material, renameText);
        WidgetDataHelper.setAnvilRepairCost(player, cost);
        AnvilSlotInteractionPacket.syncAnvilDataToClient((ServerPlayer)player);
    }

    private static ItemStack calculateAnvilResultUsingVanilla(ServerPlayer player, ItemStack input, ItemStack material, String renameText) {
        VirtualAnvilMenu virtualAnvil = new VirtualAnvilMenu(0, player.getInventory(), player);
        virtualAnvil.setInputItem(input);
        virtualAnvil.setMaterialItem(material);
        virtualAnvil.setRenameText(renameText);
        virtualAnvil.updateResult();
        return virtualAnvil.getResultItem();
    }

    private static int getVanillaRepairCost(ServerPlayer player, ItemStack input, ItemStack material, String renameText) {
        VirtualAnvilMenu virtualAnvil = new VirtualAnvilMenu(0, player.getInventory(), player);
        virtualAnvil.setInputItem(input);
        virtualAnvil.setMaterialItem(material);
        virtualAnvil.setRenameText(renameText);
        virtualAnvil.updateResult();
        return virtualAnvil.getRepairCost();
    }

    @Deprecated
    private static ItemStack calculateAnvilResult(ItemStack input, ItemStack material, String renameText) {
        if (input.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack result = input.copy();
        if (!material.isEmpty()) {
            if (input.isRepairable() && material.is(input.getItem())) {
                int damage = input.getDamageValue();
                int maxDamage = input.getMaxDamage();
                if (damage > 0) {
                    int repairAmount = Math.min(damage, maxDamage / 4);
                    result.setDamageValue(Math.max(0, damage - repairAmount));
                }
            } else if (input.is(Items.ENCHANTED_BOOK) && material.is(Items.ENCHANTED_BOOK)) {
                result = AnvilSlotInteractionPacket.combineEnchantedBooks(input, material);
            } else if (material.is(Items.ENCHANTED_BOOK)) {
                result = AnvilSlotInteractionPacket.applyEnchantmentsFromBook(input, material);
            }
        }
        return result;
    }

    @Deprecated
    private static int calculateRepairCost(ItemStack input, ItemStack material) {
        if (input.isEmpty()) {
            return 0;
        }
        int cost = 0;
        if (!input.getHoverName().getString().equals(input.getItem().getDescription().getString())) {
            ++cost;
        }
        if (!material.isEmpty()) {
            if (input.isRepairable() && material.is(input.getItem())) {
                cost += 2;
            } else if (input.is(Items.ENCHANTED_BOOK) && material.is(Items.ENCHANTED_BOOK)) {
                ++cost;
            } else if (input.isEnchanted() && material.is(Items.ENCHANTED_BOOK)) {
                ++cost;
            }
        }
        return cost;
    }

    private static ItemStack combineEnchantedBooks(ItemStack book1, ItemStack book2) {
        ItemStack result = book1.copy();
        ItemEnchantments enchantments1 = book1.getEnchantments();
        ItemEnchantments enchantments2 = book2.getEnchantments();
        for (Object2IntMap.Entry entry : enchantments2.entrySet()) {
            Holder enchantment = (Holder)entry.getKey();
            Integer level = entry.getValue();
            boolean exists = false;
            int existingLevel = 0;
            for (Object2IntMap.Entry existingEntry : enchantments1.entrySet()) {
                if (!((Holder)existingEntry.getKey()).equals((Object)enchantment)) continue;
                exists = true;
                existingLevel = existingEntry.getValue();
                break;
            }
            if (exists) {
                if (level <= existingLevel) continue;
                result.enchant(enchantment, level.intValue());
                continue;
            }
            result.enchant(enchantment, level.intValue());
        }
        return result;
    }

    private static ItemStack applyEnchantmentsFromBook(ItemStack item, ItemStack book) {
        ItemStack result = item.copy();
        ItemEnchantments bookEnchantments = book.getEnchantments();
        ItemEnchantments storedEnchantments = (ItemEnchantments)book.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments oldEnchantments = (ItemEnchantments)book.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments enchantmentsToApply = storedEnchantments.size() > 0 ? storedEnchantments : (oldEnchantments.size() > 0 ? oldEnchantments : bookEnchantments);
        for (Object2IntMap.Entry entry : enchantmentsToApply.entrySet()) {
            Holder enchantment = (Holder)entry.getKey();
            Integer n = entry.getValue();
        }
        return result;
    }

    private static String getPlayerKey(ServerPlayer player) {
        return player.getUUID().toString();
    }

    public static ItemStack getAnvilInputItem(ServerPlayer player) {
        String key = AnvilSlotInteractionPacket.getPlayerKey(player);
        ItemStack cached = anvilInputItems.get(key);
        if (cached != null) {
            return cached;
        }
        ItemStack persisted = WidgetDataHelper.getAnvilInputItem((Player)player);
        if (!persisted.isEmpty()) {
            anvilInputItems.put(key, persisted.copy());
        }
        return persisted;
    }

    public static void setAnvilInputItem(ServerPlayer player, ItemStack item) {
        String key = AnvilSlotInteractionPacket.getPlayerKey(player);
        if (item.isEmpty()) {
            anvilInputItems.remove(key);
        } else {
            anvilInputItems.put(key, item.copy());
        }
        WidgetDataHelper.setAnvilInputItem((Player)player, item);
    }

    public static ItemStack getAnvilMaterialItem(ServerPlayer player) {
        String key = AnvilSlotInteractionPacket.getPlayerKey(player);
        ItemStack cached = anvilMaterialItems.get(key);
        if (cached != null) {
            return cached;
        }
        ItemStack persisted = WidgetDataHelper.getAnvilMaterialItem((Player)player);
        if (!persisted.isEmpty()) {
            anvilMaterialItems.put(key, persisted.copy());
        }
        return persisted;
    }

    public static void setAnvilMaterialItem(ServerPlayer player, ItemStack item) {
        String key = AnvilSlotInteractionPacket.getPlayerKey(player);
        if (item.isEmpty()) {
            anvilMaterialItems.remove(key);
        } else {
            anvilMaterialItems.put(key, item.copy());
        }
        WidgetDataHelper.setAnvilMaterialItem((Player)player, item);
    }

    public static ItemStack getAnvilResultItem(ServerPlayer player) {
        String key = AnvilSlotInteractionPacket.getPlayerKey(player);
        ItemStack cached = anvilResultItems.get(key);
        if (cached != null) {
            return cached;
        }
        ItemStack persisted = WidgetDataHelper.getAnvilResultItem((Player)player);
        if (!persisted.isEmpty()) {
            anvilResultItems.put(key, persisted.copy());
        }
        return persisted;
    }

    public static void setAnvilResultItem(ServerPlayer player, ItemStack item) {
        String key = AnvilSlotInteractionPacket.getPlayerKey(player);
        if (item.isEmpty()) {
            anvilResultItems.remove(key);
        } else {
            anvilResultItems.put(key, item.copy());
        }
        WidgetDataHelper.setAnvilResultItem((Player)player, item);
    }

    private static void syncAnvilDataToClient(ServerPlayer player) {
        ItemStack input = AnvilSlotInteractionPacket.getAnvilInputItem(player);
        ItemStack material = AnvilSlotInteractionPacket.getAnvilMaterialItem(player);
        ItemStack result = AnvilSlotInteractionPacket.getAnvilResultItem(player);
        int repairCost = WidgetDataHelper.getAnvilRepairCost((Player)player);
        String renameText = WidgetDataHelper.getAnvilRenameText((Player)player);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new AnvilSyncPacket(input, material, result, repairCost, renameText), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static enum SlotType {
        INPUT,
        MATERIAL,
        RESULT;

    }

    public static enum ActionType {
        PUT_ITEM,
        PUT_ONE,
        TAKE_ITEM,
        TAKE_HALF,
        RENAME;

    }
}

