/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.util.ItemStackData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CraftingTableSyncPacket(List<ItemStack> grid, ItemStack result) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CraftingTableSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"crafting_table_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CraftingTableSyncPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, CraftingTableSyncPacket>(){

        public CraftingTableSyncPacket decode(RegistryFriendlyByteBuf buffer) {
            int size = buffer.readVarInt();
            ArrayList<ItemStack> grid = new ArrayList<ItemStack>(size);
            for (int i = 0; i < size; ++i) {
                boolean has = buffer.readBoolean();
                ItemStack s = has ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer) : ItemStack.EMPTY;
                grid.add(s);
            }
            boolean hasResult = buffer.readBoolean();
            ItemStack result = hasResult ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer) : ItemStack.EMPTY;
            return new CraftingTableSyncPacket(grid, result);
        }

        public void encode(RegistryFriendlyByteBuf buffer, CraftingTableSyncPacket packet) {
            List<ItemStack> grid = packet.grid();
            buffer.writeVarInt(grid.size());
            for (ItemStack s : grid) {
                boolean has = s != null && !s.isEmpty();
                buffer.writeBoolean(has);
                if (!has) continue;
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)s);
            }
            boolean hasResult = packet.result() != null && !packet.result().isEmpty();
            buffer.writeBoolean(hasResult);
            if (hasResult) {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)packet.result());
            }
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CraftingTableSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            ItemStack worn = ShellItem.findWornshell((Player)mc.player);
            if (worn.isEmpty()) {
                return;
            }
            ArrayList<ItemStack> grid = new ArrayList<ItemStack>(packet.grid());
            while (grid.size() < 9) {
                grid.add(ItemStack.EMPTY);
            }
            ArrayList<ItemStackData> gridData = new ArrayList<ItemStackData>(9);
            for (int i = 0; i < 9; ++i) {
                ItemStack s = (ItemStack)grid.get(i);
                gridData.add(s == null || s.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(s));
            }
            worn.set(ModDataComponents.CRAFTING_TABLE_GRID.get(), gridData);
            ItemStack result = packet.result();
            worn.set(ModDataComponents.CRAFTING_TABLE_RESULT.get(), (Object)(result == null || result.isEmpty() ? ItemStackData.EMPTY : ItemStackData.of(result)));
        });
    }
}

