/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.util.FluidStackData;
import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record DripstoneSyncPacket(int cauldronCount, FluidStackData[] sources, int[] amounts, ItemStack[] bottomItems, int[] targetContainers) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DripstoneSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"dripstone_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, DripstoneSyncPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, DripstoneSyncPacket>(){

        public DripstoneSyncPacket decode(RegistryFriendlyByteBuf buf) {
            int count = buf.readVarInt();
            int n = Math.min(5, Math.max(0, count));
            FluidStackData[] sources = new FluidStackData[5];
            for (int i = 0; i < 5; ++i) {
                boolean has = buf.readBoolean();
                sources[i] = has ? (FluidStackData)FluidStackData.STREAM_CODEC.decode((Object)buf) : FluidStackData.EMPTY;
            }
            int[] amounts = new int[5];
            for (int i = 0; i < 5; ++i) {
                amounts[i] = buf.readVarInt();
            }
            ItemStack[] bottom = new ItemStack[5];
            for (int i = 0; i < 5; ++i) {
                boolean has = buf.readBoolean();
                bottom[i] = has ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf) : ItemStack.EMPTY;
            }
            int[] targets = new int[5];
            for (int i = 0; i < 5; ++i) {
                targets[i] = buf.readVarInt();
            }
            return new DripstoneSyncPacket(n, sources, amounts, bottom, targets);
        }

        public void encode(RegistryFriendlyByteBuf buf, DripstoneSyncPacket pkt) {
            boolean has;
            int i;
            buf.writeVarInt(pkt.cauldronCount());
            for (i = 0; i < 5; ++i) {
                FluidStackData f = pkt.sources()[i] == null ? FluidStackData.EMPTY : pkt.sources()[i];
                has = !f.isEmpty();
                buf.writeBoolean(has);
                if (!has) continue;
                FluidStackData.STREAM_CODEC.encode((Object)buf, (Object)f);
            }
            for (i = 0; i < 5; ++i) {
                int v = pkt.amounts() != null && i < pkt.amounts().length ? pkt.amounts()[i] : 0;
                buf.writeVarInt(v);
            }
            for (i = 0; i < 5; ++i) {
                ItemStack s = pkt.bottomItems() != null && i < pkt.bottomItems().length ? pkt.bottomItems()[i] : ItemStack.EMPTY;
                has = s != null && !s.isEmpty();
                buf.writeBoolean(has);
                if (!has) continue;
                ItemStack.STREAM_CODEC.encode((Object)buf, (Object)s);
            }
            for (i = 0; i < 5; ++i) {
                int v = pkt.targetContainers() != null && i < pkt.targetContainers().length ? pkt.targetContainers()[i] : 0;
                buf.writeVarInt(v);
            }
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(DripstoneSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            ItemStack worn = ShellItem.findWornshell((Player)mc.player);
            if (worn.isEmpty()) {
                return;
            }
            worn.set(ModDataComponents.DRIP_CAULDRON_COUNT.get(), (Object)Math.max(0, Math.min(5, packet.cauldronCount())));
            for (int i = 0; i < 5; ++i) {
                FluidStackData src = packet.sources()[i] == null ? FluidStackData.EMPTY : packet.sources()[i];
                WidgetDataHelper.setDripSourceFluidAt((Player)mc.player, i, src);
                int mb = packet.amounts() != null && i < packet.amounts().length ? packet.amounts()[i] : 0;
                WidgetDataHelper.setDripCauldronMbAt((Player)mc.player, i, mb);
                ItemStack bottom = packet.bottomItems() != null && i < packet.bottomItems().length ? packet.bottomItems()[i] : ItemStack.EMPTY;
                WidgetDataHelper.setDripBottomItemAt((Player)mc.player, i, bottom == null ? ItemStack.EMPTY : bottom);
                int tgt = packet.targetContainers() != null && i < packet.targetContainers().length ? packet.targetContainers()[i] : 0;
                WidgetDataHelper.setDripTargetContainerAt((Player)mc.player, i, tgt);
            }
        });
    }

    public static DripstoneSyncPacket fromServerPlayer(ServerPlayer sp) {
        int count = WidgetDataHelper.getDripCauldronCount((Player)sp);
        FluidStackData[] sources = new FluidStackData[5];
        int[] amounts = new int[5];
        ItemStack[] bottoms = new ItemStack[5];
        int[] targets = new int[5];
        for (int i = 0; i < 5; ++i) {
            sources[i] = WidgetDataHelper.getDripSourceFluidAt((Player)sp, i);
            amounts[i] = WidgetDataHelper.getDripCauldronMbAt((Player)sp, i);
            bottoms[i] = WidgetDataHelper.getDripBottomItemAt((Player)sp, i);
            targets[i] = WidgetDataHelper.getDripTargetContainerAt((Player)sp, i);
        }
        return new DripstoneSyncPacket(count, sources, amounts, bottoms, targets);
    }

    public static void sendTo(ServerPlayer sp) {
        PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)DripstoneSyncPacket.fromServerPlayer(sp), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

