/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.util.FluidStackData;
import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record FluidTankSyncPacket(FluidStackData[] fluids, int[] capacities, PotionContents[] potionContents, ItemStack[] potionItems) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FluidTankSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"fluid_tank_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidTankSyncPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, FluidTankSyncPacket>(){

        public FluidTankSyncPacket decode(RegistryFriendlyByteBuf buf) {
            FluidStackData[] fluids = new FluidStackData[5];
            for (int i = 0; i < 5; ++i) {
                fluids[i] = (FluidStackData)FluidStackData.STREAM_CODEC.decode((Object)buf);
            }
            int[] capacities = new int[5];
            for (int i = 0; i < 5; ++i) {
                capacities[i] = buf.readVarInt();
            }
            PotionContents[] contents = new PotionContents[5];
            for (int i = 0; i < 5; ++i) {
                contents[i] = (PotionContents)PotionContents.STREAM_CODEC.decode((Object)buf);
            }
            ItemStack[] items = new ItemStack[5];
            for (int i = 0; i < 5; ++i) {
                boolean has = buf.readBoolean();
                items[i] = has ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf) : ItemStack.EMPTY;
            }
            return new FluidTankSyncPacket(fluids, capacities, contents, items);
        }

        public void encode(RegistryFriendlyByteBuf buf, FluidTankSyncPacket pkt) {
            int i;
            for (i = 0; i < 5; ++i) {
                FluidStackData f = pkt.fluids()[i] == null ? FluidStackData.EMPTY : pkt.fluids()[i];
                FluidStackData.STREAM_CODEC.encode((Object)buf, (Object)f);
            }
            for (i = 0; i < 5; ++i) {
                int cap = pkt.capacities() != null && i < pkt.capacities().length ? pkt.capacities()[i] : 0;
                buf.writeVarInt(cap);
            }
            for (i = 0; i < 5; ++i) {
                PotionContents pc = pkt.potionContents() != null && i < pkt.potionContents().length ? pkt.potionContents()[i] : PotionContents.EMPTY;
                PotionContents.STREAM_CODEC.encode((Object)buf, (Object)pc);
            }
            for (i = 0; i < 5; ++i) {
                ItemStack it = pkt.potionItems() != null && i < pkt.potionItems().length ? pkt.potionItems()[i] : ItemStack.EMPTY;
                boolean has = it != null && !it.isEmpty();
                buf.writeBoolean(has);
                if (!has) continue;
                ItemStack.STREAM_CODEC.encode((Object)buf, (Object)it);
            }
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(FluidTankSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            if (ShellItem.findWornshell((Player)mc.player).isEmpty()) {
                return;
            }
            for (int i = 1; i <= 5; ++i) {
                int cap = packet.capacities() != null && i - 1 < packet.capacities().length ? packet.capacities()[i - 1] : 0;
                WidgetDataHelper.setTankCapacity((Player)mc.player, i, cap);
                FluidStackData fs = packet.fluids() != null && i - 1 < packet.fluids().length ? packet.fluids()[i - 1] : FluidStackData.EMPTY;
                WidgetDataHelper.setTankFluid((Player)mc.player, i, fs);
                PotionContents pc = packet.potionContents() != null && i - 1 < packet.potionContents().length ? packet.potionContents()[i - 1] : PotionContents.EMPTY;
                WidgetDataHelper.setTankPotionContents((Player)mc.player, i, pc);
                ItemStack it = packet.potionItems() != null && i - 1 < packet.potionItems().length ? packet.potionItems()[i - 1] : ItemStack.EMPTY;
                WidgetDataHelper.setTankPotionItem((Player)mc.player, i, it);
            }
        });
    }

    public static FluidTankSyncPacket fromServerPlayer(ServerPlayer sp) {
        FluidStackData[] fluids = new FluidStackData[5];
        int[] caps = new int[5];
        PotionContents[] contents = new PotionContents[5];
        ItemStack[] items = new ItemStack[5];
        for (int i = 1; i <= 5; ++i) {
            fluids[i - 1] = WidgetDataHelper.getTankFluid((Player)sp, i);
            caps[i - 1] = WidgetDataHelper.getTankCapacity((Player)sp, i);
            contents[i - 1] = WidgetDataHelper.getTankPotionContents((Player)sp, i);
            items[i - 1] = WidgetDataHelper.getTankPotionItem((Player)sp, i);
        }
        return new FluidTankSyncPacket(fluids, caps, contents, items);
    }

    public static void sendTo(ServerPlayer sp) {
        PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)FluidTankSyncPacket.fromServerPlayer(sp), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

