/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.network.CraftingTableSyncPacket;
import com.etka.nomadsshell.util.InventoryUtils;
import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MoveItemToShellPacket(WidgetType widgetType, SlotType slotType, int slotIndex) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MoveItemToShellPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"move_item_to_shell"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MoveItemToShellPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, MoveItemToShellPacket>(){

        public MoveItemToShellPacket decode(RegistryFriendlyByteBuf buffer) {
            WidgetType widgetType = (WidgetType)buffer.readEnum(WidgetType.class);
            SlotType slotType = (SlotType)buffer.readEnum(SlotType.class);
            int slotIndex = buffer.readVarInt();
            return new MoveItemToShellPacket(widgetType, slotType, slotIndex);
        }

        public void encode(RegistryFriendlyByteBuf buffer, MoveItemToShellPacket packet) {
            buffer.writeEnum((Enum)packet.widgetType);
            buffer.writeEnum((Enum)packet.slotType);
            buffer.writeVarInt(packet.slotIndex);
        }
    };

    public MoveItemToShellPacket(WidgetType widgetType, SlotType slotType) {
        this(widgetType, slotType, 0);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(MoveItemToShellPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                MoveItemToShellPacket.handleMoveToshell(serverPlayer, packet.widgetType, packet.slotType, packet.slotIndex);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleMoveToshell(ServerPlayer player, WidgetType widgetType, SlotType slotType, int slotIndex) {
        block37: {
            ItemStack itemToMove = ItemStack.EMPTY;
            switch (widgetType.ordinal()) {
                case 0: {
                    switch (slotType.ordinal()) {
                        case 0: {
                            itemToMove = WidgetDataHelper.getFurnaceInputItem((Player)player);
                            if (itemToMove.isEmpty()) return;
                            ItemStack remaining = InventoryUtils.addItemToShell((Player)player, itemToMove);
                            if (remaining.getCount() >= itemToMove.getCount()) return;
                            WidgetDataHelper.setFurnaceInputItem((Player)player, remaining);
                            MoveItemToShellPacket.playMoveSound(player);
                            return;
                        }
                        case 1: {
                            itemToMove = WidgetDataHelper.getFurnaceFuelItem((Player)player);
                            if (itemToMove.isEmpty()) return;
                            ItemStack remaining = InventoryUtils.addItemToShell((Player)player, itemToMove);
                            if (remaining.getCount() >= itemToMove.getCount()) return;
                            WidgetDataHelper.setFurnaceFuelItem((Player)player, remaining);
                            MoveItemToShellPacket.playMoveSound(player);
                            return;
                        }
                        case 2: {
                            ItemStack remaining;
                            itemToMove = WidgetDataHelper.getFurnaceOutputItem((Player)player);
                            if (itemToMove.isEmpty() || (remaining = InventoryUtils.addItemToShell((Player)player, itemToMove)).getCount() >= itemToMove.getCount()) return;
                            WidgetDataHelper.setFurnaceOutputItem((Player)player, remaining);
                            MoveItemToShellPacket.playMoveSound(player);
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 1: {
                    switch (slotType.ordinal()) {
                        case 3: {
                            ItemStack remaining;
                            itemToMove = WidgetDataHelper.getTrashBinItem((Player)player);
                            if (itemToMove.isEmpty() || (remaining = InventoryUtils.addItemToShell((Player)player, itemToMove)).getCount() >= itemToMove.getCount()) return;
                            WidgetDataHelper.setTrashBinItem((Player)player, remaining);
                            MoveItemToShellPacket.playMoveSound(player);
                        }
                    }
                    return;
                }
                case 2: {
                    switch (slotType.ordinal()) {
                        case 4: {
                            ItemStack remaining;
                            ItemStack gridItem;
                            if (slotIndex < 0 || slotIndex >= 9) return;
                            List<ItemStack> grid = WidgetDataHelper.getCraftingTableGrid((Player)player);
                            if (slotIndex >= grid.size() || (gridItem = grid.get(slotIndex)).isEmpty() || (remaining = InventoryUtils.addItemToShell((Player)player, gridItem)).getCount() >= gridItem.getCount()) return;
                            WidgetDataHelper.setCraftingTableGridSlot((Player)player, slotIndex, remaining);
                            MoveItemToShellPacket.updateCraftingResult(player);
                            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new CraftingTableSyncPacket(WidgetDataHelper.getCraftingTableGrid((Player)player), WidgetDataHelper.getCraftingTableResult((Player)player)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            MoveItemToShellPacket.playMoveSound(player);
                            return;
                        }
                        case 5: {
                            itemToMove = WidgetDataHelper.getCraftingTableResult((Player)player);
                            if (itemToMove.isEmpty()) return;
                            ItemStack remaining = InventoryUtils.addItemToShell((Player)player, itemToMove);
                            if (remaining.getCount() >= itemToMove.getCount()) return;
                            int moved = itemToMove.getCount() - remaining.getCount();
                            if (moved >= itemToMove.getCount()) {
                                MoveItemToShellPacket.consumeCraftingIngredients(player);
                                WidgetDataHelper.setCraftingTableResult((Player)player, ItemStack.EMPTY);
                                MoveItemToShellPacket.updateCraftingResult(player);
                                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new CraftingTableSyncPacket(WidgetDataHelper.getCraftingTableGrid((Player)player), WidgetDataHelper.getCraftingTableResult((Player)player)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            } else {
                                ItemStack newResult = itemToMove.copy();
                                newResult.shrink(moved);
                                WidgetDataHelper.setCraftingTableResult((Player)player, newResult);
                                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new CraftingTableSyncPacket(WidgetDataHelper.getCraftingTableGrid((Player)player), WidgetDataHelper.getCraftingTableResult((Player)player)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            }
                            MoveItemToShellPacket.playMoveSound(player);
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 3: {
                    switch (slotType.ordinal()) {
                        case 0: {
                            ItemStack remaining;
                            itemToMove = WidgetDataHelper.getAnvilInputItem((Player)player);
                            if (itemToMove.isEmpty() || (remaining = InventoryUtils.addItemToShell((Player)player, itemToMove)).getCount() >= itemToMove.getCount()) return;
                            WidgetDataHelper.setAnvilInputItem((Player)player, remaining);
                            MoveItemToShellPacket.playMoveSound(player);
                            break block37;
                        }
                        case 6: {
                            ItemStack remaining;
                            itemToMove = WidgetDataHelper.getAnvilMaterialItem((Player)player);
                            if (itemToMove.isEmpty() || (remaining = InventoryUtils.addItemToShell((Player)player, itemToMove)).getCount() >= itemToMove.getCount()) return;
                            WidgetDataHelper.setAnvilMaterialItem((Player)player, remaining);
                            MoveItemToShellPacket.playMoveSound(player);
                            break block37;
                        }
                        case 2: {
                            ItemStack remaining;
                            itemToMove = WidgetDataHelper.getAnvilResultItem((Player)player);
                            if (itemToMove.isEmpty() || (remaining = InventoryUtils.addItemToShell((Player)player, itemToMove)).getCount() >= itemToMove.getCount()) return;
                            ItemStack input = WidgetDataHelper.getAnvilInputItem((Player)player);
                            ItemStack material = WidgetDataHelper.getAnvilMaterialItem((Player)player);
                            if (!input.isEmpty()) {
                                input.shrink(1);
                                if (input.isEmpty()) {
                                    WidgetDataHelper.setAnvilInputItem((Player)player, ItemStack.EMPTY);
                                } else {
                                    WidgetDataHelper.setAnvilInputItem((Player)player, input);
                                }
                            }
                            if (!material.isEmpty()) {
                                material.shrink(1);
                                if (material.isEmpty()) {
                                    WidgetDataHelper.setAnvilMaterialItem((Player)player, ItemStack.EMPTY);
                                } else {
                                    WidgetDataHelper.setAnvilMaterialItem((Player)player, material);
                                }
                            }
                            WidgetDataHelper.setAnvilResultItem((Player)player, remaining);
                            MoveItemToShellPacket.playMoveSound(player);
                        }
                    }
                }
            }
        }
    }

    private static void playMoveSound(ServerPlayer player) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, 1.0f + (player.level().random.nextFloat() - 0.5f) * 0.4f);
    }

    private static void consumeCraftingIngredients(ServerPlayer player) {
        List<ItemStack> grid = WidgetDataHelper.getCraftingTableGrid((Player)player);
        ArrayList<ItemStack> newGrid = new ArrayList<ItemStack>();
        for (ItemStack stack : grid) {
            if (!stack.isEmpty()) {
                ItemStack newStack = stack.copy();
                newStack.shrink(1);
                newGrid.add(newStack.isEmpty() ? ItemStack.EMPTY : newStack);
                continue;
            }
            newGrid.add(ItemStack.EMPTY);
        }
        WidgetDataHelper.setCraftingTableGrid((Player)player, newGrid);
    }

    private static void updateCraftingResult(ServerPlayer player) {
        CraftingInput recipeInput;
        List<ItemStack> grid = WidgetDataHelper.getCraftingTableGrid((Player)player);
        RecipeManager recipeManager = player.server.getRecipeManager();
        RecipeHolder recipe = recipeManager.getRecipeFor(RecipeType.CRAFTING, (RecipeInput)(recipeInput = CraftingInput.of((int)3, (int)3, IntStream.range(0, 9).mapToObj(i -> i < grid.size() ? (ItemStack)grid.get(i) : ItemStack.EMPTY).toList())), player.level()).orElse(null);
        ItemStack result = recipe != null ? ((CraftingRecipe)recipe.value()).assemble((RecipeInput)recipeInput, (HolderLookup.Provider)player.level().registryAccess()) : ItemStack.EMPTY;
        WidgetDataHelper.setCraftingTableResult((Player)player, result);
    }

    public static enum WidgetType {
        FURNACE,
        TRASH_BIN,
        CRAFTING_TABLE,
        ANVIL;

    }

    public static enum SlotType {
        INPUT,
        FUEL,
        OUTPUT,
        HELD_ITEM,
        GRID,
        RESULT,
        MATERIAL;

    }
}

