/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.util.InventoryUtils;
import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PurchaseAutoCrafterPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PurchaseAutoCrafterPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"purchase_auto_crafter"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PurchaseAutoCrafterPacket> STREAM_CODEC = StreamCodec.unit((Object)new PurchaseAutoCrafterPacket());

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(PurchaseAutoCrafterPacket pkt, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            boolean isCreative;
            boolean craftingOk;
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)patt0$temp;
            ItemStack shell = ShellItem.findWornshell((Player)sp);
            if (shell.isEmpty()) {
                return;
            }
            boolean bl = craftingOk = WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE, shell) && WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.CRAFTING_TABLE, shell) == WidgetUnlockSystem.WidgetTier.TIER_II;
            if (!craftingOk) {
                return;
            }
            if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.TRASH_BIN, shell)) {
                return;
            }
            if (((Boolean)shell.getOrDefault(ModDataComponents.AUTO_CRAFTER_UNLOCKED.get(), (Object)false)).booleanValue()) {
                return;
            }
            boolean consumed = isCreative = sp.getAbilities().instabuild;
            if (!isCreative) {
                int have = InventoryUtils.countItemAcrossInventoryAndshell((Player)sp, Items.IRON_INGOT);
                if (have < 1) {
                    return;
                }
                consumed = InventoryUtils.consumeItemAcrossInventoryAndshell((Player)sp, Items.IRON_INGOT, 1);
                if (!consumed) {
                    return;
                }
            }
            shell.set(ModDataComponents.AUTO_CRAFTER_UNLOCKED.get(), (Object)true);
            shell.set(ModDataComponents.AUTO_CRAFTER_ENABLED.get(), (Object)false);
            WidgetDataHelper.clearAutoCrafterRecipes((Player)sp);
        });
    }
}

