/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RetrieveFromTrashPacket(ItemStack retrievedItem, int amountTaken) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RetrieveFromTrashPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"retrieve_from_trash"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RetrieveFromTrashPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, RetrieveFromTrashPacket::retrievedItem, (StreamCodec)ByteBufCodecs.INT, RetrieveFromTrashPacket::amountTaken, RetrieveFromTrashPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(RetrieveFromTrashPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                int currentCount;
                int maxStackSize;
                int actualAmountTaken;
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                ItemStack currentCarried = serverPlayer.containerMenu.getCarried();
                ItemStack currentTrashItem = WidgetDataHelper.getTrashBinItem((Player)serverPlayer);
                if (currentCarried.isEmpty()) {
                    ItemStack retrievedItem = packet.retrievedItem.copy();
                    retrievedItem.setCount(packet.amountTaken);
                    serverPlayer.containerMenu.setCarried(retrievedItem);
                    if (currentTrashItem.getCount() <= packet.amountTaken) {
                        WidgetDataHelper.clearTrashBinItem((Player)serverPlayer);
                    } else {
                        ItemStack updatedTrash = currentTrashItem.copy();
                        updatedTrash.shrink(packet.amountTaken);
                        WidgetDataHelper.setTrashBinItem((Player)serverPlayer, updatedTrash);
                    }
                } else if (ItemStack.isSameItemSameComponents((ItemStack)currentCarried, (ItemStack)packet.retrievedItem) && (actualAmountTaken = Math.min(packet.amountTaken, (maxStackSize = currentCarried.getMaxStackSize()) - (currentCount = currentCarried.getCount()))) > 0) {
                    int newCount = currentCount + actualAmountTaken;
                    currentCarried.setCount(newCount);
                    if (currentTrashItem.getCount() <= actualAmountTaken) {
                        WidgetDataHelper.clearTrashBinItem((Player)serverPlayer);
                    } else {
                        ItemStack updatedTrash = currentTrashItem.copy();
                        updatedTrash.shrink(actualAmountTaken);
                        WidgetDataHelper.setTrashBinItem((Player)serverPlayer, updatedTrash);
                    }
                }
            }
        });
    }
}

