/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.world.PocketDimensionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TeleportServerActions {
    private static final String NBT_RETURN_DIM = "wr_pocket_return_dim";
    private static final String NBT_RETURN_X = "wr_pocket_return_x";
    private static final String NBT_RETURN_Y = "wr_pocket_return_y";
    private static final String NBT_RETURN_Z = "wr_pocket_return_z";
    private static final String NBT_RETURN_YAW = "wr_pocket_return_yaw";
    private static final String NBT_RETURN_PITCH = "wr_pocket_return_pitch";
    private static final String NBT_END_RETURN_DIM = "wr_end_return_dim";
    private static final String NBT_END_RETURN_X = "wr_end_return_x";
    private static final String NBT_END_RETURN_Y = "wr_end_return_y";
    private static final String NBT_END_RETURN_Z = "wr_end_return_z";
    private static final String NBT_END_RETURN_YAW = "wr_end_return_yaw";
    private static final String NBT_END_RETURN_PITCH = "wr_end_return_pitch";
    private static final String NBT_NETHER_RETURN_DIM = "wr_nether_return_dim";
    private static final String NBT_NETHER_RETURN_X = "wr_nether_return_x";
    private static final String NBT_NETHER_RETURN_Y = "wr_nether_return_y";
    private static final String NBT_NETHER_RETURN_Z = "wr_nether_return_z";
    private static final String NBT_NETHER_RETURN_YAW = "wr_nether_return_yaw";
    private static final String NBT_NETHER_RETURN_PITCH = "wr_nether_return_pitch";

    public static void teleportToBedOrSpawn(ServerPlayer player) {
        Vec3 targetPos;
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty() || !WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.TELEPORTER, shell)) {
            return;
        }
        ServerLevel level = player.serverLevel();
        BlockPos bed = player.getRespawnPosition();
        ServerLevel targetLevel = level;
        float yaw = player.getYRot();
        float pitch = player.getXRot();
        if (bed != null) {
            targetPos = Vec3.atCenterOf((Vec3i)bed);
            if (player.getRespawnDimension() != null && player.getRespawnDimension() != level.dimension() && (targetLevel = player.server.getLevel(player.getRespawnDimension())) == null) {
                targetLevel = level;
            }
        } else {
            targetLevel = player.server.getLevel(Level.OVERWORLD);
            if (targetLevel == null) {
                targetLevel = level;
            }
            targetPos = Vec3.atCenterOf((Vec3i)targetLevel.getSharedSpawnPos());
            yaw = 0.0f;
            pitch = 0.0f;
        }
        TeleportServerActions.teleportCrossDim(player, targetLevel, targetPos, yaw, pitch);
    }

    public static void teleportToggleNetherOverworld(ServerPlayer player) {
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty() || WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.TELEPORTER, shell).getLevel() < 2) {
            return;
        }
        ServerLevel current = player.serverLevel();
        CompoundTag tag = player.getPersistentData();
        if (current.dimension() == Level.NETHER) {
            ServerLevel target;
            if (tag.contains(NBT_NETHER_RETURN_DIM)) {
                try {
                    ServerLevel backLevel;
                    ResourceLocation backDimLoc = ResourceLocation.parse((String)tag.getString(NBT_NETHER_RETURN_DIM));
                    if (backDimLoc.equals((Object)Level.OVERWORLD.location()) && (backLevel = player.server.getLevel(Level.OVERWORLD)) != null) {
                        double x = tag.getDouble(NBT_NETHER_RETURN_X);
                        double y = tag.getDouble(NBT_NETHER_RETURN_Y);
                        double z = tag.getDouble(NBT_NETHER_RETURN_Z);
                        float yaw = tag.getFloat(NBT_NETHER_RETURN_YAW);
                        float pitch = tag.getFloat(NBT_NETHER_RETURN_PITCH);
                        TeleportServerActions.teleportCrossDim(player, backLevel, new Vec3(x, y, z), yaw, pitch);
                        tag.remove(NBT_NETHER_RETURN_DIM);
                        tag.remove(NBT_NETHER_RETURN_X);
                        tag.remove(NBT_NETHER_RETURN_Y);
                        tag.remove(NBT_NETHER_RETURN_Z);
                        tag.remove(NBT_NETHER_RETURN_YAW);
                        tag.remove(NBT_NETHER_RETURN_PITCH);
                        return;
                    }
                }
                catch (Exception backDimLoc) {
                    // empty catch block
                }
            }
            if ((target = player.server.getLevel(Level.OVERWORLD)) == null) {
                return;
            }
            Vec3 currentPos = player.position();
            Vec3 targetPos = new Vec3(currentPos.x * 8.0, currentPos.y, currentPos.z * 8.0);
            Vec3 safePos = TeleportServerActions.findSafeTeleportPosition(target, targetPos);
            TeleportServerActions.teleportCrossDim(player, target, safePos, player.getYRot(), player.getXRot());
        } else {
            try {
                ResourceLocation dimLoc = player.serverLevel().dimension().location();
                tag.putString(NBT_NETHER_RETURN_DIM, dimLoc.toString());
                tag.putDouble(NBT_NETHER_RETURN_X, player.getX());
                tag.putDouble(NBT_NETHER_RETURN_Y, player.getY());
                tag.putDouble(NBT_NETHER_RETURN_Z, player.getZ());
                tag.putFloat(NBT_NETHER_RETURN_YAW, player.getYRot());
                tag.putFloat(NBT_NETHER_RETURN_PITCH, player.getXRot());
            }
            catch (Exception dimLoc) {
                // empty catch block
            }
            ServerLevel target = player.server.getLevel(Level.NETHER);
            if (target == null) {
                return;
            }
            Vec3 currentPos = player.position();
            Vec3 targetPos = new Vec3(currentPos.x / 8.0, currentPos.y, currentPos.z / 8.0);
            Vec3 safePos = TeleportServerActions.findSafeTeleportPosition(target, targetPos);
            TeleportServerActions.teleportCrossDim(player, target, safePos, player.getYRot(), player.getXRot());
        }
    }

    public static void teleportToEndSpawn(ServerPlayer player) {
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty() || WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.TELEPORTER, shell).getLevel() < 5) {
            return;
        }
        ServerLevel current = player.serverLevel();
        CompoundTag tag = player.getPersistentData();
        if (current.dimension() == Level.END) {
            ServerLevel overworld;
            if (tag.contains(NBT_END_RETURN_DIM)) {
                try {
                    ResourceLocation backDimLoc = ResourceLocation.parse((String)tag.getString(NBT_END_RETURN_DIM));
                    ServerLevel backLevel = player.server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)backDimLoc));
                    if (backLevel != null) {
                        double x = tag.getDouble(NBT_END_RETURN_X);
                        double y = tag.getDouble(NBT_END_RETURN_Y);
                        double z = tag.getDouble(NBT_END_RETURN_Z);
                        float yaw = tag.getFloat(NBT_END_RETURN_YAW);
                        float pitch = tag.getFloat(NBT_END_RETURN_PITCH);
                        TeleportServerActions.teleportCrossDim(player, backLevel, new Vec3(x, y, z), yaw, pitch);
                        tag.remove(NBT_END_RETURN_DIM);
                        tag.remove(NBT_END_RETURN_X);
                        tag.remove(NBT_END_RETURN_Y);
                        tag.remove(NBT_END_RETURN_Z);
                        tag.remove(NBT_END_RETURN_YAW);
                        tag.remove(NBT_END_RETURN_PITCH);
                        return;
                    }
                }
                catch (Exception backDimLoc) {
                    // empty catch block
                }
            }
            if ((overworld = player.server.getLevel(Level.OVERWORLD)) != null) {
                Vec3 spawnPos = Vec3.atCenterOf((Vec3i)overworld.getSharedSpawnPos());
                Vec3 safePos = TeleportServerActions.findSafeTeleportPosition(overworld, spawnPos);
                TeleportServerActions.teleportCrossDim(player, overworld, safePos, player.getYRot(), player.getXRot());
            }
            return;
        }
        try {
            ResourceLocation dimLoc = player.serverLevel().dimension().location();
            tag.putString(NBT_END_RETURN_DIM, dimLoc.toString());
            tag.putDouble(NBT_END_RETURN_X, player.getX());
            tag.putDouble(NBT_END_RETURN_Y, player.getY());
            tag.putDouble(NBT_END_RETURN_Z, player.getZ());
            tag.putFloat(NBT_END_RETURN_YAW, player.getYRot());
            tag.putFloat(NBT_END_RETURN_PITCH, player.getXRot());
        }
        catch (Exception dimLoc) {
            // empty catch block
        }
        ServerLevel target = player.server.getLevel(Level.END);
        if (target == null) {
            return;
        }
        BlockPos endSpawnPos = TeleportServerActions.findEndPortalPlatform(target);
        Vec3 targetPos = Vec3.atCenterOf((Vec3i)endSpawnPos);
        Vec3 safePos = TeleportServerActions.findSafeTeleportPosition(target, targetPos);
        TeleportServerActions.teleportCrossDim(player, target, safePos, 0.0f, 0.0f);
    }

    public static void teleportRandomLocal(ServerPlayer player) {
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty() || WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.TELEPORTER, shell).getLevel() < 3) {
            return;
        }
        ServerLevel level = player.serverLevel();
        if (level.dimension() == PocketDimensionHelper.POCKET_LEVEL_END || level.dimension() == PocketDimensionHelper.POCKET_LEVEL_OVERWORLD) {
            return;
        }
        RandomSource rand = player.getRandom();
        Vec3 start = player.position();
        double dx = rand.nextDouble() * 40.0 - 20.0;
        double dz = rand.nextDouble() * 40.0 - 20.0;
        Vec3 candidate = new Vec3(start.x + dx, start.y, start.z + dz);
        Vec3 safe = TeleportServerActions.findSafeTeleportPosition(level, candidate);
        TeleportServerActions.teleportCrossDim(player, level, safe, player.getYRot(), player.getXRot());
    }

    public static void teleportToPocket(ServerPlayer player) {
        boolean inPocket;
        ItemStack shell = ShellItem.findWornshell((Player)player);
        if (shell.isEmpty() || WidgetUnlockSystem.getWidgetTier(WidgetUnlockSystem.WidgetType.TELEPORTER, shell).getLevel() < 4) {
            return;
        }
        CompoundTag tag = player.getPersistentData();
        ResourceKey currentDim = player.serverLevel().dimension();
        boolean bl = inPocket = currentDim == PocketDimensionHelper.POCKET_LEVEL_END || currentDim == PocketDimensionHelper.POCKET_LEVEL_OVERWORLD;
        if (inPocket && tag.contains(NBT_RETURN_DIM)) {
            try {
                ResourceLocation backDimLoc = ResourceLocation.parse((String)tag.getString(NBT_RETURN_DIM));
                ServerLevel backLevel = player.server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)backDimLoc));
                if (backLevel != null) {
                    double x = tag.getDouble(NBT_RETURN_X);
                    double y = tag.getDouble(NBT_RETURN_Y);
                    double z = tag.getDouble(NBT_RETURN_Z);
                    float yaw = tag.getFloat(NBT_RETURN_YAW);
                    float pitch = tag.getFloat(NBT_RETURN_PITCH);
                    TeleportServerActions.teleportCrossDim(player, backLevel, new Vec3(x, y, z), yaw, pitch);
                    tag.remove(NBT_RETURN_DIM);
                    tag.remove(NBT_RETURN_X);
                    tag.remove(NBT_RETURN_Y);
                    tag.remove(NBT_RETURN_Z);
                    tag.remove(NBT_RETURN_YAW);
                    tag.remove(NBT_RETURN_PITCH);
                    return;
                }
            }
            catch (Exception backDimLoc) {
                // empty catch block
            }
        }
        try {
            ResourceLocation dimLoc = player.serverLevel().dimension().location();
            tag.putString(NBT_RETURN_DIM, dimLoc.toString());
            tag.putDouble(NBT_RETURN_X, player.getX());
            tag.putDouble(NBT_RETURN_Y, player.getY());
            tag.putDouble(NBT_RETURN_Z, player.getZ());
            tag.putFloat(NBT_RETURN_YAW, player.getYRot());
            tag.putFloat(NBT_RETURN_PITCH, player.getXRot());
        }
        catch (Exception dimLoc) {
            // empty catch block
        }
        ServerLevel pocket = PocketDimensionHelper.getPocketLevel(player);
        if (pocket == null) {
            return;
        }
        Vec3 spawn = PocketDimensionHelper.getOrCreateRoomAndGetSpawn(pocket, player);
        TeleportServerActions.teleportCrossDim(player, pocket, spawn, 0.0f, 0.0f);
    }

    private static Vec3 findSafeTeleportPosition(ServerLevel level, Vec3 targetPos) {
        BlockPos pos = BlockPos.containing((Position)targetPos);
        BlockPos groundPos = TeleportServerActions.findSolidGround(level, pos);
        if (groundPos != null && TeleportServerActions.isSafePosition(level, groundPos)) {
            return Vec3.atCenterOf((Vec3i)groundPos);
        }
        for (int radius = 1; radius <= 16; ++radius) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos testPos;
                    BlockPos groundTestPos;
                    if (Math.abs(x) != radius && Math.abs(z) != radius || (groundTestPos = TeleportServerActions.findSolidGround(level, testPos = pos.offset(x, 0, z))) == null || !TeleportServerActions.isSafePosition(level, groundTestPos)) continue;
                    return Vec3.atCenterOf((Vec3i)groundTestPos);
                }
            }
        }
        for (int yOffset = 1; yOffset <= 32; ++yOffset) {
            BlockPos upPos = pos.offset(0, yOffset, 0);
            BlockPos groundUpPos = TeleportServerActions.findSolidGround(level, upPos);
            if (groundUpPos != null && TeleportServerActions.isSafePosition(level, groundUpPos)) {
                return Vec3.atCenterOf((Vec3i)groundUpPos);
            }
            BlockPos downPos = pos.offset(0, -yOffset, 0);
            BlockPos groundDownPos = TeleportServerActions.findSolidGround(level, downPos);
            if (groundDownPos == null || !TeleportServerActions.isSafePosition(level, groundDownPos)) continue;
            return Vec3.atCenterOf((Vec3i)groundDownPos);
        }
        BlockPos lastResortGround = TeleportServerActions.findSolidGround(level, pos);
        if (lastResortGround != null) {
            return Vec3.atCenterOf((Vec3i)lastResortGround);
        }
        return targetPos;
    }

    private static BlockPos findSolidGround(ServerLevel level, BlockPos startPos) {
        BlockState block;
        BlockPos testPos;
        int yOffset;
        for (yOffset = 0; yOffset <= 64; ++yOffset) {
            testPos = startPos.offset(0, -yOffset, 0);
            block = level.getBlockState(testPos);
            if (!block.isSolid() || !block.blocksMotion() || block.isAir()) continue;
            return testPos.above();
        }
        for (yOffset = 1; yOffset <= 32; ++yOffset) {
            testPos = startPos.offset(0, yOffset, 0);
            block = level.getBlockState(testPos);
            if (!block.isSolid() || !block.blocksMotion() || block.isAir()) continue;
            return testPos.above();
        }
        boolean inVoid = TeleportServerActions.isInVoidSpace(level, startPos);
        if (inVoid) {
            for (int yOffset2 = 65; yOffset2 <= 128; ++yOffset2) {
                BlockPos testPos2 = startPos.offset(0, -yOffset2, 0);
                BlockState block2 = level.getBlockState(testPos2);
                if (block2.is(Blocks.END_STONE)) {
                    return testPos2.above();
                }
                if (!block2.isSolid() || !block2.blocksMotion() || block2.isAir()) continue;
                return testPos2.above();
            }
            for (int radius = 1; radius <= 32; ++radius) {
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        if (Math.abs(x) != radius && Math.abs(z) != radius) continue;
                        BlockPos testPos3 = startPos.offset(x, 0, z);
                        for (int yOffset3 = 0; yOffset3 <= 64; ++yOffset3) {
                            BlockPos groundPos = testPos3.offset(0, -yOffset3, 0);
                            BlockState block3 = level.getBlockState(groundPos);
                            if (block3.is(Blocks.END_STONE)) {
                                return groundPos.above();
                            }
                            if (!block3.isSolid() || !block3.blocksMotion() || block3.isAir()) continue;
                            return groundPos.above();
                        }
                    }
                }
            }
        }
        return null;
    }

    private static boolean isInVoidSpace(ServerLevel level, BlockPos pos) {
        int airCount = 0;
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = -2; y <= 2; ++y) {
                    BlockPos testPos = pos.offset(x, y, z);
                    BlockState block = level.getBlockState(testPos);
                    if (!block.isAir()) continue;
                    ++airCount;
                }
            }
        }
        return airCount > 20;
    }

    private static BlockPos findEndPortalPlatform(ServerLevel level) {
        BlockState block;
        BlockPos testPos;
        int z;
        int x;
        int y;
        BlockPos center = new BlockPos(0, 60, 0);
        for (y = 55; y <= 65; ++y) {
            for (x = -5; x <= 5; ++x) {
                for (z = -5; z <= 5; ++z) {
                    testPos = center.offset(x, y - 60, z);
                    block = level.getBlockState(testPos);
                    if (!block.is(Blocks.OBSIDIAN)) continue;
                    return testPos.above();
                }
            }
        }
        for (y = 50; y <= 70; ++y) {
            for (x = -10; x <= 10; ++x) {
                for (z = -10; z <= 10; ++z) {
                    testPos = center.offset(x, y - 60, z);
                    block = level.getBlockState(testPos);
                    if (!block.is(Blocks.END_STONE)) continue;
                    return testPos.above();
                }
            }
        }
        return center;
    }

    private static boolean isSafePosition(ServerLevel level, BlockPos pos) {
        BlockState blockAt = level.getBlockState(pos);
        BlockState blockAbove = level.getBlockState(pos.above());
        boolean playerSpaceClear = !(!blockAt.isAir() && blockAt.blocksMotion() || !blockAbove.isAir() && blockAbove.blocksMotion());
        BlockState groundBelow = level.getBlockState(pos.below());
        boolean hasSolidGround = groundBelow.isSolid() && groundBelow.blocksMotion() && !groundBelow.isAir();
        boolean notInLiquid = !blockAt.liquid() && !blockAbove.liquid();
        return playerSpaceClear && hasSolidGround && notInLiquid;
    }

    private static void teleportCrossDim(ServerPlayer player, ServerLevel targetLevel, Vec3 pos, float yaw, float pitch) {
        if (player.serverLevel() != targetLevel) {
            player.teleportTo(targetLevel, pos.x, pos.y, pos.z, yaw, pitch);
            return;
        }
        player.teleportTo(targetLevel, pos.x, pos.y, pos.z, yaw, pitch);
    }
}

