/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.network.GuardianSyncPacket;
import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ToggleGuardianSettingPacket(Setting setting) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ToggleGuardianSettingPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"toggle_guardian_setting"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ToggleGuardianSettingPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of((buf, s) -> buf.writeEnum((Enum)s), b -> (Setting)b.readEnum(Setting.class)), ToggleGuardianSettingPacket::setting, ToggleGuardianSettingPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ToggleGuardianSettingPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ToggleGuardianSettingPacket.handleToggle(packet.setting, player);
            }
        });
    }

    private static void handleToggle(Setting setting, ServerPlayer player) {
        boolean canToggle;
        ItemStack shellStack = ShellItem.findWornshell((Player)player);
        if (shellStack.isEmpty()) {
            return;
        }
        if (!WidgetUnlockSystem.isUnlocked(WidgetUnlockSystem.WidgetType.GUARDIAN, shellStack)) {
            return;
        }
        WidgetUnlockSystem.WidgetType widgetType = WidgetUnlockSystem.WidgetType.GUARDIAN;
        WidgetUnlockSystem.WidgetTier currentTier = WidgetUnlockSystem.getWidgetTier(widgetType, shellStack);
        int tierLevel = currentTier.getLevel();
        switch (setting.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                boolean bl;
                if (tierLevel >= 6) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                boolean bl;
                if (tierLevel >= 7) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl;
                if (tierLevel >= 8) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                boolean bl;
                if (tierLevel >= 9) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                boolean bl = canToggle = tierLevel >= 10;
            }
        }
        if (!canToggle) {
            return;
        }
        switch (setting.ordinal()) {
            case 0: {
                WidgetDataHelper.setGuardianTorchEnabled((Player)player, !WidgetDataHelper.isGuardianTorchEnabled((Player)player));
                break;
            }
            case 1: {
                WidgetDataHelper.setGuardianSnowEnabled((Player)player, !WidgetDataHelper.isGuardianSnowEnabled((Player)player));
                break;
            }
            case 2: {
                WidgetDataHelper.setGuardianPiglinEnabled((Player)player, !WidgetDataHelper.isGuardianPiglinEnabled((Player)player));
                break;
            }
            case 3: {
                WidgetDataHelper.setGuardianSlowfallEnabled((Player)player, !WidgetDataHelper.isGuardianSlowfallEnabled((Player)player));
                break;
            }
            case 4: {
                WidgetDataHelper.setGuardianInvisibilityEnabled((Player)player, !WidgetDataHelper.isGuardianInvisibilityEnabled((Player)player));
            }
        }
        GuardianSyncPacket.sendTo(player);
    }

    public static enum Setting {
        TORCH,
        SNOW,
        PIGLIN,
        STEALTH,
        INVISIBILITY;

    }
}

