/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.util.ItemStackData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TravelersGardenSyncPacket(int plantSlots, int harvestSlots, int speedBonus, List<CompoundTag> plants, List<ItemStackData> buffer, boolean autoPushEnabled) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TravelersGardenSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"travelers_garden_sync"));
    private static final StreamCodec<RegistryFriendlyByteBuf, List<CompoundTag>> PLANTS_CODEC = StreamCodec.of((buf, list) -> {
        buf.writeVarInt(list.size());
        for (CompoundTag tag : list) {
            buf.writeNbt((Tag)tag);
        }
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<CompoundTag> out = new ArrayList<CompoundTag>(size);
        for (int i = 0; i < size; ++i) {
            CompoundTag t = buf.readNbt();
            if (t == null) {
                t = new CompoundTag();
            }
            out.add(t);
        }
        return out;
    });
    private static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStackData>> BUFFER_CODEC = StreamCodec.of((buf, list) -> {
        buf.writeVarInt(list.size());
        for (ItemStackData d : list) {
            ItemStackData.STREAM_CODEC.encode(buf, (Object)d);
        }
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<ItemStackData> out = new ArrayList<ItemStackData>(size);
        for (int i = 0; i < size; ++i) {
            out.add((ItemStackData)ItemStackData.STREAM_CODEC.decode(buf));
        }
        return out;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, TravelersGardenSyncPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, TravelersGardenSyncPacket::plantSlots, (StreamCodec)ByteBufCodecs.VAR_INT, TravelersGardenSyncPacket::harvestSlots, (StreamCodec)ByteBufCodecs.VAR_INT, TravelersGardenSyncPacket::speedBonus, PLANTS_CODEC, TravelersGardenSyncPacket::plants, BUFFER_CODEC, TravelersGardenSyncPacket::buffer, (StreamCodec)ByteBufCodecs.BOOL, TravelersGardenSyncPacket::autoPushEnabled, TravelersGardenSyncPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(TravelersGardenSyncPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            ItemStack shell = ShellItem.findWornshell((Player)mc.player);
            if (shell.isEmpty()) {
                return;
            }
            shell.set(ModDataComponents.TG_PLANT_SLOTS.get(), (Object)packet.plantSlots);
            shell.set(ModDataComponents.TG_HARVEST_SLOTS.get(), (Object)packet.harvestSlots);
            shell.set(ModDataComponents.TG_SPEED_BONUS.get(), (Object)packet.speedBonus);
            shell.set(ModDataComponents.TG_PLANTS.get(), packet.plants);
            shell.set(ModDataComponents.TG_HARVEST_BUFFER.get(), packet.buffer);
            shell.set(ModDataComponents.TG_AUTO_PUSH_ENABLED.get(), (Object)packet.autoPushEnabled);
        });
    }

    public static TravelersGardenSyncPacket fromServerPlayer(ServerPlayer sp) {
        ItemStack shell = ShellItem.findWornshell((Player)sp);
        int plantSlots = (Integer)shell.getOrDefault(ModDataComponents.TG_PLANT_SLOTS.get(), (Object)5);
        int harvestSlots = (Integer)shell.getOrDefault(ModDataComponents.TG_HARVEST_SLOTS.get(), (Object)5);
        int speedBonus = (Integer)shell.getOrDefault(ModDataComponents.TG_SPEED_BONUS.get(), (Object)0);
        ArrayList<CompoundTag> plants = new ArrayList<CompoundTag>((Collection)shell.getOrDefault(ModDataComponents.TG_PLANTS.get(), new ArrayList()));
        ArrayList<ItemStackData> buffer = new ArrayList<ItemStackData>((Collection)shell.getOrDefault(ModDataComponents.TG_HARVEST_BUFFER.get(), new ArrayList()));
        boolean autoPush = (Boolean)shell.getOrDefault(ModDataComponents.TG_AUTO_PUSH_ENABLED.get(), (Object)false);
        return new TravelersGardenSyncPacket(plantSlots, harvestSlots, speedBonus, plants, buffer, autoPush);
    }

    public static void sendTo(ServerPlayer sp) {
        PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)TravelersGardenSyncPacket.fromServerPlayer(sp), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

