/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateAutoFeederTagFilterPacket(List<ResourceLocation> tags, boolean whitelist) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateAutoFeederTagFilterPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"update_auto_feeder_tag_filter"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateAutoFeederTagFilterPacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeVarInt(packet.tags.size());
        for (ResourceLocation tag : packet.tags) {
            buf.writeResourceLocation(tag);
        }
        buf.writeBoolean(packet.whitelist);
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>();
        for (int i = 0; i < size; ++i) {
            tags.add(buf.readResourceLocation());
        }
        boolean whitelist = buf.readBoolean();
        return new UpdateAutoFeederTagFilterPacket(tags, whitelist);
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpdateAutoFeederTagFilterPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                WidgetDataHelper.setAutoFeederTags((Player)player, packet.tags);
                WidgetDataHelper.setAutoFeederTagWhitelist((Player)player, packet.whitelist);
            }
        });
    }
}

