/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.network.FurnaceSyncPacket;
import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateFurnaceTagRecorderGhostPacket(Slot slot, ItemStack ghost) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateFurnaceTagRecorderGhostPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"update_furnace_tag_recorder_ghost"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateFurnaceTagRecorderGhostPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, UpdateFurnaceTagRecorderGhostPacket>(){

        public UpdateFurnaceTagRecorderGhostPacket decode(RegistryFriendlyByteBuf buf) {
            Slot slot = (Slot)buf.readEnum(Slot.class);
            boolean hasGhost = buf.readBoolean();
            ItemStack ghost = hasGhost ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf) : ItemStack.EMPTY;
            return new UpdateFurnaceTagRecorderGhostPacket(slot, ghost);
        }

        public void encode(RegistryFriendlyByteBuf buf, UpdateFurnaceTagRecorderGhostPacket pkt) {
            buf.writeEnum((Enum)pkt.slot);
            boolean hasGhost = !pkt.ghost.isEmpty();
            buf.writeBoolean(hasGhost);
            if (hasGhost) {
                ItemStack.STREAM_CODEC.encode((Object)buf, (Object)pkt.ghost);
            }
        }
    };

    public CustomPacketPayload.Type<UpdateFurnaceTagRecorderGhostPacket> type() {
        return TYPE;
    }

    public static void handle(UpdateFurnaceTagRecorderGhostPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                if (packet.slot == Slot.INPUT) {
                    WidgetDataHelper.setInputTagRecorderGhost((Player)sp, packet.ghost);
                } else {
                    WidgetDataHelper.setFuelTagRecorderGhost((Player)sp, packet.ghost);
                }
                FurnaceSyncPacket.sendTo(sp);
            }
        });
    }

    public static enum Slot {
        INPUT,
        FUEL;

    }
}

