/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.util.WidgetDataHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateMemorizedSlotPacket(int slotIndex, boolean clear, ItemStack template) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateMemorizedSlotPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"update_memorized_slot"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateMemorizedSlotPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, UpdateMemorizedSlotPacket>(){

        public UpdateMemorizedSlotPacket decode(RegistryFriendlyByteBuf buffer) {
            int idx = buffer.readVarInt();
            boolean clr = buffer.readBoolean();
            boolean hasTemplate = buffer.readBoolean();
            ItemStack tpl = hasTemplate ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer) : ItemStack.EMPTY;
            return new UpdateMemorizedSlotPacket(idx, clr, tpl);
        }

        public void encode(RegistryFriendlyByteBuf buffer, UpdateMemorizedSlotPacket packet) {
            buffer.writeVarInt(packet.slotIndex);
            buffer.writeBoolean(packet.clear);
            boolean hasTemplate = !packet.template.isEmpty();
            buffer.writeBoolean(hasTemplate);
            if (hasTemplate) {
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)packet.template);
            }
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpdateMemorizedSlotPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                if (packet.clear) {
                    WidgetDataHelper.setMemorizedItemAt((Player)serverPlayer, packet.slotIndex, ItemStack.EMPTY);
                    MemorizedSlotSyncPacket.sendTo(serverPlayer, packet.slotIndex, ItemStack.EMPTY);
                } else {
                    WidgetDataHelper.setMemorizedItemAt((Player)serverPlayer, packet.slotIndex, packet.template);
                    MemorizedSlotSyncPacket.sendTo(serverPlayer, packet.slotIndex, packet.template);
                }
            }
        });
    }

    public record MemorizedSlotSyncPacket(int slotIndex, ItemStack template) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<MemorizedSlotSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"memorized_slot_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, MemorizedSlotSyncPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, MemorizedSlotSyncPacket>(){

            public MemorizedSlotSyncPacket decode(RegistryFriendlyByteBuf buffer) {
                int idx = buffer.readVarInt();
                boolean has = buffer.readBoolean();
                ItemStack tpl = has ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer) : ItemStack.EMPTY;
                return new MemorizedSlotSyncPacket(idx, tpl);
            }

            public void encode(RegistryFriendlyByteBuf buffer, MemorizedSlotSyncPacket packet) {
                buffer.writeVarInt(packet.slotIndex);
                boolean has = packet.template != null && !packet.template.isEmpty();
                buffer.writeBoolean(has);
                if (has) {
                    ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)packet.template);
                }
            }
        };

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(MemorizedSlotSyncPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                Minecraft mc = Minecraft.getInstance();
                if (mc.player == null) {
                    return;
                }
                WidgetDataHelper.setMemorizedItemAt((Player)mc.player, packet.slotIndex, packet.template == null ? ItemStack.EMPTY : packet.template);
            });
        }

        public static void sendTo(ServerPlayer sp, int slotIndex, ItemStack template) {
            PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new MemorizedSlotSyncPacket(slotIndex, template), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

