/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.config.ShellConfig;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.item.ShellTier;
import com.etka.nomadsshell.menu.VirtualShellMenu;
import com.etka.nomadsshell.network.UpdateShellDimensionsResponsePacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateShellDimensionsPacket(int width, int height) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateShellDimensionsPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"update_shell_dimensions"));
    public static final StreamCodec<ByteBuf, UpdateShellDimensionsPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, UpdateShellDimensionsPacket::width, (StreamCodec)ByteBufCodecs.VAR_INT, UpdateShellDimensionsPacket::height, UpdateShellDimensionsPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(UpdateShellDimensionsPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Item patt0$temp;
            ItemStack shellStack;
            ServerPlayer player;
            if (context.flow().isServerbound() && (player = (ServerPlayer)context.player()) != null && !(shellStack = ShellItem.findWornshell((Player)player)).isEmpty() && (patt0$temp = shellStack.getItem()) instanceof ShellItem) {
                ShellItem ShellItem2 = (ShellItem)patt0$temp;
                int maxWidth = UpdateShellDimensionsPacket.getMaxWidthForTier(ShellItem2);
                int maxHeight = UpdateShellDimensionsPacket.getMaxHeightForTier(ShellItem2);
                int newWidth = Math.max(1, Math.min(packet.width, maxWidth));
                int newHeight = Math.max(1, Math.min(packet.height, maxHeight));
                ShellItem2.setDimensions(shellStack, newWidth, newHeight);
                AbstractContainerMenu patt1$temp = player.containerMenu;
                if (patt1$temp instanceof VirtualShellMenu) {
                    VirtualShellMenu openMenu = (VirtualShellMenu)patt1$temp;
                    openMenu.applyDimensions(newWidth, newHeight);
                }
                UpdateShellDimensionsResponsePacket response = new UpdateShellDimensionsResponsePacket(newWidth, newHeight);
                context.reply((CustomPacketPayload)response);
            }
        });
    }

    private static int getMaxWidthForTier(ShellItem ShellItem2) {
        return switch (ShellItem2.getTier()) {
            default -> throw new MatchException(null, null);
            case ShellTier.LEATHER -> (Integer)ShellConfig.SERVER.leatherWidth.get();
            case ShellTier.COPPER -> (Integer)ShellConfig.SERVER.copperWidth.get();
            case ShellTier.IRON -> (Integer)ShellConfig.SERVER.ironWidth.get();
            case ShellTier.GOLD -> (Integer)ShellConfig.SERVER.goldWidth.get();
            case ShellTier.EMERALD -> (Integer)ShellConfig.SERVER.emeraldWidth.get();
            case ShellTier.DIAMOND -> (Integer)ShellConfig.SERVER.diamondWidth.get();
            case ShellTier.DIAMOND_BLOCK -> (Integer)ShellConfig.SERVER.diamondBlockWidth.get();
            case ShellTier.NETHERITE -> (Integer)ShellConfig.SERVER.netheriteWidth.get();
        };
    }

    private static int getMaxHeightForTier(ShellItem ShellItem2) {
        return switch (ShellItem2.getTier()) {
            default -> throw new MatchException(null, null);
            case ShellTier.LEATHER -> (Integer)ShellConfig.SERVER.leatherHeight.get();
            case ShellTier.COPPER -> (Integer)ShellConfig.SERVER.copperHeight.get();
            case ShellTier.IRON -> (Integer)ShellConfig.SERVER.ironHeight.get();
            case ShellTier.GOLD -> (Integer)ShellConfig.SERVER.goldHeight.get();
            case ShellTier.EMERALD -> (Integer)ShellConfig.SERVER.emeraldHeight.get();
            case ShellTier.DIAMOND -> (Integer)ShellConfig.SERVER.diamondHeight.get();
            case ShellTier.DIAMOND_BLOCK -> (Integer)ShellConfig.SERVER.diamondBlockHeight.get();
            case ShellTier.NETHERITE -> (Integer)ShellConfig.SERVER.netheriteHeight.get();
        };
    }
}

