/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.network;

import com.etka.nomadsshell.client.screen.VirtualShellScreen;
import com.etka.nomadsshell.client.screen.overlay.OverlayManager;
import com.etka.nomadsshell.client.screen.overlay.WidgetUnlockSystem;
import com.etka.nomadsshell.item.ShellItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record WidgetUnlockedPacket(WidgetUnlockSystem.WidgetType widgetType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<WidgetUnlockedPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"widget_unlocked"));
    public static final StreamCodec<RegistryFriendlyByteBuf, WidgetUnlockedPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of((buf, widgetType) -> buf.writeEnum((Enum)widgetType), buf -> (WidgetUnlockSystem.WidgetType)buf.readEnum(WidgetUnlockSystem.WidgetType.class)), WidgetUnlockedPacket::widgetType, WidgetUnlockedPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(WidgetUnlockedPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            VirtualShellScreen vrs;
            OverlayManager om;
            Screen patt0$temp;
            ItemStack worn;
            WidgetUnlockSystem.unlock(packet.widgetType);
            Minecraft mc = Minecraft.getInstance();
            if (mc.player != null && !(worn = ShellItem.findWornshell((Player)mc.player)).isEmpty()) {
                WidgetUnlockSystem.unlock(packet.widgetType, worn);
            }
            if ((patt0$temp = mc.screen) instanceof VirtualShellScreen && (om = (vrs = (VirtualShellScreen)patt0$temp).getOverlayManager()) != null) {
                if (packet.widgetType == WidgetUnlockSystem.WidgetType.TRASH_BIN && om.getTrashBin() == null) {
                    om.createTrashBin();
                } else if (packet.widgetType == WidgetUnlockSystem.WidgetType.FURNACE && om.getFurnace() == null) {
                    om.createFurnace();
                } else if (packet.widgetType == WidgetUnlockSystem.WidgetType.CRAFTING_TABLE && om.getCraftingTable() == null) {
                    om.createCraftingTable();
                } else if (packet.widgetType == WidgetUnlockSystem.WidgetType.FLUID_TANK && om.getFluidTank() == null) {
                    om.createFluidTank();
                } else if (packet.widgetType == WidgetUnlockSystem.WidgetType.DRIPSTONE_FARM && om.getDripstoneFarm() == null) {
                    om.createDripstoneFarm();
                } else if (packet.widgetType == WidgetUnlockSystem.WidgetType.TRAVELERS_GARDEN && om.getTravelersGarden() == null) {
                    try {
                        if (ModList.get().isLoaded("travelersgarden")) {
                            om.createTravelersGarden();
                        }
                    }
                    catch (Throwable throwable) {}
                } else if (packet.widgetType == WidgetUnlockSystem.WidgetType.COLLECTOR) {
                    om.createCollector();
                } else if (packet.widgetType == WidgetUnlockSystem.WidgetType.MAGNET) {
                    om.createMagnet();
                }
            }
        });
    }
}

