/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.upgrade;

import com.etka.nomadsshell.init.ModDataComponents;
import com.etka.nomadsshell.upgrade.UpgradeCommand;
import com.etka.nomadsshell.util.FluidStackData;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class AddDripstoneCauldronCommand
implements UpgradeCommand {
    private final int cauldronIndex;

    public AddDripstoneCauldronCommand(int cauldronIndex) {
        this.cauldronIndex = cauldronIndex;
    }

    @Override
    public void execute(ItemStack shellStack, ServerPlayer player) {
        int currentCount = (Integer)shellStack.getOrDefault(ModDataComponents.DRIP_CAULDRON_COUNT.get(), (Object)0);
        shellStack.set(ModDataComponents.DRIP_CAULDRON_COUNT.get(), (Object)(currentCount + 1));
        shellStack.set(this.getCauldronFluidComponent(this.cauldronIndex), (Object)FluidStackData.EMPTY);
        shellStack.set(this.getCauldronCapacityComponent(this.cauldronIndex), (Object)1000);
        shellStack.set(this.getCauldronProgressComponent(this.cauldronIndex), (Object)0);
    }

    @Override
    public boolean canExecute(ItemStack shellStack, ServerPlayer player) {
        int currentCount = (Integer)shellStack.getOrDefault(ModDataComponents.DRIP_CAULDRON_COUNT.get(), (Object)0);
        return currentCount < this.cauldronIndex;
    }

    @Override
    public String getCommandId() {
        return "add_dripstone_cauldron_" + this.cauldronIndex;
    }

    private DataComponentType<FluidStackData> getCauldronFluidComponent(int cauldronIndex) {
        return switch (cauldronIndex) {
            case 1 -> ModDataComponents.DRIP_SOURCE_FLUID_0.get();
            case 2 -> ModDataComponents.DRIP_SOURCE_FLUID_1.get();
            case 3 -> ModDataComponents.DRIP_SOURCE_FLUID_2.get();
            case 4 -> ModDataComponents.DRIP_SOURCE_FLUID_3.get();
            case 5 -> ModDataComponents.DRIP_SOURCE_FLUID_4.get();
            default -> throw new IllegalArgumentException("Invalid cauldron index: " + cauldronIndex);
        };
    }

    private DataComponentType<Integer> getCauldronCapacityComponent(int cauldronIndex) {
        return switch (cauldronIndex) {
            case 1 -> ModDataComponents.DRIP_CAULDRON_MB_0.get();
            case 2 -> ModDataComponents.DRIP_CAULDRON_MB_1.get();
            case 3 -> ModDataComponents.DRIP_CAULDRON_MB_2.get();
            case 4 -> ModDataComponents.DRIP_CAULDRON_MB_3.get();
            case 5 -> ModDataComponents.DRIP_CAULDRON_MB_4.get();
            default -> throw new IllegalArgumentException("Invalid cauldron index: " + cauldronIndex);
        };
    }

    private DataComponentType<Integer> getCauldronProgressComponent(int cauldronIndex) {
        return switch (cauldronIndex) {
            case 1 -> ModDataComponents.DRIP_PROGRESS_0.get();
            case 2 -> ModDataComponents.DRIP_PROGRESS_1.get();
            case 3 -> ModDataComponents.DRIP_PROGRESS_2.get();
            case 4 -> ModDataComponents.DRIP_PROGRESS_3.get();
            case 5 -> ModDataComponents.DRIP_PROGRESS_4.get();
            default -> throw new IllegalArgumentException("Invalid cauldron index: " + cauldronIndex);
        };
    }
}

