/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class ContainerUtils {
    public static final int MAX_CONTAINER_ITEMS = 256;

    public static ItemContainerContents createSafeContainerContents(List<ItemStack> items) {
        if (items.isEmpty()) {
            return ItemContainerContents.EMPTY;
        }
        List<Object> safeItems = new ArrayList<ItemStack>(items);
        if (safeItems.size() > 256) {
            safeItems = safeItems.subList(0, 256);
        }
        try {
            return ItemContainerContents.fromItems(safeItems);
        }
        catch (IllegalArgumentException e) {
            List nonEmptyItems = safeItems.stream().filter(stack -> !stack.isEmpty()).collect(Collectors.toList());
            if (nonEmptyItems.size() > 256) {
                nonEmptyItems = nonEmptyItems.subList(0, 256);
            }
            try {
                return ItemContainerContents.fromItems(nonEmptyItems);
            }
            catch (IllegalArgumentException fallbackError) {
                return ItemContainerContents.EMPTY;
            }
        }
    }

    public static int getSafeContainerSize(int requestedSize) {
        if (requestedSize > 256) {
            // empty if block
        }
        return Math.min(requestedSize, 256);
    }

    public static boolean isContainerSizeSafe(int size) {
        return size <= 256;
    }
}

