/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.util;

import com.etka.nomadsshell.inventory.VirtualInventory;
import com.etka.nomadsshell.item.ShellItem;
import com.etka.nomadsshell.menu.ShellMenu;
import com.etka.nomadsshell.menu.VirtualShellMenu;
import com.etka.nomadsshell.util.ContainerUtils;
import com.etka.nomadsshell.util.WidgetDataHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;

public class InventoryUtils {
    private static final Map<String, List<Item>> TAG_EXPANSIONS = new HashMap<String, List<Item>>();

    public static List<Item> getTagExpansion(String tagLocation) {
        return TAG_EXPANSIONS.getOrDefault(tagLocation, Collections.emptyList());
    }

    private static boolean matchesTag(ItemStack stack, TagKey<Item> tag, Set<Item> expandedItems) {
        return stack.is(tag) || expandedItems != null && expandedItems.contains(stack.getItem());
    }

    public static int countItemAcrossInventoryAndshell(Player player, Item item) {
        int totalCount = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || stack.getItem() != item) continue;
            totalCount += stack.getCount();
        }
        return totalCount += InventoryUtils.countItemInshell(player, item);
    }

    public static int countItemByTagAcrossInventoryAndshell(Player player, ResourceLocation tagLocation) {
        TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagLocation);
        int totalCount = 0;
        List<Item> expandedItems = InventoryUtils.getTagExpansion(tagLocation.toString());
        HashSet<Item> expandedSet = expandedItems.isEmpty() ? null : new HashSet<Item>(expandedItems);
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            boolean matches;
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !(matches = InventoryUtils.matchesTag(stack, (TagKey<Item>)tag, expandedSet))) continue;
            totalCount += stack.getCount();
        }
        int shellCount = InventoryUtils.countItemByTagInshell(player, (TagKey<Item>)tag, expandedSet);
        return totalCount += shellCount;
    }

    public static boolean consumeItemAcrossInventoryAndshell(Player player, Item item, int count) {
        if (count <= 0) {
            return true;
        }
        int remaining = count;
        if ((remaining -= InventoryUtils.consumeItemFromPlayerInventory(player, item, remaining)) > 0) {
            remaining -= InventoryUtils.consumeItemFromshell(player, item, remaining);
        }
        return remaining <= 0;
    }

    public static boolean consumeItemByTagAcrossInventoryAndshell(Player player, ResourceLocation tagLocation, int count) {
        int canRemove;
        ItemStack stack;
        int i;
        if (count <= 0) {
            return true;
        }
        TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagLocation);
        int remaining = count;
        List<Item> expandedItems = InventoryUtils.getTagExpansion(tagLocation.toString());
        HashSet<Item> expandedSet = expandedItems.isEmpty() ? null : new HashSet<Item>(expandedItems);
        for (i = 0; i < player.getInventory().items.size() && remaining > 0; ++i) {
            stack = (ItemStack)player.getInventory().items.get(i);
            if (stack.isEmpty() || !InventoryUtils.matchesTag(stack, (TagKey<Item>)tag, expandedSet)) continue;
            canRemove = Math.min(stack.getCount(), remaining);
            stack.shrink(canRemove);
            if (stack.isEmpty()) {
                player.getInventory().items.set(i, (Object)ItemStack.EMPTY);
            }
            remaining -= canRemove;
        }
        for (i = 0; i < player.getInventory().offhand.size() && remaining > 0; ++i) {
            stack = (ItemStack)player.getInventory().offhand.get(i);
            if (stack.isEmpty() || !InventoryUtils.matchesTag(stack, (TagKey<Item>)tag, expandedSet)) continue;
            canRemove = Math.min(stack.getCount(), remaining);
            stack.shrink(canRemove);
            if (stack.isEmpty()) {
                player.getInventory().offhand.set(i, (Object)ItemStack.EMPTY);
            }
            remaining -= canRemove;
        }
        if (remaining > 0) {
            remaining -= InventoryUtils.consumeItemByTagFromshell(player, (TagKey<Item>)tag, expandedSet, remaining);
        }
        return remaining <= 0;
    }

    private static int consumeItemByTagFromshell(Player player, TagKey<Item> tag, Set<Item> expandedItems, int maxToRemove) {
        if (maxToRemove <= 0) {
            return 0;
        }
        int removed = 0;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ShellMenu) {
            ShellMenu ShellMenu2 = (ShellMenu)abstractContainerMenu;
            for (int i = 0; i < ShellMenu2.getshellSlotCount() && removed < maxToRemove; ++i) {
                ItemStack stack = ShellMenu2.getshellContainer().getItem(i);
                if (stack.isEmpty() || !InventoryUtils.matchesTag(stack, tag, expandedItems)) continue;
                int canRemove = Math.min(stack.getCount(), maxToRemove - removed);
                ItemStack newStack = stack.copy();
                newStack.shrink(canRemove);
                ShellMenu2.getshellContainer().setItem(i, newStack.isEmpty() ? ItemStack.EMPTY : newStack);
                removed += canRemove;
            }
            return removed;
        }
        ItemStack wornshell = ShellItem.findWornshell(player);
        if (!wornshell.isEmpty()) {
            int i;
            ItemContainerContents contents = ShellItem.getshellContents(wornshell);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (i = 0; i < contents.getSlots(); ++i) {
                items.add(contents.getStackInSlot(i));
            }
            for (i = 0; i < items.size() && removed < maxToRemove; ++i) {
                ItemStack stack = (ItemStack)items.get(i);
                if (stack.isEmpty() || !InventoryUtils.matchesTag(stack, tag, expandedItems)) continue;
                int canRemove = Math.min(stack.getCount(), maxToRemove - removed);
                ItemStack newStack = stack.copy();
                newStack.shrink(canRemove);
                items.set(i, newStack.isEmpty() ? ItemStack.EMPTY : newStack);
                removed += canRemove;
            }
            ItemContainerContents newContents = ContainerUtils.createSafeContainerContents(items);
            ShellItem.setshellContents(wornshell, newContents);
        }
        return removed;
    }

    public static int consumeItemFromPlayerInventory(Player player, Item item, int maxToRemove) {
        int canRemove;
        ItemStack stack;
        int i;
        if (maxToRemove <= 0) {
            return 0;
        }
        int removed = 0;
        for (i = 0; i < player.getInventory().items.size() && removed < maxToRemove; ++i) {
            stack = (ItemStack)player.getInventory().items.get(i);
            if (stack.isEmpty() || stack.getItem() != item) continue;
            canRemove = Math.min(stack.getCount(), maxToRemove - removed);
            stack.shrink(canRemove);
            if (stack.isEmpty()) {
                player.getInventory().items.set(i, (Object)ItemStack.EMPTY);
            }
            removed += canRemove;
        }
        for (i = 0; i < player.getInventory().offhand.size() && removed < maxToRemove; ++i) {
            stack = (ItemStack)player.getInventory().offhand.get(i);
            if (stack.isEmpty() || stack.getItem() != item) continue;
            canRemove = Math.min(stack.getCount(), maxToRemove - removed);
            stack.shrink(canRemove);
            if (stack.isEmpty()) {
                player.getInventory().offhand.set(i, (Object)ItemStack.EMPTY);
            }
            removed += canRemove;
        }
        return removed;
    }

    public static int consumeItemFromshell(Player player, Item item, int maxToRemove) {
        if (maxToRemove <= 0) {
            return 0;
        }
        int removed = 0;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ShellMenu) {
            ShellMenu ShellMenu2 = (ShellMenu)abstractContainerMenu;
            for (int i = 0; i < ShellMenu2.getshellSlotCount() && removed < maxToRemove; ++i) {
                ItemStack stack = ShellMenu2.getshellContainer().getItem(i);
                if (stack.isEmpty() || stack.getItem() != item) continue;
                int canRemove = Math.min(stack.getCount(), maxToRemove - removed);
                ItemStack newStack = stack.copy();
                newStack.shrink(canRemove);
                ShellMenu2.getshellContainer().setItem(i, newStack.isEmpty() ? ItemStack.EMPTY : newStack);
                removed += canRemove;
            }
            return removed;
        }
        ItemStack wornshell = ShellItem.findWornshell(player);
        if (!wornshell.isEmpty()) {
            int i;
            ItemContainerContents contents = ShellItem.getshellContents(wornshell);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (i = 0; i < contents.getSlots(); ++i) {
                items.add(contents.getStackInSlot(i));
            }
            for (i = 0; i < items.size() && removed < maxToRemove; ++i) {
                ItemStack stack = (ItemStack)items.get(i);
                if (stack.isEmpty() || stack.getItem() != item) continue;
                int canRemove = Math.min(stack.getCount(), maxToRemove - removed);
                ItemStack newStack = stack.copy();
                newStack.shrink(canRemove);
                items.set(i, newStack.isEmpty() ? ItemStack.EMPTY : newStack);
                removed += canRemove;
            }
            ItemContainerContents newContents = ContainerUtils.createSafeContainerContents(items);
            ShellItem.setshellContents(wornshell, newContents);
        }
        return removed;
    }

    public static Map<Item, Integer> getAllItemCountsAcrossInventoryAndshell(Player player) {
        HashMap<Item, Integer> itemCounts = new HashMap<Item, Integer>();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty()) continue;
            itemCounts.merge(stack.getItem(), stack.getCount(), Integer::sum);
        }
        InventoryUtils.countAllItemsInshell(player, itemCounts);
        return itemCounts;
    }

    private static int countItemInshell(Player player, Item item) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ShellMenu) {
            ShellMenu ShellMenu2 = (ShellMenu)abstractContainerMenu;
            int count = 0;
            for (int i = 0; i < ShellMenu2.getshellSlotCount(); ++i) {
                ItemStack stack = ShellMenu2.getshellContainer().getItem(i);
                if (stack.getItem() != item) continue;
                count += stack.getCount();
            }
            return count;
        }
        ItemStack wornshell = ShellItem.findWornshell(player);
        if (!wornshell.isEmpty()) {
            ItemContainerContents contents = ShellItem.getshellContents(wornshell);
            int count = 0;
            for (int i = 0; i < contents.getSlots(); ++i) {
                ItemStack stack = contents.getStackInSlot(i);
                if (stack.getItem() != item) continue;
                count += stack.getCount();
            }
            return count;
        }
        return 0;
    }

    private static int countItemByTagInshell(Player player, TagKey<Item> tag, Set<Item> expandedItems) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ShellMenu) {
            ShellMenu ShellMenu2 = (ShellMenu)abstractContainerMenu;
            int count = 0;
            for (int i = 0; i < ShellMenu2.getshellSlotCount(); ++i) {
                ItemStack stack = ShellMenu2.getshellContainer().getItem(i);
                if (stack.isEmpty() || !InventoryUtils.matchesTag(stack, tag, expandedItems)) continue;
                count += stack.getCount();
            }
            return count;
        }
        ItemStack wornshell = ShellItem.findWornshell(player);
        if (!wornshell.isEmpty()) {
            ItemContainerContents contents = ShellItem.getshellContents(wornshell);
            int count = 0;
            for (int i = 0; i < contents.getSlots(); ++i) {
                ItemStack stack = contents.getStackInSlot(i);
                if (stack.isEmpty() || !InventoryUtils.matchesTag(stack, tag, expandedItems)) continue;
                count += stack.getCount();
            }
            return count;
        }
        return 0;
    }

    private static void countAllItemsInshell(Player player, Map<Item, Integer> itemCounts) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ShellMenu) {
            ShellMenu ShellMenu2 = (ShellMenu)abstractContainerMenu;
            for (int i = 0; i < ShellMenu2.getshellSlotCount(); ++i) {
                ItemStack stack = ShellMenu2.getshellContainer().getItem(i);
                if (stack.isEmpty()) continue;
                itemCounts.merge(stack.getItem(), stack.getCount(), Integer::sum);
            }
            return;
        }
        ItemStack wornshell = ShellItem.findWornshell(player);
        if (!wornshell.isEmpty()) {
            ItemContainerContents contents = ShellItem.getshellContents(wornshell);
            for (int i = 0; i < contents.getSlots(); ++i) {
                ItemStack stack = contents.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                itemCounts.merge(stack.getItem(), stack.getCount(), Integer::sum);
            }
        }
    }

    public static ItemStack addItemToShell(Player player, ItemStack itemToAdd) {
        VirtualInventory inv;
        Object mem;
        if (itemToAdd.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack remaining = itemToAdd.copy();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ShellMenu) {
            ShellMenu ShellMenu2 = (ShellMenu)abstractContainerMenu;
            mem = WidgetDataHelper.getMemorizedSlots(player);
            for (Map.Entry e : mem.entrySet()) {
                int idx = Integer.parseInt((String)e.getKey());
                ItemStack tpl = (ItemStack)e.getValue();
                if (tpl.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)tpl, (ItemStack)remaining)) continue;
                int slotIndex = idx;
                ItemStack beforeRemaining = remaining.copy();
                remaining = InventoryUtils.addToSlot(ShellMenu2.getshellContainer().getItem(slotIndex), remaining, stack -> ShellMenu2.getshellContainer().setItem(slotIndex, stack));
                if (!remaining.isEmpty()) continue;
                ShellMenu2.syncshellContents();
                return ItemStack.EMPTY;
            }
            for (int i = 0; i < ShellMenu2.getshellSlotCount(); ++i) {
                int slotIndex = i;
                remaining = InventoryUtils.addToSlot(ShellMenu2.getshellContainer().getItem(i), remaining, stack -> ShellMenu2.getshellContainer().setItem(slotIndex, stack));
                if (!remaining.isEmpty()) continue;
                ShellMenu2.syncshellContents();
                break;
            }
            ShellMenu2.syncshellContents();
            return remaining;
        }
        mem = player.containerMenu;
        if (mem instanceof VirtualShellMenu) {
            VirtualShellMenu virtualMenu = (VirtualShellMenu)mem;
            inv = virtualMenu.getVirtualInventory();
            Map<String, ItemStack> mem2 = WidgetDataHelper.getMemorizedSlots(player);
            ItemStack rem = remaining.copy();
            for (Map.Entry<String, ItemStack> e : mem2.entrySet()) {
                int space;
                int to;
                int idx = Integer.parseInt(e.getKey());
                ItemStack tpl = e.getValue();
                if (tpl.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)tpl, (ItemStack)rem)) continue;
                ItemStack slotStack = inv.getItem(idx);
                ItemStack before = rem.copy();
                if (slotStack.isEmpty()) {
                    int max = rem.getMaxStackSize();
                    to = Math.min(rem.getCount(), max);
                    ItemStack newS = rem.copy();
                    newS.setCount(to);
                    inv.setItem(idx, newS);
                    rem.shrink(to);
                } else if (ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)rem) && (to = Math.min(space = slotStack.getMaxStackSize() - slotStack.getCount(), rem.getCount())) > 0) {
                    slotStack.grow(to);
                    rem.shrink(to);
                    inv.setItem(idx, slotStack);
                }
                if (!rem.isEmpty()) continue;
                break;
            }
            ItemStack toAdd = rem.copy();
            ItemStack leftover = inv.addItem(toAdd);
            if (!player.level().isClientSide) {
                ShellItem.setVirtualInventory(virtualMenu.getshellStack(), inv);
            }
            return leftover;
        }
        ItemStack wornshell = ShellItem.findWornshell(player);
        if (!wornshell.isEmpty()) {
            ItemStack slotStack;
            inv = ShellItem.getVirtualInventory(wornshell);
            int totalSlots = inv.getTotalSlots();
            Map<String, ItemStack> mem3 = WidgetDataHelper.getMemorizedSlots(player);
            if (!mem3.isEmpty() && !remaining.isEmpty()) {
                for (Map.Entry<String, ItemStack> e : mem3.entrySet()) {
                    int space;
                    int to;
                    ItemStack tpl;
                    int idx;
                    if (remaining.isEmpty()) break;
                    try {
                        idx = Integer.parseInt(e.getKey());
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    if (idx < 0 || idx >= totalSlots || (tpl = e.getValue()).isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)tpl, (ItemStack)remaining)) continue;
                    ItemStack slotStack2 = inv.getItem(idx);
                    if (slotStack2.isEmpty()) {
                        int to2 = Math.min(remaining.getCount(), remaining.getMaxStackSize());
                        if (to2 <= 0) continue;
                        ItemStack newS = remaining.copy();
                        newS.setCount(to2);
                        inv.setItem(idx, newS);
                        remaining.shrink(to2);
                        continue;
                    }
                    if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack2, (ItemStack)remaining) || (to = Math.min(space = slotStack2.getMaxStackSize() - slotStack2.getCount(), remaining.getCount())) <= 0) continue;
                    slotStack2.grow(to);
                    inv.setItem(idx, slotStack2);
                    remaining.shrink(to);
                }
            }
            if (!remaining.isEmpty()) {
                for (int i = 0; i < totalSlots && !remaining.isEmpty(); ++i) {
                    int space;
                    int to;
                    slotStack = inv.getItem(i);
                    if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)remaining) || (to = Math.min(space = slotStack.getMaxStackSize() - slotStack.getCount(), remaining.getCount())) <= 0) continue;
                    slotStack.grow(to);
                    inv.setItem(i, slotStack);
                    remaining.shrink(to);
                }
            }
            if (!remaining.isEmpty()) {
                for (int i = 0; i < totalSlots && !remaining.isEmpty(); ++i) {
                    int to;
                    ItemStack tpl;
                    boolean isReserved;
                    slotStack = inv.getItem(i);
                    if (!slotStack.isEmpty() || (isReserved = mem3.containsKey(String.valueOf(i))) && ((tpl = mem3.get(String.valueOf(i))) == null || tpl.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)tpl, (ItemStack)remaining)) || (to = Math.min(remaining.getCount(), remaining.getMaxStackSize())) <= 0) continue;
                    ItemStack newS = remaining.copy();
                    newS.setCount(to);
                    inv.setItem(i, newS);
                    remaining.shrink(to);
                }
            }
            if (!player.level().isClientSide) {
                ShellItem.setVirtualInventory(wornshell, inv);
            }
        }
        return remaining;
    }

    private static ItemStack addToSlot(ItemStack slotStack, ItemStack itemToAdd, Consumer<ItemStack> slotSetter) {
        int space;
        int amountToAdd;
        if (slotStack.isEmpty()) {
            int maxStackSize = itemToAdd.getMaxStackSize();
            int amountToAdd2 = Math.min(itemToAdd.getCount(), maxStackSize);
            ItemStack newStack = itemToAdd.copy();
            newStack.setCount(amountToAdd2);
            slotSetter.accept(newStack);
            ItemStack remaining = itemToAdd.copy();
            remaining.shrink(amountToAdd2);
            return remaining.isEmpty() ? ItemStack.EMPTY : remaining;
        }
        if (ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)itemToAdd) && (amountToAdd = Math.min(space = slotStack.getMaxStackSize() - slotStack.getCount(), itemToAdd.getCount())) > 0) {
            ItemStack newStack = slotStack.copy();
            newStack.grow(amountToAdd);
            slotSetter.accept(newStack);
            ItemStack remaining = itemToAdd.copy();
            remaining.shrink(amountToAdd);
            return remaining.isEmpty() ? ItemStack.EMPTY : remaining;
        }
        return itemToAdd;
    }

    public static ItemStack addItemToPlayerInventory(Player player, ItemStack itemToAdd) {
        ItemStack newStack;
        int maxStackSize;
        int space;
        int amountToAdd;
        ItemStack slotStack;
        int i;
        if (itemToAdd.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack remaining = itemToAdd.copy();
        for (i = 9; i < player.getInventory().getContainerSize(); ++i) {
            slotStack = player.getInventory().getItem(i);
            if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)remaining) || (amountToAdd = Math.min(space = slotStack.getMaxStackSize() - slotStack.getCount(), remaining.getCount())) <= 0) continue;
            slotStack.grow(amountToAdd);
            remaining.shrink(amountToAdd);
            if (!remaining.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        for (i = 0; i < 9; ++i) {
            slotStack = player.getInventory().getItem(i);
            if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)remaining) || (amountToAdd = Math.min(space = slotStack.getMaxStackSize() - slotStack.getCount(), remaining.getCount())) <= 0) continue;
            slotStack.grow(amountToAdd);
            remaining.shrink(amountToAdd);
            if (!remaining.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        for (i = 9; i < player.getInventory().getContainerSize(); ++i) {
            slotStack = player.getInventory().getItem(i);
            if (!slotStack.isEmpty()) continue;
            maxStackSize = remaining.getMaxStackSize();
            amountToAdd = Math.min(remaining.getCount(), maxStackSize);
            newStack = remaining.copy();
            newStack.setCount(amountToAdd);
            player.getInventory().setItem(i, newStack);
            remaining.shrink(amountToAdd);
            if (!remaining.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        for (i = 0; i < 9; ++i) {
            slotStack = player.getInventory().getItem(i);
            if (!slotStack.isEmpty()) continue;
            maxStackSize = remaining.getMaxStackSize();
            amountToAdd = Math.min(remaining.getCount(), maxStackSize);
            newStack = remaining.copy();
            newStack.setCount(amountToAdd);
            player.getInventory().setItem(i, newStack);
            remaining.shrink(amountToAdd);
            if (!remaining.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return remaining;
    }

    static {
        TAG_EXPANSIONS.put("minecraft:stone_tool_materials", Arrays.asList(Items.COBBLESTONE, Items.STONE, Items.GRANITE, Items.DIORITE, Items.ANDESITE, Items.BLACKSTONE, Items.DEEPSLATE, Items.COBBLED_DEEPSLATE, Items.POLISHED_BLACKSTONE));
        TAG_EXPANSIONS.put("minecraft:beds", Arrays.asList(Items.RED_BED, Items.BLUE_BED, Items.GREEN_BED, Items.YELLOW_BED, Items.PURPLE_BED, Items.PINK_BED, Items.ORANGE_BED, Items.LIME_BED, Items.CYAN_BED, Items.LIGHT_BLUE_BED, Items.MAGENTA_BED, Items.WHITE_BED, Items.LIGHT_GRAY_BED, Items.GRAY_BED, Items.BLACK_BED, Items.BROWN_BED));
    }
}

