/*
 * Decompiled with CFR 0.152.
 */
package com.etka.nomadsshell.world;

import com.etka.nomadsshell.config.ShellConfig;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public final class PocketDimensionHelper {
    public static final ResourceKey<Level> POCKET_LEVEL_END = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"pocket"));
    public static final ResourceKey<Level> POCKET_LEVEL_OVERWORLD = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nomadsshell", (String)"overworld_pocket"));
    private static final String NBT_ROOM_X = "wr_pocket_room_x";
    private static final String NBT_ROOM_Y = "wr_pocket_room_y";
    private static final String NBT_ROOM_Z = "wr_pocket_room_z";
    private static final String NBT_ROOM_GENERATED = "wr_pocket_room_generated";

    private PocketDimensionHelper() {
    }

    public static ServerLevel getPocketLevel(ServerPlayer player) {
        int bg = (Integer)ShellConfig.SERVER.teleporterPocketBackground.get();
        ResourceKey<Level> key = bg == 1 ? POCKET_LEVEL_OVERWORLD : POCKET_LEVEL_END;
        return player.server.getLevel(key);
    }

    public static Vec3 getOrCreateRoomAndGetSpawn(ServerLevel level, ServerPlayer player) {
        BlockPos base = PocketDimensionHelper.getOrAssignRoomBase(level, player);
        int width = Math.max(1, (Integer)ShellConfig.SERVER.teleporterPocketWidth.get());
        int length = Math.max(1, (Integer)ShellConfig.SERVER.teleporterPocketLength.get());
        int height = Math.max(3, (Integer)ShellConfig.SERVER.teleporterPocketHeight.get());
        int halfW = width / 2;
        int halfL = length / 2;
        BlockPos min = new BlockPos(base.getX() - halfW, base.getY(), base.getZ() - halfL);
        BlockPos max = new BlockPos(base.getX() + halfW, base.getY() + height - 1, base.getZ() + halfL);
        CompoundTag tag = player.getPersistentData();
        if (!tag.getBoolean(NBT_ROOM_GENERATED)) {
            PocketDimensionHelper.carveRoom(level, min, max);
            tag.putBoolean(NBT_ROOM_GENERATED, true);
        }
        return new Vec3((double)base.getX() + 0.5, (double)base.getY() + 1.0, (double)base.getZ() + 0.5);
    }

    private static BlockPos getOrAssignRoomBase(ServerLevel level, ServerPlayer player) {
        CompoundTag tag = player.getPersistentData();
        if (tag.contains(NBT_ROOM_X)) {
            int x = tag.getInt(NBT_ROOM_X);
            int y = tag.getInt(NBT_ROOM_Y);
            int z = tag.getInt(NBT_ROOM_Z);
            return new BlockPos(x, y, z);
        }
        UUID id = player.getUUID();
        long a = id.getMostSignificantBits();
        long b = id.getLeastSignificantBits();
        int grid = 384;
        int cellX = (int)((a ^ a >>> 32) & 0x7FFFL);
        int cellZ = (int)((b ^ b >>> 32) & 0x7FFFL);
        int baseX = cellX % 256 * grid;
        int baseZ = cellZ % 256 * grid;
        int baseY = 80;
        BlockPos base = new BlockPos(baseX, baseY, baseZ);
        tag.putInt(NBT_ROOM_X, base.getX());
        tag.putInt(NBT_ROOM_Y, base.getY());
        tag.putInt(NBT_ROOM_Z, base.getZ());
        return base;
    }

    private static void carveRoom(ServerLevel level, BlockPos min, BlockPos max) {
        int y;
        int z;
        int x;
        level.getChunkAt(min);
        level.getChunkAt(max);
        BlockState air = Blocks.AIR.defaultBlockState();
        BlockState floor = Blocks.BARRIER.defaultBlockState();
        BlockState barrier = Blocks.BARRIER.defaultBlockState();
        for (x = min.getX(); x <= max.getX(); ++x) {
            for (z = min.getZ(); z <= max.getZ(); ++z) {
                PocketDimensionHelper.setIfDifferent(level, new BlockPos(x, min.getY(), z), floor);
                for (int y2 = min.getY() + 1; y2 <= max.getY() - 1; ++y2) {
                    PocketDimensionHelper.setIfDifferent(level, new BlockPos(x, y2, z), air);
                }
            }
        }
        for (x = min.getX() - 1; x <= max.getX() + 1; ++x) {
            for (y = min.getY() + 1; y <= max.getY(); ++y) {
                PocketDimensionHelper.setIfDifferent(level, new BlockPos(x, y, min.getZ() - 1), barrier);
                PocketDimensionHelper.setIfDifferent(level, new BlockPos(x, y, max.getZ() + 1), barrier);
            }
        }
        for (int z2 = min.getZ() - 1; z2 <= max.getZ() + 1; ++z2) {
            for (y = min.getY() + 1; y <= max.getY(); ++y) {
                PocketDimensionHelper.setIfDifferent(level, new BlockPos(min.getX() - 1, y, z2), barrier);
                PocketDimensionHelper.setIfDifferent(level, new BlockPos(max.getX() + 1, y, z2), barrier);
            }
        }
        for (x = min.getX() - 1; x <= max.getX() + 1; ++x) {
            for (z = min.getZ() - 1; z <= max.getZ() + 1; ++z) {
                PocketDimensionHelper.setIfDifferent(level, new BlockPos(x, max.getY() + 1, z), barrier);
                PocketDimensionHelper.setIfDifferent(level, new BlockPos(x, max.getY() + 2, z), barrier);
            }
        }
    }

    private static void setIfDifferent(ServerLevel level, BlockPos pos, BlockState state) {
        if (!level.getBlockState(pos).equals(state)) {
            level.setBlock(pos, state, 3);
        }
    }
}

