/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge;

import com.google.common.collect.Maps;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import lombok.Generated;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.william278.papiproxybridge.PAPIProxyBridge;
import net.william278.papiproxybridge.api.PlaceholderAPI;
import net.william278.papiproxybridge.config.Settings;
import net.william278.papiproxybridge.messenger.Messenger;
import net.william278.papiproxybridge.messenger.PluginMessageMessenger;
import net.william278.papiproxybridge.messenger.redis.RedisMessenger;
import net.william278.papiproxybridge.user.FabricUser;
import net.william278.papiproxybridge.user.OnlineUser;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricPAPIProxyBridge
implements DedicatedServerModInitializer,
PAPIProxyBridge {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"FabricPAPIProxyBridge");
    private Map<UUID, FabricUser> fabricUsers;
    private Settings settings;
    private Messenger messenger;

    public void onInitializeServer() {
        this.fabricUsers = Maps.newConcurrentMap();
        this.loadConfig();
        this.loadMessenger();
        this.messenger.onEnable();
        PlaceholderAPI.register(this);
        this.handleEvents();
        LOGGER.info(this.getLoadMessage());
    }

    private void handleEvents() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            FabricUser user = FabricUser.adapt(handler.field_14140);
            this.fabricUsers.put(user.getUniqueId(), user);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> this.fabricUsers.remove(handler.field_14140.method_5667()));
    }

    @Override
    public String getVersion() {
        return FabricLoader.getInstance().getModContainer("papiproxybridge").map(container -> container.getMetadata().getVersion().getFriendlyString()).orElse("Unknown");
    }

    @Override
    public String getServerType() {
        return "Fabric";
    }

    @NotNull
    public Collection<? extends FabricUser> getOnlineUsers() {
        return this.fabricUsers.values();
    }

    public Optional<FabricUser> findPlayer(@NotNull UUID uuid) {
        return Optional.ofNullable(this.fabricUsers.get(uuid));
    }

    @Override
    public CompletableFuture<String> createRequest(@NotNull String text, @NotNull OnlineUser requester, @NotNull UUID formatFor, boolean wantsJson, long requestTimeout) {
        String json = this.formatPlaceholders(formatFor, (FabricUser)requester, text).getString();
        return CompletableFuture.completedFuture(json);
    }

    @Override
    public CompletableFuture<Set<String>> getServers(long requestTimeout) {
        throw new UnsupportedOperationException("Cannot fetch the list of servers from a backend Fabric server.");
    }

    @Override
    public void log(@NotNull Level level, @NotNull String message, Throwable ... exceptions) {
        if (exceptions.length > 0) {
            LOGGER.error(message, exceptions[0]);
        } else {
            LOGGER.info(message);
        }
    }

    @Override
    public File getDataFolder() {
        File folder = FabricLoader.getInstance().getConfigDir().resolve("papiproxybridge").toFile();
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IllegalStateException("Failed to create data folder");
        }
        return folder;
    }

    @Override
    public void loadMessenger() {
        switch (this.settings.getMessenger()) {
            case REDIS: {
                this.messenger = new RedisMessenger(this, this.settings.getRedis(), true);
                break;
            }
            case PLUGIN_MESSAGE: {
                this.messenger = new PluginMessageMessenger(this);
            }
        }
        this.log(Level.INFO, "Loaded messenger " + this.settings.getMessenger().name(), new Throwable[0]);
    }

    @NotNull
    public final class_2561 formatPlaceholders(@NotNull UUID formatFor, @NotNull FabricUser requester, @NotNull String text) {
        text = text.replaceAll("%papiproxybridge_handshake%", "confirmed");
        return Placeholders.parseText((class_2561)class_2561.method_30163((String)text), (PlaceholderContext)PlaceholderContext.of((class_3222)this.findPlayer(formatFor).orElse(requester).player()));
    }

    @Generated
    public Map<UUID, FabricUser> getFabricUsers() {
        return this.fabricUsers;
    }

    @Override
    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    @Generated
    public Messenger getMessenger() {
        return this.messenger;
    }

    @Override
    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }
}

