/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.configlib.configlib;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.william278.papiproxybridge.libraries.configlib.configlib.ConfigurationElement;
import net.william278.papiproxybridge.libraries.configlib.configlib.FieldFilter;
import net.william278.papiproxybridge.libraries.configlib.configlib.FieldFilters;
import net.william278.papiproxybridge.libraries.configlib.configlib.NameFormatter;
import net.william278.papiproxybridge.libraries.configlib.configlib.NameFormatters;
import net.william278.papiproxybridge.libraries.configlib.configlib.Serializer;
import net.william278.papiproxybridge.libraries.configlib.configlib.SerializerContext;
import net.william278.papiproxybridge.libraries.configlib.configlib.Validator;

public class ConfigurationProperties {
    private final Map<Class<?>, Serializer<?, ?>> serializersByType;
    private final Map<Class<?>, Function<? super SerializerContext, ? extends Serializer<?, ?>>> serializerFactoriesByType;
    private final Map<Predicate<? super Type>, Serializer<?, ?>> serializersByCondition;
    private final Map<Predicate<? super ConfigurationElement<?>>, UnaryOperator<?>> postProcessorsByCondition;
    private final NameFormatter formatter;
    private final FieldFilter filter;
    private final boolean outputNulls;
    private final boolean inputNulls;
    private final boolean serializeSetsAsLists;

    protected ConfigurationProperties(Builder<?> builder) {
        this.serializersByType = Map.copyOf(builder.serializersByType);
        this.serializerFactoriesByType = Map.copyOf(builder.serializerFactoriesByType);
        this.serializersByCondition = Collections.unmodifiableMap(new LinkedHashMap(builder.serializersByCondition));
        this.postProcessorsByCondition = Collections.unmodifiableMap(new LinkedHashMap(builder.postProcessorsByCondition));
        this.formatter = Validator.requireNonNull(builder.formatter, "name formatter");
        this.filter = Validator.requireNonNull(builder.filter, "field filter");
        this.outputNulls = builder.outputNulls;
        this.inputNulls = builder.inputNulls;
        this.serializeSetsAsLists = builder.serializeSetsAsLists;
    }

    public static Builder<?> newBuilder() {
        return new BuilderImpl();
    }

    public Builder<?> toBuilder() {
        return new BuilderImpl(this);
    }

    public final FieldFilter getFieldFilter() {
        return this.filter;
    }

    public final NameFormatter getNameFormatter() {
        return this.formatter;
    }

    public final Map<Class<?>, Serializer<?, ?>> getSerializers() {
        return this.serializersByType;
    }

    public final Map<Class<?>, Function<? super SerializerContext, ? extends Serializer<?, ?>>> getSerializerFactories() {
        return this.serializerFactoriesByType;
    }

    final Map<Predicate<? super Type>, Serializer<?, ?>> getSerializersByCondition() {
        return this.serializersByCondition;
    }

    public final Map<Predicate<? super ConfigurationElement<?>>, UnaryOperator<?>> getPostProcessorsByCondition() {
        return this.postProcessorsByCondition;
    }

    public final boolean outputNulls() {
        return this.outputNulls;
    }

    public final boolean inputNulls() {
        return this.inputNulls;
    }

    final boolean serializeSetsAsLists() {
        return this.serializeSetsAsLists;
    }

    public static abstract class Builder<B extends Builder<B>> {
        private final Map<Class<?>, Serializer<?, ?>> serializersByType = new HashMap();
        private final Map<Class<?>, Function<? super SerializerContext, ? extends Serializer<?, ?>>> serializerFactoriesByType = new HashMap();
        private final Map<Predicate<? super Type>, Serializer<?, ?>> serializersByCondition = new LinkedHashMap();
        private final Map<Predicate<? super ConfigurationElement<?>>, UnaryOperator<?>> postProcessorsByCondition = new LinkedHashMap();
        private NameFormatter formatter = NameFormatters.IDENTITY;
        private FieldFilter filter = FieldFilters.DEFAULT;
        private boolean outputNulls = false;
        private boolean inputNulls = false;
        private boolean serializeSetsAsLists = true;

        protected Builder() {
        }

        protected Builder(ConfigurationProperties properties) {
            this.serializersByType.putAll(properties.serializersByType);
            this.serializerFactoriesByType.putAll(properties.serializerFactoriesByType);
            this.serializersByCondition.putAll(properties.serializersByCondition);
            this.postProcessorsByCondition.putAll(properties.postProcessorsByCondition);
            this.formatter = properties.formatter;
            this.filter = properties.filter;
            this.outputNulls = properties.outputNulls;
            this.inputNulls = properties.inputNulls;
            this.serializeSetsAsLists = properties.serializeSetsAsLists;
        }

        public final B setFieldFilter(FieldFilter filter) {
            this.filter = Validator.requireNonNull(filter, "field filter");
            return this.getThis();
        }

        public final B setNameFormatter(NameFormatter formatter) {
            this.formatter = Validator.requireNonNull(formatter, "name formatter");
            return this.getThis();
        }

        public final <T> B addSerializer(Class<T> serializedType, Serializer<? super T, ?> serializer) {
            Validator.requireNonNull(serializedType, "serialized type");
            Validator.requireNonNull(serializer, "serializer");
            this.serializersByType.put(serializedType, serializer);
            return this.getThis();
        }

        public final <T> B addSerializerFactory(Class<T> serializedType, Function<? super SerializerContext, ? extends Serializer<T, ?>> serializerFactory) {
            Validator.requireNonNull(serializedType, "serialized type");
            Validator.requireNonNull(serializerFactory, "serializer factory");
            this.serializerFactoriesByType.put(serializedType, serializerFactory);
            return this.getThis();
        }

        final B addSerializerByCondition(Predicate<? super Type> condition, Serializer<?, ?> serializer) {
            Validator.requireNonNull(condition, "condition");
            Validator.requireNonNull(serializer, "serializer");
            this.serializersByCondition.put(condition, serializer);
            return this.getThis();
        }

        public final B addPostProcessor(Predicate<? super ConfigurationElement<?>> condition, UnaryOperator<?> postProcessor) {
            Validator.requireNonNull(condition, "condition");
            Validator.requireNonNull(postProcessor, "post-processor");
            this.postProcessorsByCondition.put(condition, postProcessor);
            return this.getThis();
        }

        public final B outputNulls(boolean outputNulls) {
            this.outputNulls = outputNulls;
            return this.getThis();
        }

        public final B inputNulls(boolean inputNulls) {
            this.inputNulls = inputNulls;
            return this.getThis();
        }

        final B serializeSetsAsLists(boolean serializeSetsAsLists) {
            this.serializeSetsAsLists = serializeSetsAsLists;
            return this.getThis();
        }

        public abstract ConfigurationProperties build();

        protected abstract B getThis();
    }

    private static final class BuilderImpl
    extends Builder<BuilderImpl> {
        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationProperties properties) {
            super(properties);
        }

        @Override
        protected BuilderImpl getThis() {
            return this;
        }

        @Override
        public ConfigurationProperties build() {
            return new ConfigurationProperties(this);
        }
    }
}

