/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.reactor.core.publisher;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.CallSiteSupplierFactory;

final class Traces {
    static final boolean full = Boolean.parseBoolean(System.getProperty("net.william278.papiproxybridge.libraries.reactor.trace.assembly.fullstacktrace", "false"));
    static final String CALL_SITE_GLUE = " \u21e2 ";
    static final Supplier<Supplier<String>> callSiteSupplierFactory = new CallSiteSupplierFactory();

    Traces() {
    }

    static boolean shouldSanitize(String stackTraceRow) {
        return stackTraceRow.startsWith("java.util.function") || stackTraceRow.startsWith("net.william278.papiproxybridge.libraries.reactor.core.publisher.Mono.onAssembly") || stackTraceRow.equals("net.william278.papiproxybridge.libraries.reactor.core.publisher.Mono.onAssembly") || stackTraceRow.equals("net.william278.papiproxybridge.libraries.reactor.core.publisher.Flux.onAssembly") || stackTraceRow.equals("net.william278.papiproxybridge.libraries.reactor.core.publisher.ParallelFlux.onAssembly") || stackTraceRow.startsWith("net.william278.papiproxybridge.libraries.reactor.core.publisher.SignalLogger") || stackTraceRow.startsWith("net.william278.papiproxybridge.libraries.reactor.core.publisher.FluxOnAssembly") || stackTraceRow.startsWith("net.william278.papiproxybridge.libraries.reactor.core.publisher.MonoOnAssembly.") || stackTraceRow.startsWith("net.william278.papiproxybridge.libraries.reactor.core.publisher.MonoCallableOnAssembly.") || stackTraceRow.startsWith("net.william278.papiproxybridge.libraries.reactor.core.publisher.FluxCallableOnAssembly.") || stackTraceRow.startsWith("net.william278.papiproxybridge.libraries.reactor.core.publisher.Hooks") || stackTraceRow.startsWith("sun.reflect") || stackTraceRow.startsWith("java.util.concurrent.ThreadPoolExecutor") || stackTraceRow.startsWith("java.lang.reflect");
    }

    static String extractOperatorAssemblyInformation(String source) {
        CharSequence[] parts = Traces.extractOperatorAssemblyInformationParts(source);
        switch (parts.length) {
            case 0: {
                return "[no operator assembly information]";
            }
        }
        return String.join((CharSequence)CALL_SITE_GLUE, parts);
    }

    static boolean isUserCode(String line) {
        return !line.startsWith("net.william278.papiproxybridge.libraries.reactor.core.publisher") || line.contains("Test");
    }

    static String[] extractOperatorAssemblyInformationParts(String source) {
        String userCodeLine;
        String apiLine;
        int i;
        String[] uncleanTraces = source.split("\n");
        List traces = Stream.of(uncleanTraces).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (traces.isEmpty()) {
            return new String[0];
        }
        for (i = 0; i < traces.size() && !Traces.isUserCode((String)traces.get(i)); ++i) {
        }
        if (i == 0) {
            apiLine = "";
            userCodeLine = (String)traces.get(0);
        } else if (i == traces.size()) {
            apiLine = "";
            userCodeLine = ((String)traces.get(i - 1)).replaceFirst("net.william278.papiproxybridge.libraries.reactor.core.publisher.", "");
        } else {
            apiLine = (String)traces.get(i - 1);
            userCodeLine = (String)traces.get(i);
        }
        if (apiLine.isEmpty()) {
            return new String[]{userCodeLine};
        }
        int linePartIndex = apiLine.indexOf(40);
        if (linePartIndex > 0) {
            apiLine = apiLine.substring(0, linePartIndex);
        }
        apiLine = apiLine.replaceFirst("net.william278.papiproxybridge.libraries.reactor.core.publisher.", "");
        return new String[]{apiLine, "at " + userCodeLine};
    }
}

