/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.reactor.core.scheduler;

import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;
import net.william278.papiproxybridge.libraries.reactor.util.annotation.NonNull;
import net.william278.papiproxybridge.libraries.reactor.util.annotation.Nullable;

class VirtualThreadFactory
implements ThreadFactory,
Thread.UncaughtExceptionHandler {
    final ThreadFactory delegate;
    @Nullable
    final BiConsumer<Thread, Throwable> uncaughtExceptionHandler;

    VirtualThreadFactory(String name, boolean inheritThreadLocals, @Nullable BiConsumer<Thread, Throwable> uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.delegate = Thread.ofVirtual().name(name, 1L).uncaughtExceptionHandler((Thread.UncaughtExceptionHandler)this).inheritInheritableThreadLocals(inheritThreadLocals).factory();
    }

    @Override
    public final Thread newThread(@NonNull Runnable runnable) {
        return this.delegate.newThread(runnable);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (this.uncaughtExceptionHandler == null) {
            return;
        }
        this.uncaughtExceptionHandler.accept(t, e);
    }
}

