/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.user;

import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.william278.papiproxybridge.FabricPAPIProxyBridge;
import net.william278.papiproxybridge.PAPIProxyBridge;
import net.william278.papiproxybridge.user.OnlineUser;
import net.william278.papiproxybridge.user.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FabricUser(class_3222 player) implements OnlineUser
{
    @NotNull
    public static FabricUser adapt(@NotNull class_3222 player) {
        return new FabricUser(player);
    }

    @Override
    @NotNull
    public String getUsername() {
        return this.player.method_5477().getString();
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        return this.player.method_5667();
    }

    private Component getComponent(class_2561 text) {
        return GsonComponentSerializer.gson().deserialize((Object)class_2561.class_2562.method_10867((class_2561)text));
    }

    private Component translateKeys(TranslatableComponent translatable) {
        String key = translatable.key();
        @Nullable String translated = Objects.requireNonNullElse(class_2477.method_10517().method_4679(key, translatable.fallback()), key);
        return translatable.fallback(translated);
    }

    @Override
    public void handleMessage(@NotNull PAPIProxyBridge plugin, @NotNull Request message, boolean wantsJson) {
        FabricPAPIProxyBridge bridge = (FabricPAPIProxyBridge)plugin;
        class_2561 formatted = bridge.formatPlaceholders(message.getFormatFor(), this, message.getMessage());
        Component original = this.getComponent(formatted);
        Component transformed = ((Component)original.children().stream().map(component -> {
            if (component instanceof TranslatableComponent) {
                TranslatableComponent trans = (TranslatableComponent)component;
                return this.translateKeys(trans);
            }
            return component;
        }).collect(Component.toComponent())).mergeStyle(original);
        String response = wantsJson ? (String)GsonComponentSerializer.gson().serialize(transformed) : formatted.getString();
        message.setMessage(response);
        this.sendMessage(plugin, message, wantsJson, false);
    }
}

