/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.output;

import java.nio.ByteBuffer;
import net.william278.papiproxybridge.libraries.lettuce.core.ScoredValue;
import net.william278.papiproxybridge.libraries.lettuce.core.ScoredValueScanCursor;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceStrings;
import net.william278.papiproxybridge.libraries.lettuce.core.output.ScanOutput;

public class ScoredValueScanOutput<K, V>
extends ScanOutput<K, V, ScoredValueScanCursor<V>> {
    private V value;
    private boolean hasValue;

    public ScoredValueScanOutput(RedisCodec<K, V> codec) {
        super(codec, new ScoredValueScanCursor());
    }

    @Override
    protected void setOutput(ByteBuffer bytes) {
        if (!this.hasValue) {
            this.value = this.codec.decodeValue(bytes);
            this.hasValue = true;
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeString(bytes));
        this.set(score);
    }

    @Override
    public void set(double number) {
        if (this.hasValue) {
            ((ScoredValueScanCursor)this.output).getValues().add(ScoredValue.just(number, this.value));
        }
        this.value = null;
        this.hasValue = false;
    }
}

