/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.reactor.core.publisher;

import net.william278.papiproxybridge.libraries.reactor.core.CoreSubscriber;
import net.william278.papiproxybridge.libraries.reactor.core.Fuseable;
import net.william278.papiproxybridge.libraries.reactor.core.Scannable;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.FluxPeek;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.FluxPeekFuseable;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.InternalProducerAttr;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.ParallelFlux;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.SignalPeek;
import net.william278.papiproxybridge.libraries.reactor.util.annotation.Nullable;

final class ParallelLog<T>
extends ParallelFlux<T>
implements Scannable {
    final ParallelFlux<T> source;
    final SignalPeek<T> log;

    ParallelLog(ParallelFlux<T> source, SignalPeek<T> log) {
        this.source = ParallelFlux.from(source);
        this.log = log;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        CoreSubscriber[] parents = new CoreSubscriber[n];
        boolean conditional = subscribers[0] instanceof Fuseable.ConditionalSubscriber;
        for (int i = 0; i < n; ++i) {
            parents[i] = conditional ? new FluxPeekFuseable.PeekConditionalSubscriber<T>((Fuseable.ConditionalSubscriber)subscribers[i], this.log) : new FluxPeek.PeekSubscriber<T>(subscribers[i], this.log);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public int getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        if (key == InternalProducerAttr.INSTANCE) {
            return true;
        }
        return null;
    }
}

