/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.messenger;

import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import net.william278.papiproxybridge.BungeePAPIProxyBridge;
import net.william278.papiproxybridge.PAPIProxyBridge;
import net.william278.papiproxybridge.messenger.Messenger;
import net.william278.papiproxybridge.user.BungeeUser;
import org.jetbrains.annotations.NotNull;

public class PluginMessageMessenger
extends Messenger
implements Listener {
    private final BungeePAPIProxyBridge plugin;

    @Override
    public void onEnable() {
        this.plugin.getProxy().registerChannel(PAPIProxyBridge.getChannel(true));
        this.plugin.getProxy().registerChannel(PAPIProxyBridge.getComponentChannel(true));
        this.plugin.getProxy().registerChannel(PAPIProxyBridge.getChannel(false));
        this.plugin.getProxy().registerChannel(PAPIProxyBridge.getComponentChannel(false));
        this.plugin.getProxy().getPluginManager().registerListener((Plugin)this.plugin, (Listener)this);
    }

    @Override
    public void sendMessage(@NotNull UUID uuid, @NotNull String channel, byte @NotNull [] message) {
        Optional<BungeeUser> optionalBungeeUser = this.plugin.findPlayer(uuid);
        if (optionalBungeeUser.isEmpty()) {
            return;
        }
        BungeeUser user = optionalBungeeUser.get();
        ProxiedPlayer player = user.player();
        player.getServer().getInfo().sendData(channel, message);
    }

    @EventHandler
    public void onPluginMessageReceived(PluginMessageEvent event) {
        this.plugin.handleMessage(this.plugin, event.getTag(), event.getData(), false);
    }

    @Override
    public void onDisable() {
        this.plugin.getProxy().unregisterChannel(PAPIProxyBridge.getChannel(true));
        this.plugin.getProxy().unregisterChannel(PAPIProxyBridge.getComponentChannel(true));
        this.plugin.getProxy().unregisterChannel(PAPIProxyBridge.getChannel(false));
        this.plugin.getProxy().unregisterChannel(PAPIProxyBridge.getComponentChannel(false));
    }

    @Generated
    public PluginMessageMessenger(BungeePAPIProxyBridge plugin) {
        this.plugin = plugin;
    }
}

