/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.config;

import com.google.common.collect.Lists;
import java.util.List;
import lombok.Generated;
import net.william278.papiproxybridge.libraries.configlib.configlib.Comment;
import net.william278.papiproxybridge.libraries.configlib.configlib.Configuration;

@Configuration
public class Settings {
    @Comment(value={"The messenger to use for sending plugin messages. Options are PLUGIN_MESSAGE or REDIS."})
    private MessengerType messenger = MessengerType.PLUGIN_MESSAGE;
    private RedisSettings redis = new RedisSettings();

    @Generated
    public MessengerType getMessenger() {
        return this.messenger;
    }

    @Generated
    public RedisSettings getRedis() {
        return this.redis;
    }

    public static enum MessengerType {
        PLUGIN_MESSAGE,
        REDIS;

    }

    @Configuration
    public static class RedisSettings {
        @Comment(value={"Specify the credentials of your Redis server here. Set \"password\" to '' if you don't have one"})
        private RedisCredentials credentials = new RedisCredentials();
        @Comment(value={"Options for if you're using Redis sentinel. Don't modify this unless you know what you're doing!"})
        private RedisSentinel sentinel = new RedisSentinel();

        @Generated
        public RedisCredentials getCredentials() {
            return this.credentials;
        }

        @Generated
        public RedisSentinel getSentinel() {
            return this.sentinel;
        }

        @Generated
        private RedisSettings() {
        }

        @Configuration
        public static class RedisCredentials {
            private String host = "localhost";
            private int port = 6379;
            private String password = "";
            private boolean useSsl = false;

            @Generated
            public String getHost() {
                return this.host;
            }

            @Generated
            public int getPort() {
                return this.port;
            }

            @Generated
            public String getPassword() {
                return this.password;
            }

            @Generated
            public boolean isUseSsl() {
                return this.useSsl;
            }

            @Generated
            private RedisCredentials() {
            }
        }

        @Configuration
        public static class RedisSentinel {
            @Comment(value={"The master set name for the Redis sentinel."})
            private String master = "";
            @Comment(value={"List of host:port pairs"})
            private List<String> nodes = Lists.newArrayList();
            private String password = "";

            @Generated
            public String getMaster() {
                return this.master;
            }

            @Generated
            public List<String> getNodes() {
                return this.nodes;
            }

            @Generated
            public String getPassword() {
                return this.password;
            }

            @Generated
            private RedisSentinel() {
            }
        }
    }
}

