/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core;

import net.william278.papiproxybridge.libraries.lettuce.core.ConnectionBuilder;
import net.william278.papiproxybridge.libraries.lettuce.core.ConnectionEventTrigger;
import net.william278.papiproxybridge.libraries.lettuce.core.event.EventBus;
import net.william278.papiproxybridge.libraries.lettuce.core.event.connection.ConnectedEvent;
import net.william278.papiproxybridge.libraries.lettuce.core.event.connection.DisconnectedEvent;
import net.william278.papiproxybridge.libraries.lettuce.core.protocol.CommandHandler;
import net.william278.papiproxybridge.libraries.netty.channel.Channel;
import net.william278.papiproxybridge.libraries.netty.channel.ChannelHandlerContext;
import net.william278.papiproxybridge.libraries.netty.channel.ChannelInboundHandlerAdapter;
import net.william278.papiproxybridge.libraries.netty.channel.group.ChannelGroup;

class ChannelGroupListener
extends ChannelInboundHandlerAdapter {
    private final ChannelGroup channels;
    private final EventBus eventBus;

    public ChannelGroupListener(ChannelGroup channels, EventBus eventBus) {
        this.channels = channels;
        this.eventBus = eventBus;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        CommandHandler commandHandler = ChannelGroupListener.getCommandHandler(ctx);
        String epid = commandHandler.getEndpoint().getId();
        this.eventBus.publish(new ConnectedEvent(ChannelGroupListener.getRedisUri(ctx.channel()), epid, commandHandler.getChannelId(), ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
        this.channels.add(ctx.channel());
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        CommandHandler commandHandler = ChannelGroupListener.getCommandHandler(ctx);
        String epid = commandHandler.getEndpoint().getId();
        this.eventBus.publish(new DisconnectedEvent(ChannelGroupListener.getRedisUri(ctx.channel()), epid, commandHandler.getChannelId(), ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
        this.channels.remove(ctx.channel());
        super.channelInactive(ctx);
    }

    private static String getRedisUri(Channel channel) {
        String redisUri = null;
        if (channel.hasAttr(ConnectionBuilder.REDIS_URI)) {
            redisUri = channel.attr(ConnectionBuilder.REDIS_URI).get();
        }
        return redisUri;
    }

    private static CommandHandler getCommandHandler(ChannelHandlerContext ctx) {
        return ctx.pipeline().get(CommandHandler.class);
    }
}

