/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceAssert;

public final class LettuceLists {
    private LettuceLists() {
    }

    @SafeVarargs
    public static <T> List<T> newList(T ... elements) {
        LettuceAssert.notNull(elements, "Elements must not be null");
        ArrayList list = new ArrayList(elements.length);
        Collections.addAll(list, elements);
        return list;
    }

    public static <T> List<T> newList(Iterable<? extends T> elements) {
        LettuceAssert.notNull(elements, "Iterable must not be null");
        if (elements instanceof Collection) {
            return new ArrayList((Collection)elements);
        }
        return LettuceLists.newList(elements.iterator());
    }

    public static <T> List<T> newList(Iterator<? extends T> elements) {
        LettuceAssert.notNull(elements, "Iterator must not be null");
        ArrayList<T> objects = new ArrayList<T>();
        while (elements.hasNext()) {
            objects.add(elements.next());
        }
        return objects;
    }

    @SafeVarargs
    public static <T> List<T> unmodifiableList(T ... elements) {
        return Collections.unmodifiableList(LettuceLists.newList(elements));
    }

    public static <T> List<T> unmodifiableList(Collection<? extends T> elements) {
        return Collections.unmodifiableList(new ArrayList<T>(elements));
    }
}

