/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.output;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.william278.papiproxybridge.libraries.lettuce.core.KeyValue;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceAssert;
import net.william278.papiproxybridge.libraries.lettuce.core.output.CommandOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.ListSubscriber;
import net.william278.papiproxybridge.libraries.lettuce.core.output.OutputFactory;
import net.william278.papiproxybridge.libraries.lettuce.core.output.StreamingOutput;

public class KeyValueListOutput<K, V>
extends CommandOutput<K, V, List<KeyValue<K, V>>>
implements StreamingOutput<KeyValue<K, V>> {
    private boolean initialized;
    private StreamingOutput.Subscriber<KeyValue<K, V>> subscriber;
    private final Iterable<K> keys;
    private Iterator<K> keyIterator;
    private K key;
    private boolean hasKey;

    public KeyValueListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<KeyValue<K, V>>)ListSubscriber.instance());
        this.keys = null;
    }

    public KeyValueListOutput(RedisCodec<K, V> codec, Iterable<K> keys) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<KeyValue<K, V>>)ListSubscriber.instance());
        this.keys = keys;
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.keys == null) {
            if (!this.hasKey) {
                this.key = this.codec.decodeKey(bytes);
                this.hasKey = true;
                return;
            }
            K key = this.key;
            this.key = null;
            this.hasKey = false;
            this.subscriber.onNext((Collection)this.output, KeyValue.fromNullable(key, bytes == null ? null : (Object)this.codec.decodeValue(bytes)));
        } else {
            if (this.keyIterator == null) {
                this.keyIterator = this.keys.iterator();
            }
            this.subscriber.onNext((Collection)this.output, KeyValue.fromNullable(this.keyIterator.next(), bytes == null ? null : (Object)this.codec.decodeValue(bytes)));
        }
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<KeyValue<K, V>> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<KeyValue<K, V>> getSubscriber() {
        return this.subscriber;
    }
}

