/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.output;

import java.nio.ByteBuffer;
import net.william278.papiproxybridge.libraries.lettuce.core.KeyValue;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.output.CommandOutput;

public class KeyValueOutput<K, V>
extends CommandOutput<K, V, KeyValue<K, V>> {
    private K key;
    private boolean hasKey;

    public KeyValueOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes != null) {
            if (!this.hasKey) {
                this.key = this.codec.decodeKey(bytes);
                this.hasKey = true;
            } else {
                Object value = this.codec.decodeValue(bytes);
                this.output = KeyValue.fromNullable(this.key, value);
            }
        }
    }
}

