/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.output;

import java.nio.ByteBuffer;
import net.william278.papiproxybridge.libraries.lettuce.core.StreamScanCursor;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.output.KeyValueStreamingChannel;
import net.william278.papiproxybridge.libraries.lettuce.core.output.ScanOutput;

public class KeyValueScanStreamingOutput<K, V>
extends ScanOutput<K, V, StreamScanCursor> {
    private K key;
    private boolean hasKey;
    private KeyValueStreamingChannel<K, V> channel;

    public KeyValueScanStreamingOutput(RedisCodec<K, V> codec, KeyValueStreamingChannel<K, V> channel) {
        super(codec, new StreamScanCursor());
        this.channel = channel;
    }

    @Override
    protected void setOutput(ByteBuffer bytes) {
        if (!this.hasKey) {
            this.key = this.codec.decodeKey(bytes);
            this.hasKey = true;
            return;
        }
        Object value = bytes == null ? null : (Object)this.codec.decodeValue(bytes);
        this.channel.onKeyValue(this.key, value);
        ((StreamScanCursor)this.output).setCount(((StreamScanCursor)this.output).getCount() + 1L);
        this.key = null;
        this.hasKey = false;
    }
}

