/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.output;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.StringCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.internal.LettuceFactories;
import net.william278.papiproxybridge.libraries.lettuce.core.output.CommandOutput;
import net.william278.papiproxybridge.libraries.lettuce.core.output.OutputFactory;

public class NestedMultiOutput<K, V>
extends CommandOutput<K, V, List<Object>> {
    private final Deque<List<Object>> stack = LettuceFactories.newSpScQueue();
    private int depth = 0;
    private boolean initialized;

    public NestedMultiOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
    }

    @Override
    public void set(long integer) {
        if (!this.initialized) {
            this.output = new ArrayList();
        }
        ((List)this.output).add(integer);
    }

    @Override
    public void set(double number) {
        if (!this.initialized) {
            this.output = new ArrayList();
        }
        ((List)this.output).add(number);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (!this.initialized) {
            this.output = new ArrayList();
        }
        ((List)this.output).add(bytes == null ? null : (Object)this.codec.decodeValue(bytes));
    }

    @Override
    public void setSingle(ByteBuffer bytes) {
        if (!this.initialized) {
            this.output = new ArrayList();
        }
        ((List)this.output).add(bytes == null ? null : StringCodec.UTF8.decodeValue(bytes));
    }

    @Override
    public void complete(int depth) {
        if (depth > 0 && depth < this.depth) {
            this.output = this.stack.pop();
            --this.depth;
        }
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(Math.max(1, count));
            this.initialized = true;
        }
        List a = OutputFactory.newList(count);
        ((List)this.output).add(a);
        this.stack.push((List<Object>)this.output);
        this.output = a;
        ++this.depth;
    }
}

