/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.lettuce.core.output;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import net.william278.papiproxybridge.libraries.lettuce.core.Range;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.RedisCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.codec.StringCodec;
import net.william278.papiproxybridge.libraries.lettuce.core.models.stream.PendingMessages;
import net.william278.papiproxybridge.libraries.lettuce.core.output.CommandOutput;

public class PendingMessagesOutput<K, V>
extends CommandOutput<K, V, PendingMessages> {
    private Long count;
    private String messageIdsFrom;
    private String messageIdsTo;
    private String consumer;
    private boolean hasConsumer;
    private final Map<String, Long> consumerMessageCount = new LinkedHashMap<String, Long>();

    public PendingMessagesOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.messageIdsFrom == null) {
            this.messageIdsFrom = this.decodeString(bytes);
            return;
        }
        if (this.messageIdsTo == null) {
            this.messageIdsTo = this.decodeString(bytes);
            return;
        }
        if (!this.hasConsumer) {
            this.consumer = StringCodec.UTF8.decodeKey(bytes);
            this.hasConsumer = true;
            return;
        }
        this.set(Long.parseLong(this.decodeString(bytes)));
    }

    @Override
    public void set(long integer) {
        if (this.count == null) {
            this.count = integer;
            return;
        }
        if (this.hasConsumer) {
            this.consumerMessageCount.put(this.consumer, integer);
            this.consumer = null;
            this.hasConsumer = false;
        }
    }

    @Override
    public void complete(int depth) {
        if (depth == 0) {
            Range<String> range = this.messageIdsFrom != null && this.messageIdsTo != null ? Range.create(this.messageIdsFrom, this.messageIdsTo) : Range.unbounded();
            this.output = new PendingMessages(this.count == null ? 0L : this.count, range, this.consumerMessageCount);
        }
    }
}

